/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.file.transfer.FileTransfer;
import org.apache.nifi.processor.util.file.transfer.PutFileTransfer;
import org.apache.nifi.processors.standard.GetSFTP;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.SFTPTransfer;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"remote", "copy", "egress", "put", "sftp", "archive", "files"})
@CapabilityDescription(value="Sends FlowFiles to an SFTP Server")
@SeeAlso(value={GetSFTP.class})
public class PutSFTP
extends PutFileTransfer<SFTPTransfer> {
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(FileTransfer.HOSTNAME, SFTPTransfer.PORT, FileTransfer.USERNAME, FileTransfer.PASSWORD, SFTPTransfer.PRIVATE_KEY_PATH, SFTPTransfer.PRIVATE_KEY_PASSPHRASE, FileTransfer.REMOTE_PATH, FileTransfer.CREATE_DIRECTORY, SFTPTransfer.DISABLE_DIRECTORY_LISTING, FileTransfer.BATCH_SIZE, FileTransfer.CONNECTION_TIMEOUT, FileTransfer.DATA_TIMEOUT, FileTransfer.CONFLICT_RESOLUTION, FileTransfer.REJECT_ZERO_BYTE, FileTransfer.DOT_RENAME, FileTransfer.TEMP_FILENAME, SFTPTransfer.HOST_KEY_FILE, FileTransfer.LAST_MODIFIED_TIME, FileTransfer.PERMISSIONS, FileTransfer.REMOTE_OWNER, FileTransfer.REMOTE_GROUP, SFTPTransfer.STRICT_HOST_KEY_CHECKING, SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT, FileTransfer.USE_COMPRESSION, SFTPTransfer.PROXY_CONFIGURATION_SERVICE, SFTPTransfer.ALGORITHM_CONFIGURATION, SFTPTransfer.CIPHERS_ALLOWED, SFTPTransfer.KEY_ALGORITHMS_ALLOWED, SFTPTransfer.KEY_EXCHANGE_ALGORITHMS_ALLOWED, SFTPTransfer.MESSAGE_AUTHENTICATION_CODES_ALLOWED);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        FTPTransfer.migrateProxyProperties(config);
        SFTPTransfer.migrateAlgorithmProperties(config);
    }

    protected SFTPTransfer getFileTransfer(ProcessContext context) {
        return new SFTPTransfer((PropertyContext)context, this.getLogger());
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        SFTPTransfer.validateProxySpec(validationContext, results);
        return results;
    }
}

