/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCases;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.StandardFlowFileMediaType;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.FlowFileFilters;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.InvokeHTTP;
import org.apache.nifi.processors.standard.ListenHTTP;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.processors.standard.UnpackContent;
import org.apache.nifi.util.FlowFilePackager;
import org.apache.nifi.util.FlowFilePackagerV3;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"flowfile", "flowfile-stream", "flowfile-stream-v3", "package", "attributes"})
@CapabilityDescription(value="This processor will package FlowFile attributes and content into an output FlowFile that can be exported from NiFi and imported back into NiFi, preserving the original attributes and content.")
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="The mime.type will be changed to application/flowfile-v3")})
@SeeAlso(value={UnpackContent.class, MergeContent.class})
@MultiProcessorUseCases(value={@MultiProcessorUseCase(description="Send FlowFile content and attributes from one NiFi instance to another NiFi instance.", notes="A Remote Process Group is preferred to send FlowFiles between two NiFi instances, but an alternative is to use PackageFlowFile then InvokeHTTP sending to ListenHTTP.", keywords={"flowfile", "attributes", "content", "ffv3", "flowfile-stream-v3", "transfer"}, configurations={@ProcessorConfiguration(processorClass=PackageFlowFile.class, configuration="    \"Maximum Batch Size\" > 1 can improve storage or transmission efficiency by batching many FlowFiles together into 1 larger file.\n    \"Maximum Batch Content Size\" can be used to enforce a soft upper limit on the overall package size.\n\n    Note, that the Batch properties only restrict the maximum amount of FlowFiles to incorporate into a single package.\n    In case less FlowFiles are queued than the properties allow for,\n    the processor will not wait for the limits to be reached but create smaller packages instead.\n\n    Connect the success relationship of PackageFlowFile to the input of InvokeHTTP.\n"), @ProcessorConfiguration(processorClass=InvokeHTTP.class, configuration="    \"HTTP Method\" = \"POST\" to send data to ListenHTTP.\n    \"HTTP URL\" should include the hostname, port, and path to the ListenHTTP.\n    \"Request Content-Type\" = \"${mime.type}\" because PackageFlowFile output files have attribute mime.type=application/flowfile-v3.\n"), @ProcessorConfiguration(processorClass=ListenHTTP.class, configuration="    \"Listening Port\" = a unique port number.\n\n    ListenHTTP automatically unpacks files that have attribute mime.type=application/flowfile-v3.\n    If PackageFlowFile batches 99 FlowFiles into 1 file that InvokeHTTP sends, then the original 99 FlowFiles will be output by ListenHTTP.\n")}), @MultiProcessorUseCase(description="Export FlowFile content and attributes from NiFi to external storage and reimport.", keywords={"flowfile", "attributes", "content", "ffv3", "flowfile-stream-v3", "offline", "storage"}, configurations={@ProcessorConfiguration(processorClass=PackageFlowFile.class, configuration="    \"Maximum Batch Size\" > 1 can improve storage or transmission efficiency by batching many FlowFiles together into 1 larger file.\n    \"Maximum Batch Content Size\" can be used to enforce a soft upper limit on the overall package size.\n\n    Note, that the Batch properties only restrict the maximum amount of FlowFiles to incorporate into a single package.\n    In case less FlowFiles are queued than the properties allow for,\n    the processor will not wait for the limits to be reached but create smaller packages instead.\n\n    Connect the success relationship to the input of any NiFi egress processor for offline storage.\n"), @ProcessorConfiguration(processorClass=UnpackContent.class, configuration="    \"Packaging Format\" = \"application/flowfile-v3\".\n\n    Connect the output of a NiFi ingress processor that reads files stored offline to the input of UnpackContent.\n    If PackageFlowFile batches 99 FlowFiles into 1 file that is read from storage, then the original 99 FlowFiles will be output by UnpackContent.\n")})})
public class PackageFlowFile
extends AbstractProcessor {
    public static final String BATCHING_BEHAVIOUR_DESCRIPTION = "    \"Maximum Batch Size\" > 1 can improve storage or transmission efficiency by batching many FlowFiles together into 1 larger file.\n    \"Maximum Batch Content Size\" can be used to enforce a soft upper limit on the overall package size.\n\n    Note, that the Batch properties only restrict the maximum amount of FlowFiles to incorporate into a single package.\n    In case less FlowFiles are queued than the properties allow for,\n    the processor will not wait for the limits to be reached but create smaller packages instead.\n";
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Maximum Batch Size").description("Maximum number of FlowFiles to package into one output FlowFile.").required(true).defaultValue("1").addValidator(StandardValidators.createLongValidator((long)1L, (long)10000L, (boolean)true)).build();
    public static final PropertyDescriptor BATCH_CONTENT_SIZE = new PropertyDescriptor.Builder().name("Maximum Batch Content Size").description("Maximum combined content size of FlowFiles to package into one output FlowFile. Note, that FlowFiles whose content exceeds this limit are packaged separately.").required(true).defaultValue("1 GB").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BATCH_SIZE, BATCH_CONTENT_SIZE);
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The packaged FlowFile is sent to this relationship").build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The FlowFiles that were used to create the package are sent to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_ORIGINAL);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFileFilter filter = FlowFileFilters.newSizeBasedFilter((double)context.getProperty(BATCH_CONTENT_SIZE).asDataSize(DataUnit.B), (DataUnit)DataUnit.B, (int)context.getProperty(BATCH_SIZE).asInteger());
        List flowFiles = session.get(filter);
        if (flowFiles.isEmpty()) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.MIME_TYPE.key(), StandardFlowFileMediaType.VERSION_3.getMediaType());
        FlowFilePackagerV3 packager = new FlowFilePackagerV3();
        FlowFile packagedFlowFile = session.create((Collection)flowFiles);
        packagedFlowFile = session.write(packagedFlowFile, arg_0 -> PackageFlowFile.lambda$onTrigger$1(flowFiles, session, (FlowFilePackager)packager, arg_0));
        packagedFlowFile = session.putAllAttributes(packagedFlowFile, attributes);
        session.transfer(packagedFlowFile, REL_SUCCESS);
        session.transfer((Collection)flowFiles, REL_ORIGINAL);
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("max-batch-size", BATCH_SIZE.getName());
    }

    private static /* synthetic */ void lambda$onTrigger$1(List flowFiles, ProcessSession session, FlowFilePackager packager, OutputStream out) throws IOException {
        try (BufferedOutputStream bufferedOut = new BufferedOutputStream(out);){
            for (FlowFile flowFile : flowFiles) {
                session.read(flowFile, in -> {
                    try (BufferedInputStream bufferedIn = new BufferedInputStream(in);){
                        packager.packageFlowFile((InputStream)bufferedIn, bufferedOut, flowFile.getAttributes(), flowFile.getSize());
                    }
                });
            }
        }
    }
}

