/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.eclipse.jetty.util.StringUtil;

@SideEffectFree
@SupportsBatching(defaultDuration=DefaultRunDuration.TWENTY_FIVE_MILLIS)
@Tags(value={"attributes", "logging"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Emits a log message at the specified log level")
public class LogMessage
extends AbstractProcessor {
    private static final Pattern LOG_LEVEL_PATTERN = Pattern.compile("^(?i)(?:trace|debug|info|warn|error)$");
    private static final Validator LOG_LEVEL_VALIDATOR = (subject, input, context) -> {
        boolean matches = LOG_LEVEL_PATTERN.matcher(input).matches();
        if (matches || context.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
        }
        return new ValidationResult.Builder().subject(subject).valid(false).explanation(String.format("%s must be either trace, debug, info, warn or error", subject)).input(input).build();
    };
    public static final PropertyDescriptor LOG_LEVEL = new PropertyDescriptor.Builder().name("Log Level").required(true).description("The Log Level to use when logging the message: %s (case-insensitive)".formatted(Arrays.stream(MessageLogLevel.values()).map(Enum::name).collect(Collectors.joining(", ")))).addValidator(LOG_LEVEL_VALIDATOR).defaultValue(MessageLogLevel.info.toString()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor LOG_PREFIX = new PropertyDescriptor.Builder().name("Log Prefix").required(false).description("Log prefix appended to the log lines. It helps to distinguish the output of multiple LogMessage processors.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor LOG_MESSAGE = new PropertyDescriptor.Builder().name("Log Message").required(false).description("The log message to emit").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(LOG_LEVEL, LOG_PREFIX, LOG_MESSAGE);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are routed to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        boolean isLogLevelEnabled;
        MessageLogLevel logLevel;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String logLevelValue = context.getProperty(LOG_LEVEL).evaluateAttributeExpressions(flowFile).getValue().toLowerCase();
        try {
            logLevel = MessageLogLevel.valueOf(logLevelValue);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        ComponentLog logger = this.getLogger();
        switch (logLevel.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean bl = logger.isTraceEnabled();
                break;
            }
            case 1: {
                boolean bl = logger.isDebugEnabled();
                break;
            }
            case 2: {
                boolean bl = logger.isInfoEnabled();
                break;
            }
            case 3: {
                boolean bl = logger.isWarnEnabled();
                break;
            }
            case 4: {
                boolean bl = isLogLevelEnabled = logger.isErrorEnabled();
            }
        }
        if (isLogLevelEnabled) {
            this.processFlowFile(logger, logLevel, flowFile, context);
        }
        session.transfer(flowFile, REL_SUCCESS);
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("log-level", LOG_LEVEL.getName());
        config.renameProperty("log-prefix", LOG_PREFIX.getName());
        config.renameProperty("log-message", LOG_MESSAGE.getName());
    }

    private void processFlowFile(ComponentLog logger, MessageLogLevel logLevel, FlowFile flowFile, ProcessContext context) {
        String logPrefix = context.getProperty(LOG_PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        String logMessage = context.getProperty(LOG_MESSAGE).evaluateAttributeExpressions(flowFile).getValue();
        String messageToWrite = StringUtil.isBlank((String)logPrefix) ? logMessage : String.format("%s%s", logPrefix, logMessage);
        switch (logLevel.ordinal()) {
            case 2: {
                logger.info(messageToWrite);
                break;
            }
            case 1: {
                logger.debug(messageToWrite);
                break;
            }
            case 3: {
                logger.warn(messageToWrite);
                break;
            }
            case 0: {
                logger.trace(messageToWrite);
                break;
            }
            case 4: {
                logger.error(messageToWrite);
            }
        }
    }

    static enum MessageLogLevel {
        trace,
        debug,
        info,
        warn,
        error;

    }
}

