/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.database.dialect.service.api.ColumnDefinition;
import org.apache.nifi.database.dialect.service.api.DatabaseDialectService;
import org.apache.nifi.database.dialect.service.api.QueryStatementRequest;
import org.apache.nifi.database.dialect.service.api.StandardColumnDefinition;
import org.apache.nifi.database.dialect.service.api.StandardQueryStatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementType;
import org.apache.nifi.database.dialect.service.api.TableDefinition;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.db.DatabaseAdapterDescriptor;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractDatabaseFetchProcessor
extends AbstractSessionFactoryProcessor {
    public static final String INITIAL_MAX_VALUE_PROP_START = "initial.maxvalue.";
    public static final String FRAGMENT_ID = FragmentAttributes.FRAGMENT_ID.key();
    public static final String FRAGMENT_INDEX = FragmentAttributes.FRAGMENT_INDEX.key();
    public static final String FRAGMENT_COUNT = FragmentAttributes.FRAGMENT_COUNT.key();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    protected Set<Relationship> relationships;
    public static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database.").required(true).identifiesControllerService(DBCPService.class).build();
    public static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("Table Name").description("The name of the database table to be queried.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor COLUMN_NAMES = new PropertyDescriptor.Builder().name("Columns to Return").description("A comma-separated list of column names to be used in the query. If your database requires special treatment of the names (quoting, e.g.), each name should include such treatment. If no column names are supplied, all columns in the specified table will be returned. NOTE: It is important to use consistent column names for a given table for incremental fetch to work properly.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor MAX_VALUE_COLUMN_NAMES = new PropertyDescriptor.Builder().name("Maximum-value Columns").description("A comma-separated list of column names. The processor will keep track of the maximum value for each column that has been returned since the processor started running. Using multiple columns implies an order to the column list, and each column's values are expected to increase more slowly than the previous columns' values. Thus, using multiple columns implies a hierarchical structure of columns, which is usually used for partitioning tables. This processor can be used to retrieve only those rows that have been added/updated since the last retrieval. Note that some JDBC types such as bit/boolean are not conducive to maintaining maximum value, so columns of these types should not be listed in this property, and will result in error(s) during processing. If no columns are provided, all rows from the table will be considered, which could have a performance impact. NOTE: It is important to use consistent max-value column names for a given table for incremental fetch to work properly.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("Max Wait Time").description("The maximum amount of time allowed for a running SQL select query , zero means there is no limit. Max time less than 1 second will be equal to zero.").defaultValue("0 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor WHERE_CLAUSE = new PropertyDescriptor.Builder().name("Additional WHERE Clause").description("A custom clause to be added in the WHERE condition when building SQL queries.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SQL_QUERY = new PropertyDescriptor.Builder().name("Custom Query").description("A custom SQL query used to retrieve data. Instead of building a SQL query from other properties, this query will be wrapped as a sub-query. Query must have no ORDER BY statement.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected List<PropertyDescriptor> propDescriptors;
    protected static final String NAMESPACE_DELIMITER = "@!@";
    public static final PropertyDescriptor DB_TYPE = DatabaseAdapterDescriptor.getDatabaseTypeDescriptor();
    static final PropertyDescriptor DATABASE_DIALECT_SERVICE = DatabaseAdapterDescriptor.getDatabaseDialectServiceDescriptor(DB_TYPE);
    protected final Map<String, Integer> columnTypeMap = new HashMap<String, Integer>();
    protected volatile boolean isDynamicTableName = false;
    protected volatile boolean isDynamicMaxValues = false;
    protected final AtomicBoolean setupComplete = new AtomicBoolean(false);
    private static final DateTimeFormatter TIME_TYPE_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final String ZERO_RESULT_WHERE_CLAUSE = "1 = 0";
    protected Map<String, String> maxValueProperties;

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("db-fetch-db-type", DB_TYPE.getName());
        config.renameProperty("db-fetch-where-clause", WHERE_CLAUSE.getName());
        config.renameProperty("db-fetch-sql-query", SQL_QUERY.getName());
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        this.isDynamicTableName = validationContext.isExpressionLanguagePresent(validationContext.getProperty(TABLE_NAME).getValue());
        this.isDynamicMaxValues = validationContext.isExpressionLanguagePresent(validationContext.getProperty(MAX_VALUE_COLUMN_NAMES).getValue());
        return super.customValidate(validationContext);
    }

    public void setup(ProcessContext context) {
        this.setup(context, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(ProcessContext context, boolean shouldCleanCache, FlowFile flowFile) {
        DatabaseDialectService databaseDialectService = this.getDatabaseDialectService((PropertyContext)context);
        AtomicBoolean atomicBoolean = this.setupComplete;
        synchronized (atomicBoolean) {
            block23: {
                this.setupComplete.set(false);
                String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).evaluateAttributeExpressions(flowFile).getValue();
                if (StringUtils.isEmpty((String)maxValueColumnNames)) {
                    this.setupComplete.set(true);
                    return;
                }
                DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
                String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
                String sqlQuery = context.getProperty(SQL_QUERY).evaluateAttributeExpressions().getValue();
                try (Connection con = dbcpService.getConnection(flowFile == null ? Collections.emptyMap() : flowFile.getAttributes());
                     Statement st = con.createStatement();){
                    QueryStatementRequest statementRequest = this.getMaxValueStatementRequest(tableName, maxValueColumnNames, sqlQuery);
                    StatementResponse statementResponse = databaseDialectService.getStatement((StatementRequest)statementRequest);
                    String query = statementResponse.sql();
                    ResultSet resultSet = st.executeQuery(query);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int numCols = resultSetMetaData.getColumnCount();
                    if (numCols > 0) {
                        String colKey;
                        if (shouldCleanCache) {
                            this.columnTypeMap.clear();
                        }
                        String[] maxValueColumnNameList = maxValueColumnNames.toLowerCase().split(",");
                        ArrayList<String> maxValueQualifiedColumnNameList = new ArrayList<String>();
                        for (String maxValueColumn : maxValueColumnNameList) {
                            colKey = AbstractDatabaseFetchProcessor.getStateKey(tableName, maxValueColumn.trim());
                            maxValueQualifiedColumnNameList.add(colKey);
                        }
                        for (int i = 1; i <= numCols; ++i) {
                            String colName = resultSetMetaData.getColumnName(i).toLowerCase();
                            String colKey2 = AbstractDatabaseFetchProcessor.getStateKey(tableName, colName);
                            if (!maxValueQualifiedColumnNameList.contains(colKey2)) continue;
                            int colType = resultSetMetaData.getColumnType(i);
                            this.columnTypeMap.putIfAbsent(colKey2, colType);
                        }
                        for (String maxValueColumn : maxValueColumnNameList) {
                            colKey = AbstractDatabaseFetchProcessor.getStateKey(tableName, maxValueColumn.trim().toLowerCase());
                            if (this.columnTypeMap.containsKey(colKey)) continue;
                            throw new ProcessException("Column not found in the table/query specified: " + maxValueColumn);
                        }
                        break block23;
                    }
                    throw new ProcessException("No columns found in table from those specified: " + maxValueColumnNames);
                }
                catch (SQLException e) {
                    throw new ProcessException("Unable to communicate with database in order to determine column types", (Throwable)e);
                }
            }
            this.setupComplete.set(true);
        }
    }

    protected DatabaseDialectService getDatabaseDialectService(PropertyContext context) {
        String databaseType = context.getProperty(DB_TYPE).getValue();
        return DatabaseAdapterDescriptor.getDatabaseDialectService(context, DATABASE_DIALECT_SERVICE, databaseType);
    }

    private QueryStatementRequest getMaxValueStatementRequest(String tableName, String maxValueColumnNames, String derivedTableQuery) {
        List<ColumnDefinition> maxValueColumns = Arrays.stream(maxValueColumnNames.split(",")).map(StandardColumnDefinition::new).map(ColumnDefinition.class::cast).toList();
        TableDefinition tableDefinition = new TableDefinition(Optional.empty(), Optional.empty(), tableName, maxValueColumns);
        return new StandardQueryStatementRequest(StatementType.SELECT, tableDefinition, Optional.ofNullable(derivedTableQuery), Optional.of(ZERO_RESULT_WHERE_CLAUSE), Optional.empty(), Optional.empty());
    }

    protected static String getMaxValueFromRow(ResultSet resultSet, int columnIndex, Integer type, String maxValueString) throws ParseException, IOException, SQLException {
        if (type == null || resultSet.getObject(columnIndex) == null) {
            return null;
        }
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String colStringValue = resultSet.getString(columnIndex);
                if (maxValueString != null && colStringValue.compareTo(maxValueString) <= 0) break;
                return colStringValue;
            }
            case -6: 
            case 4: 
            case 5: {
                int colIntValue = resultSet.getInt(columnIndex);
                Integer maxIntValue = null;
                if (maxValueString != null) {
                    maxIntValue = Integer.valueOf(maxValueString);
                }
                if (maxIntValue != null && colIntValue <= maxIntValue) break;
                return Integer.toString(colIntValue);
            }
            case -5: {
                long colLongValue = resultSet.getLong(columnIndex);
                Long maxLongValue = null;
                if (maxValueString != null) {
                    maxLongValue = Long.valueOf(maxValueString);
                }
                if (maxLongValue != null && colLongValue <= maxLongValue) break;
                return Long.toString(colLongValue);
            }
            case 6: 
            case 7: 
            case 8: {
                double colDoubleValue = resultSet.getDouble(columnIndex);
                Double maxDoubleValue = null;
                if (maxValueString != null) {
                    maxDoubleValue = Double.valueOf(maxValueString);
                }
                if (maxDoubleValue != null && !(colDoubleValue > maxDoubleValue)) break;
                return Double.toString(colDoubleValue);
            }
            case 2: 
            case 3: {
                BigDecimal colBigDecimalValue = resultSet.getBigDecimal(columnIndex);
                BigDecimal maxBigDecimalValue = null;
                if (maxValueString != null) {
                    DecimalFormat df = new DecimalFormat();
                    df.setParseBigDecimal(true);
                    maxBigDecimalValue = (BigDecimal)df.parse(maxValueString);
                }
                if (maxBigDecimalValue != null && colBigDecimalValue.compareTo(maxBigDecimalValue) <= 0) break;
                return colBigDecimalValue.toString();
            }
            case 91: {
                Date rawColDateValue = resultSet.getDate(columnIndex);
                Date colDateValue = new Date(rawColDateValue.getTime());
                Date maxDateValue = null;
                if (maxValueString != null) {
                    maxDateValue = Date.valueOf(maxValueString);
                }
                if (maxDateValue != null && !colDateValue.after(maxDateValue)) break;
                return colDateValue.toString();
            }
            case 92: {
                Instant colTimeValue = Instant.ofEpochMilli(resultSet.getTimestamp(columnIndex).getTime());
                LocalTime maxTimeValue = null;
                if (maxValueString != null) {
                    try {
                        maxTimeValue = LocalTime.parse(maxValueString, TIME_TYPE_FORMAT);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                }
                if (maxTimeValue != null && !colTimeValue.isAfter(maxTimeValue.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant())) break;
                return TIME_TYPE_FORMAT.format(LocalTime.ofInstant(colTimeValue, ZoneId.systemDefault()));
            }
            case 93: {
                Timestamp colTimestampValue = resultSet.getTimestamp(columnIndex);
                Timestamp maxTimestampValue = null;
                if (maxValueString != null) {
                    try {
                        maxTimestampValue = Timestamp.valueOf(maxValueString);
                    }
                    catch (IllegalArgumentException iae) {
                        maxTimestampValue = new Timestamp(Date.valueOf(maxValueString).getTime());
                    }
                }
                if (maxTimestampValue != null && !colTimestampValue.after(maxTimestampValue)) break;
                return colTimestampValue.toString();
            }
            default: {
                throw new IOException("Type for column " + columnIndex + " is not valid for maintaining maximum value");
            }
        }
        return null;
    }

    protected static String getLiteralByType(int type, String value, String databaseType) {
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return "'" + value + "'";
            }
            case 92: {
                if ("Phoenix".equals(databaseType)) {
                    return "time '" + value + "'";
                }
            }
            case 91: 
            case 93: {
                if (!StringUtils.isEmpty((String)databaseType) && (databaseType.contains("Oracle") || "Phoenix".equals(databaseType))) {
                    if (value.matches("\\d{4}-\\d{2}-\\d{2}")) {
                        return "date '" + value + "'";
                    }
                    return "timestamp '" + value + "'";
                }
                return "'" + value + "'";
            }
        }
        return value;
    }

    protected static String getStateKey(String prefix, String columnName) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            String prefixUnwrapped = prefix.toLowerCase().replaceAll("[\"`\\[\\]]", "");
            sb.append(prefixUnwrapped);
            sb.append(NAMESPACE_DELIMITER);
        }
        if (columnName != null) {
            String columnNameUnwrapped = columnName.toLowerCase().replaceAll("[\"`\\[\\]]", "");
            sb.append(columnNameUnwrapped);
        }
        return sb.toString();
    }

    protected Map<String, String> getDefaultMaxValueProperties(ProcessContext context, FlowFile flowFile) {
        HashMap<String, String> defaultMaxValues = new HashMap<String, String>();
        context.getProperties().forEach((k, v) -> {
            String key = k.getName();
            if (key.startsWith(INITIAL_MAX_VALUE_PROP_START)) {
                defaultMaxValues.put(key.substring(INITIAL_MAX_VALUE_PROP_START.length()), context.getProperty(k).evaluateAttributeExpressions(flowFile).getValue());
            }
        });
        return defaultMaxValues;
    }
}

