/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.command.Command;
import org.apache.ftpserver.command.CommandFactory;
import org.apache.ftpserver.command.CommandFactoryFactory;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.ftp.FtpServer;
import org.apache.nifi.processors.standard.ftp.commands.CommandMapFactory;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFileSystemFactory;
import org.apache.nifi.ssl.SSLContextProvider;

public class NifiFtpServer
implements FtpServer {
    private final org.apache.ftpserver.FtpServer server;

    private NifiFtpServer(Map<String, Command> commandMap, FileSystemFactory fileSystemFactory, ConnectionConfig connectionConfig, Listener listener, User user) throws ProcessException {
        try {
            FtpServerFactory serverFactory = new FtpServerFactory();
            serverFactory.setFileSystem(fileSystemFactory);
            serverFactory.setCommandFactory(this.createCommandFactory(commandMap));
            serverFactory.setConnectionConfig(connectionConfig);
            serverFactory.addListener("default", listener);
            serverFactory.getUserManager().save(user);
            this.server = serverFactory.createServer();
        }
        catch (Exception exception) {
            throw new ProcessException("FTP server could not be started.", (Throwable)exception);
        }
    }

    private CommandFactory createCommandFactory(Map<String, Command> commandMap) {
        CommandFactoryFactory commandFactoryFactory = new CommandFactoryFactory();
        commandFactoryFactory.setUseDefaultCommands(false);
        commandFactoryFactory.setCommandMap(commandMap);
        return commandFactoryFactory.createCommandFactory();
    }

    @Override
    public void start() throws ProcessException {
        try {
            this.server.start();
        }
        catch (Exception exception) {
            throw new ProcessException("FTP server could not be started.", (Throwable)exception);
        }
    }

    @Override
    public void stop() {
        this.server.stop();
    }

    @Override
    public boolean isStopped() {
        return this.server.isStopped();
    }

    private static class StandardSslConfiguration
    implements SslConfiguration {
        private final SSLContext sslContext;
        private final SSLParameters sslParameters;

        private StandardSslConfiguration(SSLContext sslContext) {
            this.sslContext = sslContext;
            this.sslParameters = sslContext.getDefaultSSLParameters();
        }

        public SSLSocketFactory getSocketFactory() {
            return this.sslContext.getSocketFactory();
        }

        public SSLContext getSSLContext() {
            return this.sslContext;
        }

        public SSLContext getSSLContext(String enabledProtocol) {
            return this.sslContext;
        }

        public String[] getEnabledCipherSuites() {
            return this.sslParameters.getCipherSuites();
        }

        public String[] getEnabledProtocols() {
            return this.sslParameters.getProtocols();
        }

        public ClientAuth getClientAuth() {
            return ClientAuth.WANT;
        }

        public String getEnabledProtocol() {
            return this.sslContext.getProtocol();
        }
    }

    public static class Builder {
        private static final String HOME_DIRECTORY = "/virtual/ftproot";
        private AtomicReference<ProcessSessionFactory> sessionFactory;
        private CountDownLatch sessionFactorySetSignal;
        private Relationship relationshipSuccess;
        private String bindAddress;
        private int port;
        private String username;
        private String password;
        private SSLContextProvider sslContextProvider;

        public Builder sessionFactory(AtomicReference<ProcessSessionFactory> sessionFactory) {
            this.sessionFactory = sessionFactory;
            return this;
        }

        public Builder sessionFactorySetSignal(CountDownLatch sessionFactorySetSignal) {
            Objects.requireNonNull(sessionFactorySetSignal);
            this.sessionFactorySetSignal = sessionFactorySetSignal;
            return this;
        }

        public Builder relationshipSuccess(Relationship relationship) {
            Objects.requireNonNull(relationship);
            this.relationshipSuccess = relationship;
            return this;
        }

        public Builder bindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder sslContextProvider(SSLContextProvider sslContextProvider) {
            this.sslContextProvider = sslContextProvider;
            return this;
        }

        public NifiFtpServer build() throws ProcessException {
            try {
                boolean anonymousLoginEnabled = this.username == null;
                VirtualFileSystemFactory fileSystemFactory = new VirtualFileSystemFactory();
                CommandMapFactory commandMapFactory = new CommandMapFactory(this.sessionFactory, this.sessionFactorySetSignal, this.relationshipSuccess);
                Map<String, Command> commandMap = commandMapFactory.createCommandMap();
                ConnectionConfig connectionConfig = this.createConnectionConfig(anonymousLoginEnabled);
                Listener listener = this.createListener(this.bindAddress, this.port, this.sslContextProvider);
                User user = this.createUser(this.username, this.password, HOME_DIRECTORY);
                return new NifiFtpServer(commandMap, fileSystemFactory, connectionConfig, listener, user);
            }
            catch (Exception exception) {
                throw new ProcessException("FTP server could not be started.", (Throwable)exception);
            }
        }

        private ConnectionConfig createConnectionConfig(boolean anonymousLoginEnabled) {
            ConnectionConfigFactory connectionConfigFactory = new ConnectionConfigFactory();
            connectionConfigFactory.setAnonymousLoginEnabled(anonymousLoginEnabled);
            return connectionConfigFactory.createConnectionConfig();
        }

        private Listener createListener(String bindAddress, int port, SSLContextProvider sslContextProvider) throws FtpServerConfigurationException {
            ListenerFactory listenerFactory = new ListenerFactory();
            listenerFactory.setServerAddress(bindAddress);
            listenerFactory.setPort(port);
            if (sslContextProvider != null) {
                SSLContext sslContext = sslContextProvider.createContext();
                StandardSslConfiguration sslConfiguration = new StandardSslConfiguration(sslContext);
                listenerFactory.setSslConfiguration((SslConfiguration)sslConfiguration);
                listenerFactory.setImplicitSsl(true);
                DataConnectionConfigurationFactory dataConnectionConfigurationFactory = new DataConnectionConfigurationFactory();
                dataConnectionConfigurationFactory.setImplicitSsl(true);
                dataConnectionConfigurationFactory.setSslConfiguration((SslConfiguration)sslConfiguration);
                DataConnectionConfiguration dataConnectionConfiguration = dataConnectionConfigurationFactory.createDataConnectionConfiguration();
                listenerFactory.setDataConnectionConfiguration(dataConnectionConfiguration);
            }
            return listenerFactory.createListener();
        }

        private User createUser(String username, String password, String homeDirectory) {
            boolean anonymousLoginEnabled;
            boolean bl = anonymousLoginEnabled = username == null;
            if (anonymousLoginEnabled) {
                return this.createAnonymousUser(homeDirectory, List.of(new WritePermission()));
            }
            return this.createNamedUser(username, password, homeDirectory, List.of(new WritePermission()));
        }

        private User createAnonymousUser(String homeDirectory, List<Authority> authorities) {
            BaseUser user = new BaseUser();
            user.setName("anonymous");
            user.setHomeDirectory(homeDirectory);
            user.setAuthorities(authorities);
            return user;
        }

        private User createNamedUser(String username, String password, String homeDirectory, List<Authority> authorities) {
            BaseUser user = new BaseUser();
            user.setName(username);
            user.setPassword(password);
            user.setHomeDirectory(homeDirectory);
            user.setAuthorities(authorities);
            return user;
        }
    }
}

