/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.database.dialect.service.api.DatabaseDialectService;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.DatabaseAdapterDatabaseDialectService;

public class DatabaseAdapterDescriptor {
    private static final List<AllowableValue> databaseTypes = new ArrayList<AllowableValue>();
    private static final Map<String, DatabaseAdapter> databaseAdapters = new HashMap<String, DatabaseAdapter>();

    public static PropertyDescriptor getDatabaseDialectServiceDescriptor(PropertyDescriptor dependsOnPropertyDescriptor) {
        return new PropertyDescriptor.Builder().name("Database Dialect Service").description("Database Dialect Service for generating statements specific to a particular service or vendor.").identifiesControllerService(DatabaseDialectService.class).required(true).dependsOn(dependsOnPropertyDescriptor, "Database Dialect Service", new String[0]).build();
    }

    public static PropertyDescriptor getDatabaseTypeDescriptor() {
        return DatabaseAdapterDescriptor.getDatabaseTypeDescriptor("Database Type");
    }

    public static PropertyDescriptor getDatabaseTypeDescriptor(String propertyName) {
        return new PropertyDescriptor.Builder().name(propertyName).displayName("Database Type").description("Database Type for generating statements specific to a particular service or vendor.\nThe Generic Type supports most cases but selecting a specific type enables optimal processing\nor additional features.\n").allowableValues((DescribedValue[])databaseTypes.toArray(new AllowableValue[0])).defaultValue("Generic").required(true).build();
    }

    public static DatabaseAdapter getDatabaseAdapter(String databaseType) {
        Objects.requireNonNull(databaseType, "Database Type required");
        return databaseAdapters.get(databaseType);
    }

    public static DatabaseDialectService getDatabaseDialectService(PropertyContext context, PropertyDescriptor serviceDescriptor, String databaseType) {
        DatabaseAdapterDatabaseDialectService databaseDialectService = "Database Dialect Service".equals(databaseType) ? (DatabaseDialectService)context.getProperty(serviceDescriptor).asControllerService(DatabaseDialectService.class) : new DatabaseAdapterDatabaseDialectService(databaseType);
        return databaseDialectService;
    }

    static {
        ServiceLoader<DatabaseAdapter> loader = ServiceLoader.load(DatabaseAdapter.class);
        loader.forEach(databaseAdapter -> {
            String name = databaseAdapter.getName();
            String description = databaseAdapter.getDescription();
            AllowableValue databaseType = new AllowableValue(name, name, description);
            databaseTypes.add(databaseType);
            databaseAdapters.put(name, (DatabaseAdapter)databaseAdapter);
        });
    }
}

