/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.TableSchema;

public interface DatabaseAdapter {
    public String getName();

    public String getDescription();

    public String getSelectStatement(String var1, String var2, String var3, String var4, Long var5, Long var6);

    default public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset, String columnForPartitioning) {
        return this.getSelectStatement(tableName, columnNames, whereClause, orderByClause, limit, offset);
    }

    default public boolean supportsUpsert() {
        return false;
    }

    default public boolean supportsInsertIgnore() {
        return false;
    }

    default public String getUpsertStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        throw new UnsupportedOperationException("UPSERT is not supported for " + this.getName());
    }

    default public String getInsertIgnoreStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        throw new UnsupportedOperationException("UPSERT is not supported for " + this.getName());
    }

    default public String getTableAliasClause(String tableName) {
        return "AS " + tableName;
    }

    default public boolean supportsCreateTableIfNotExists() {
        return false;
    }

    default public String getCreateTableStatement(TableSchema tableSchema) {
        StringBuilder createTableStatement = new StringBuilder();
        List<ColumnDescription> columns = tableSchema.getColumnsAsList();
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columns.size());
        Set<String> primaryKeyColumnNames = tableSchema.getPrimaryKeyColumnNames();
        for (ColumnDescription column : columns) {
            StringBuilder sb = new StringBuilder().append(column.getColumnName()).append(" ").append(this.getSQLForDataType(column.getDataType())).append(column.isNullable() ? "" : " NOT NULL").append(primaryKeyColumnNames != null && primaryKeyColumnNames.contains(column.getColumnName()) ? " PRIMARY KEY" : "");
            columnsAndDatatypes.add(sb.toString());
        }
        createTableStatement.append("CREATE TABLE IF NOT EXISTS ").append(this.generateTableName(tableSchema.getCatalogName(), tableSchema.getSchemaName(), tableSchema.getTableName(), tableSchema)).append(" (").append(String.join((CharSequence)", ", columnsAndDatatypes)).append(") ");
        return createTableStatement.toString();
    }

    default public String getAlterTableStatement(String tableName, List<ColumnDescription> columnsToAdd) {
        StringBuilder createTableStatement = new StringBuilder();
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columnsToAdd.size());
        for (ColumnDescription column : columnsToAdd) {
            StringBuilder sb = new StringBuilder().append(column.getColumnName()).append(" ").append(this.getSQLForDataType(column.getDataType()));
            columnsAndDatatypes.add(sb.toString());
        }
        createTableStatement.append("ALTER TABLE ").append(tableName).append(" ADD COLUMNS (").append(String.join((CharSequence)", ", columnsAndDatatypes)).append(") ");
        return createTableStatement.toString();
    }

    default public Optional<Boolean> getAutoCommitForReads(Integer fetchSize) {
        return Optional.empty();
    }

    default public String getSQLForDataType(int sqlType) {
        return JDBCType.valueOf(sqlType).getName();
    }

    default public String generateTableName(String catalog, String schemaName, String tableName, TableSchema tableSchema) {
        StringBuilder tableNameBuilder = new StringBuilder();
        if (catalog != null) {
            tableNameBuilder.append(catalog);
            tableNameBuilder.append(".");
        }
        if (schemaName != null) {
            tableNameBuilder.append(schemaName);
            tableNameBuilder.append(".");
        }
        tableNameBuilder.append(tableName);
        return tableNameBuilder.toString();
    }
}

