/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.Match;
import io.krakens.grok.api.exception.GrokException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;

@SupportsBatching
@SideEffectFree
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"grok", "log", "text", "parse", "delimit", "extract"})
@CapabilityDescription(value="Evaluates one or more Grok Expressions against the content of a FlowFile, adding the results as attributes or replacing the content of the FlowFile with a JSON notation of the matched content")
@WritesAttributes(value={@WritesAttribute(attribute="grok.XXX", description="When operating in flowfile-attribute mode, each of the Grok identifier that is matched in the flowfile will be added as an attribute, prefixed with \"grok.\" For example,if the grok identifier \"timestamp\" is matched, then the value will be added to an attribute named \"grok.timestamp\"")})
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Patterns can reference resources over HTTP")})
public class ExtractGrok
extends AbstractProcessor {
    public static final String FLOWFILE_ATTRIBUTE = "flowfile-attribute";
    public static final String FLOWFILE_CONTENT = "flowfile-content";
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_PATTERN_NAME = "/default-grok-patterns.txt";
    public static final PropertyDescriptor GROK_EXPRESSION = new PropertyDescriptor.Builder().name("Grok Expression").description("Grok expression. If other Grok expressions are referenced in this expression, they must be provided in the Grok Pattern File if set or exist in the default Grok patterns").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor GROK_PATTERNS = new PropertyDescriptor.Builder().name("Grok Patterns").description("Custom Grok pattern definitions. These definitions will be loaded after the default Grok patterns. The Grok Parser will use the default Grok patterns when this property is not configured.").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.TEXT, ResourceType.URL}).build();
    public static final PropertyDescriptor KEEP_EMPTY_CAPTURES = new PropertyDescriptor.Builder().name("Keep Empty Captures").description("If true, then empty capture values will be included in the returned capture map.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination").description("Control if Grok output value is written as a new flowfile attributes, in this case each of the Grok identifier that is matched in the flowfile will be added as an attribute, prefixed with \"grok.\" or written in the flowfile content. Writing to flowfile content will overwrite any existing flowfile content.").required(true).allowableValues(new String[]{"flowfile-attribute", "flowfile-content"}).defaultValue("flowfile-attribute").build();
    public static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the file is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    public static final PropertyDescriptor MAX_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Maximum Buffer Size").description("Specifies the maximum amount of data to buffer (per file) in order to apply the Grok expressions. Files larger than the specified maximum will not be fully evaluated.").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).addValidator(StandardValidators.createDataSizeBoundsValidator((long)0L, (long)Integer.MAX_VALUE)).defaultValue("1 MB").build();
    public static final PropertyDescriptor NAMED_CAPTURES_ONLY = new PropertyDescriptor.Builder().name("Named Captures Only").description("Only store named captures from grok").required(true).allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(GROK_EXPRESSION, GROK_PATTERNS, DESTINATION, CHARACTER_SET, MAX_BUFFER_SIZE, NAMED_CAPTURES_ONLY, KEEP_EMPTY_CAPTURES);
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("FlowFiles are routed to this relationship when the Grok Expression is successfully evaluated and the FlowFile is modified as a result").build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("FlowFiles are routed to this relationship when no provided Grok Expression matches the content of the FlowFile").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_MATCH, REL_NO_MATCH);
    private volatile Grok grok;
    private final BlockingQueue<byte[]> bufferQueue = new LinkedBlockingQueue<byte[]>();
    private final AtomicBoolean keepEmptyCaputures = new AtomicBoolean(true);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnStopped
    public void onStopped() {
        this.bufferQueue.clear();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        boolean namedCaptures = false;
        if (validationContext.getProperty(NAMED_CAPTURES_ONLY).isSet()) {
            namedCaptures = validationContext.getProperty(NAMED_CAPTURES_ONLY).asBoolean();
        }
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        String subject = GROK_EXPRESSION.getName();
        String input = validationContext.getProperty(GROK_EXPRESSION).getValue();
        try {
            try (InputStream defaultPatterns = ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_PATTERN_NAME);){
                grokCompiler.register(defaultPatterns);
            }
            if (validationContext.getProperty(GROK_PATTERNS).isSet()) {
                try (InputStream patterns = validationContext.getProperty(GROK_PATTERNS).asResource().read();){
                    grokCompiler.register(patterns);
                }
            }
            this.grok = grokCompiler.compile(input, namedCaptures);
        }
        catch (Exception e) {
            problems.add(new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Not a valid Grok Expression - " + e.getMessage()).build());
            return problems;
        }
        problems.add(new ValidationResult.Builder().subject(subject).input(input).valid(true).build());
        return problems;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws GrokException, IOException {
        this.keepEmptyCaputures.set(context.getProperty(KEEP_EMPTY_CAPTURES).asBoolean());
        for (int i = 0; i < context.getMaxConcurrentTasks(); ++i) {
            int maxBufferSize = context.getProperty(MAX_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
            byte[] buffer = new byte[maxBufferSize];
            this.bufferQueue.add(buffer);
        }
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        try (InputStream defaultPatterns = ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_PATTERN_NAME);){
            grokCompiler.register(defaultPatterns);
        }
        if (context.getProperty(GROK_PATTERNS).isSet()) {
            try (InputStream patterns = context.getProperty(GROK_PATTERNS).asResource().read();){
                grokCompiler.register(patterns);
            }
        }
        this.grok = grokCompiler.compile(context.getProperty(GROK_EXPRESSION).getValue(), context.getProperty(NAMED_CAPTURES_ONLY).asBoolean().booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String contentString;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
        byte[] buffer = (byte[])this.bufferQueue.poll();
        if (buffer == null) {
            int maxBufferSize = context.getProperty(MAX_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
            buffer = new byte[maxBufferSize];
        }
        try {
            byte[] byteBuffer = buffer;
            session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])byteBuffer, (boolean)false));
            long len = Math.min((long)byteBuffer.length, flowFile.getSize());
            contentString = new String(byteBuffer, 0, (int)len, charset);
        }
        finally {
            this.bufferQueue.offer(buffer);
        }
        Match gm = this.grok.match((CharSequence)contentString);
        gm.setKeepEmptyCaptures(this.keepEmptyCaputures.get());
        Map captureMap = gm.capture();
        if (captureMap.isEmpty()) {
            session.transfer(flowFile, REL_NO_MATCH);
            this.getLogger().info("Did not match any Grok Expressions for FlowFile {}", new Object[]{flowFile});
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        switch (context.getProperty(DESTINATION).getValue()) {
            case "flowfile-attribute": {
                HashMap<CallSite, String> grokResults = new HashMap<CallSite, String>();
                for (Map.Entry entry : captureMap.entrySet()) {
                    if (null == entry.getValue()) continue;
                    grokResults.put((CallSite)((Object)("grok." + (String)entry.getKey())), entry.getValue().toString());
                }
                flowFile = session.putAllAttributes(flowFile, grokResults);
                session.getProvenanceReporter().modifyAttributes(flowFile);
                session.transfer(flowFile, REL_MATCH);
                this.getLogger().info("Matched {} Grok Expressions and added attributes to FlowFile {}", new Object[]{grokResults.size(), flowFile});
                break;
            }
            case "flowfile-content": {
                FlowFile conFlowfile = session.write(flowFile, outputStream -> objectMapper.writeValue(outputStream, (Object)captureMap));
                conFlowfile = session.putAttribute(conFlowfile, CoreAttributes.MIME_TYPE.key(), APPLICATION_JSON);
                session.getProvenanceReporter().modifyContent(conFlowfile, "Replaced content with parsed Grok fields and values", stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                session.transfer(conFlowfile, REL_MATCH);
            }
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("Grok Pattern file", GROK_PATTERNS.getName());
        config.renameProperty("Named captures only", NAMED_CAPTURES_ONLY.getName());
    }
}

