/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.database.dialect.service.api.ColumnDefinition;
import org.apache.nifi.database.dialect.service.api.DatabaseDialectService;
import org.apache.nifi.database.dialect.service.api.StandardColumnDefinition;
import org.apache.nifi.database.dialect.service.api.StandardQueryStatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementType;
import org.apache.nifi.database.dialect.service.api.TableDefinition;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.AbstractDatabaseFetchProcessor;
import org.apache.nifi.processors.standard.sql.SqlWriter;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.db.JdbcCommon;

public abstract class AbstractQueryDatabaseTable
extends AbstractDatabaseFetchProcessor {
    public static final String RESULT_TABLENAME = "tablename";
    public static final String RESULT_ROW_COUNT = "querydbtable.row.count";
    private static final AllowableValue TRANSACTION_READ_COMMITTED = new AllowableValue(String.valueOf(2), "TRANSACTION_READ_COMMITTED");
    private static final AllowableValue TRANSACTION_READ_UNCOMMITTED = new AllowableValue(String.valueOf(1), "TRANSACTION_READ_UNCOMMITTED");
    private static final AllowableValue TRANSACTION_REPEATABLE_READ = new AllowableValue(String.valueOf(4), "TRANSACTION_REPEATABLE_READ");
    private static final AllowableValue TRANSACTION_NONE = new AllowableValue(String.valueOf(0), "TRANSACTION_NONE");
    private static final AllowableValue TRANSACTION_SERIALIZABLE = new AllowableValue(String.valueOf(8), "TRANSACTION_SERIALIZABLE");
    private static final String FETCH_SIZE_NAME = "Fetch Size";
    private static final String AUTO_COMMIT_NAME = "Set Auto Commit";
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("Fetch Size").description("The number of result rows to be fetched from the result set at a time. This is a hint to the database driver and may not be honored and/or exact. If the value specified is zero, then the hint is ignored. If using PostgreSQL, then 'Set Auto Commit' must be equal to 'false' to cause 'Fetch Size' to take effect.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor AUTO_COMMIT = new PropertyDescriptor.Builder().name("Set Auto Commit").description("Allows enabling or disabling the auto commit functionality of the DB connection. Default value is 'No value set'. 'No value set' will leave the db connection's auto commit mode unchanged. For some JDBC drivers such as PostgreSQL driver, it is required to disable the auto commit functionality to get the 'Fetch Size' setting to take effect. When auto commit is enabled, PostgreSQL driver ignores 'Fetch Size' setting and loads all rows of the result set to memory at once. This could lead for a large amount of memory usage when executing queries which fetch large data sets. More Details of this behaviour in PostgreSQL driver can be found in https://jdbc.postgresql.org//documentation/head/query.html.").allowableValues(new String[]{"true", "false"}).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).build();
    public static final PropertyDescriptor MAX_ROWS_PER_FLOW_FILE = new PropertyDescriptor.Builder().name("Max Rows Per Flow File").description("The maximum number of result rows that will be included in a single FlowFile. This will allow you to break up very large result sets into multiple FlowFiles. If the value specified is zero, then all rows are returned in a single FlowFile.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor OUTPUT_BATCH_SIZE = new PropertyDescriptor.Builder().name("Output Batch Size").description("The number of output FlowFiles to queue before committing the process session. When set to zero, the session will be committed when all result set rows have been processed and the output FlowFiles are ready for transfer to the downstream relationship. For large result sets, this can cause a large burst of FlowFiles to be transferred at the end of processor execution. If this property is set, then when the specified number of FlowFiles are ready for transfer, then the session will be committed, thus releasing the FlowFiles to the downstream relationship. NOTE: The maxvalue.* and fragment.count attributes will not be set on FlowFiles when this property is set.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor MAX_FRAGMENTS = new PropertyDescriptor.Builder().name("Maximum Number of Fragments").description("The maximum number of fragments. If the value specified is zero, then all fragments are returned. This prevents OutOfMemoryError when this processor ingests huge table. NOTE: Setting this property can result in data loss, as the incoming results are not ordered, and fragments may end at arbitrary boundaries where rows are not included in the result set.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor TRANS_ISOLATION_LEVEL = new PropertyDescriptor.Builder().name("Transaction Isolation Level").description("This setting will set the transaction isolation level for the database connection for drivers that support this setting").required(false).allowableValues(new DescribedValue[]{TRANSACTION_NONE, TRANSACTION_READ_COMMITTED, TRANSACTION_READ_UNCOMMITTED, TRANSACTION_REPEATABLE_READ, TRANSACTION_SERIALIZABLE}).build();
    public static final AllowableValue INITIAL_LOAD_STRATEGY_ALL_ROWS = new AllowableValue("Start at Beginning", "Start at Beginning", "Loads all existing rows from the database table.");
    public static final AllowableValue INITIAL_LOAD_STRATEGY_NEW_ROWS = new AllowableValue("Start at Current Maximum Values", "Start at Current Maximum Values", "Loads only the newly inserted or updated rows based on the maximum value(s) of the column(s) configured in the '" + MAX_VALUE_COLUMN_NAMES.getDisplayName() + "' property.");
    public static final PropertyDescriptor INITIAL_LOAD_STRATEGY = new PropertyDescriptor.Builder().name("Initial Load Strategy").description("How to handle existing rows in the database table when the processor is started for the first time (or its state has been cleared). The property will be ignored, if any 'initial.maxvalue.*' dynamic property has also been configured.").required(true).allowableValues(new DescribedValue[]{INITIAL_LOAD_STRATEGY_ALL_ROWS, INITIAL_LOAD_STRATEGY_NEW_ROWS}).defaultValue(INITIAL_LOAD_STRATEGY_ALL_ROWS.getValue()).build();

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamic(true).build();
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean maxValueColumnNames = validationContext.getProperty(MAX_VALUE_COLUMN_NAMES).isSet();
        String initialLoadStrategy = validationContext.getProperty(INITIAL_LOAD_STRATEGY).getValue();
        if (!maxValueColumnNames && initialLoadStrategy.equals(INITIAL_LOAD_STRATEGY_NEW_ROWS.getValue())) {
            results.add(new ValidationResult.Builder().valid(false).subject(INITIAL_LOAD_STRATEGY.getDisplayName()).input(INITIAL_LOAD_STRATEGY_NEW_ROWS.getDisplayName()).explanation(String.format("'%s' strategy can only be used when '%s' property is also configured", INITIAL_LOAD_STRATEGY_NEW_ROWS.getDisplayName(), MAX_VALUE_COLUMN_NAMES.getDisplayName())).build());
        }
        return results;
    }

    @Override
    @OnScheduled
    public void setup(ProcessContext context) {
        this.maxValueProperties = this.getDefaultMaxValueProperties(context, null);
    }

    @OnStopped
    public void stop() {
        this.setupComplete.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block92: {
            List<String> maxValueColumnNameList;
            StateMap stateMap;
            if (!this.setupComplete.get()) {
                super.setup(context);
            }
            ProcessSession session = sessionFactory.createSession();
            ArrayList<FlowFile> resultSetFlowFiles = new ArrayList<FlowFile>();
            ComponentLog logger = this.getLogger();
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            DatabaseDialectService databaseDialectService = this.getDatabaseDialectService((PropertyContext)context);
            String databaseType = context.getProperty(DB_TYPE).getValue();
            String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions().getValue();
            String columnNames = context.getProperty(COLUMN_NAMES).evaluateAttributeExpressions().getValue();
            String sqlQuery = context.getProperty(SQL_QUERY).evaluateAttributeExpressions().getValue();
            String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).evaluateAttributeExpressions().getValue();
            String initialLoadStrategy = context.getProperty(INITIAL_LOAD_STRATEGY).getValue();
            String customWhereClause = context.getProperty(WHERE_CLAUSE).evaluateAttributeExpressions().getValue();
            Integer queryTimeout = context.getProperty(QUERY_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.SECONDS).intValue();
            Integer fetchSize = context.getProperty(FETCH_SIZE).evaluateAttributeExpressions().asInteger();
            Integer maxRowsPerFlowFile = context.getProperty(MAX_ROWS_PER_FLOW_FILE).evaluateAttributeExpressions().asInteger();
            Integer outputBatchSizeField = context.getProperty(OUTPUT_BATCH_SIZE).evaluateAttributeExpressions().asInteger();
            int outputBatchSize = outputBatchSizeField == null ? 0 : outputBatchSizeField;
            Integer maxFragments = context.getProperty(MAX_FRAGMENTS).isSet() ? context.getProperty(MAX_FRAGMENTS).evaluateAttributeExpressions().asInteger() : 0;
            Integer transIsolationLevel = context.getProperty(TRANS_ISOLATION_LEVEL).isSet() ? context.getProperty(TRANS_ISOLATION_LEVEL).asInteger() : null;
            SqlWriter sqlWriter = this.configureSqlWriter(session, context);
            try {
                stateMap = session.getState(Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("Failed to retrieve observed maximum values from the State Manager. Will not perform query until this is accomplished.", (Throwable)ioe);
                context.yield();
                return;
            }
            HashMap<String, String> statePropertyMap = new HashMap<String, String>(stateMap.toMap());
            for (Map.Entry maxProp : this.maxValueProperties.entrySet()) {
                String maxPropKey = ((String)maxProp.getKey()).toLowerCase();
                String fullyQualifiedMaxPropKey = AbstractQueryDatabaseTable.getStateKey(tableName, maxPropKey);
                if (statePropertyMap.containsKey(fullyQualifiedMaxPropKey)) continue;
                String newMaxPropValue = statePropertyMap.containsKey(maxPropKey) ? (String)statePropertyMap.get(maxPropKey) : (String)maxProp.getValue();
                statePropertyMap.put(fullyQualifiedMaxPropKey, newMaxPropValue);
            }
            List<String> list = maxValueColumnNameList = StringUtils.isEmpty((CharSequence)maxValueColumnNames) ? null : Arrays.asList(maxValueColumnNames.split("\\s*,\\s*"));
            if (maxValueColumnNameList != null && statePropertyMap.isEmpty() && initialLoadStrategy.equals(INITIAL_LOAD_STRATEGY_NEW_ROWS.getValue())) {
                List<ColumnDefinition> maxValueColumnDefinitions = maxValueColumnNameList.stream().map(columnName -> String.format("MAX(%s) %s", columnName, columnName)).map(StandardColumnDefinition::new).map(ColumnDefinition.class::cast).toList();
                TableDefinition tableDefinition = new TableDefinition(Optional.empty(), Optional.empty(), tableName, maxValueColumnDefinitions);
                StandardQueryStatementRequest statementRequest = new StandardQueryStatementRequest(StatementType.SELECT, tableDefinition);
                StatementResponse maxValueStatementResponse = databaseDialectService.getStatement((StatementRequest)statementRequest);
                String selectMaxQuery = maxValueStatementResponse.sql();
                try (Connection con = dbcpService.getConnection(Collections.emptyMap());
                     Statement st = con.createStatement();){
                    if (transIsolationLevel != null) {
                        con.setTransactionIsolation(transIsolationLevel);
                    }
                    st.setQueryTimeout(queryTimeout);
                    try (ResultSet resultSet = st.executeQuery(selectMaxQuery);){
                        if (resultSet.next()) {
                            MaxValueResultSetRowCollector maxValCollector = new MaxValueResultSetRowCollector(tableName, statePropertyMap);
                            maxValCollector.processRow(resultSet);
                            maxValCollector.applyStateChanges();
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Unable to execute SQL select query {} due to {}", new Object[]{selectMaxQuery, e});
                    context.yield();
                }
            }
            List<Object> parsedColumnNames = columnNames == null ? List.of() : Arrays.asList(columnNames.split(", "));
            String selectQuery = this.getQuery(databaseDialectService, databaseType, tableName, sqlQuery, parsedColumnNames, maxValueColumnNameList, customWhereClause, statePropertyMap);
            StopWatch stopWatch = new StopWatch(true);
            String fragmentIdentifier = UUID.randomUUID().toString();
            try (Connection con = dbcpService.getConnection(Collections.emptyMap());
                 Statement st = con.createStatement();){
                if (fetchSize != null && fetchSize > 0) {
                    try {
                        st.setFetchSize(fetchSize);
                    }
                    catch (SQLException se) {
                        logger.debug("Cannot set fetch size to {} due to {}", new Object[]{fetchSize, se.getLocalizedMessage(), se});
                    }
                }
                if (transIsolationLevel != null) {
                    con.setTransactionIsolation(transIsolationLevel);
                }
                String jdbcURL = "DBCPService";
                try {
                    DatabaseMetaData databaseMetaData = con.getMetaData();
                    if (databaseMetaData != null) {
                        jdbcURL = databaseMetaData.getURL();
                    }
                }
                catch (SQLException databaseMetaData) {
                    // empty catch block
                }
                st.setQueryTimeout(queryTimeout);
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing query {}", new Object[]{selectQuery});
                }
                boolean originalAutoCommit = con.getAutoCommit();
                Boolean setAutoCommitValue = context.getProperty(AUTO_COMMIT).evaluateAttributeExpressions().asBoolean();
                if (setAutoCommitValue != null && originalAutoCommit != setAutoCommitValue) {
                    try {
                        con.setAutoCommit(setAutoCommitValue);
                        logger.debug("Driver connection changed to setAutoCommit({})", new Object[]{setAutoCommitValue});
                    }
                    catch (Exception ex) {
                        logger.debug("Failed to setAutoCommit({}) due to {}: {}", new Object[]{setAutoCommitValue, ex.getClass().getName(), ex.getMessage()});
                    }
                }
                try (ResultSet resultSet = st.executeQuery(selectQuery);){
                    AtomicLong nrOfRows;
                    int fragmentIndex = 0;
                    MaxValueResultSetRowCollector maxValCollector = new MaxValueResultSetRowCollector(tableName, statePropertyMap);
                    do {
                        nrOfRows = new AtomicLong(0L);
                        FlowFile fileToProcess = session.create();
                        try {
                            fileToProcess = session.write(fileToProcess, out -> {
                                try {
                                    nrOfRows.set(sqlWriter.writeResultSet(resultSet, out, this.getLogger(), maxValCollector));
                                }
                                catch (Exception e) {
                                    throw new ProcessException("Error during database query or conversion of records.", (Throwable)e);
                                }
                            });
                        }
                        catch (ProcessException e) {
                            resultSetFlowFiles.add(fileToProcess);
                            throw e;
                        }
                        if (nrOfRows.get() <= 0L) {
                            session.remove(fileToProcess);
                            if (fragmentIndex == 0) {
                                context.yield();
                            }
                            break;
                        }
                        HashMap<String, String> attributesToAdd = new HashMap<String, String>();
                        attributesToAdd.put(RESULT_ROW_COUNT, String.valueOf(nrOfRows.get()));
                        attributesToAdd.put(RESULT_TABLENAME, tableName);
                        if (maxRowsPerFlowFile > 0) {
                            attributesToAdd.put(FRAGMENT_ID, fragmentIdentifier);
                            attributesToAdd.put(FRAGMENT_INDEX, String.valueOf(fragmentIndex));
                        }
                        attributesToAdd.putAll(sqlWriter.getAttributesToAdd());
                        fileToProcess = session.putAllAttributes(fileToProcess, attributesToAdd);
                        sqlWriter.updateCounters(session);
                        logger.debug("{} contains {} records; transferring to 'success'", new Object[]{fileToProcess, nrOfRows.get()});
                        session.getProvenanceReporter().receive(fileToProcess, jdbcURL, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                        resultSetFlowFiles.add(fileToProcess);
                        if (outputBatchSize > 0 && resultSetFlowFiles.size() >= outputBatchSize) {
                            session.transfer(resultSetFlowFiles, REL_SUCCESS);
                            session.commitAsync();
                            resultSetFlowFiles.clear();
                        }
                        ++fragmentIndex;
                    } while (!(maxFragments > 0 && fragmentIndex >= maxFragments || maxFragments == 0 && maxRowsPerFlowFile == 0) && (maxRowsPerFlowFile <= 0 || nrOfRows.get() >= (long)maxRowsPerFlowFile.intValue()));
                    maxValCollector.applyStateChanges();
                    if (outputBatchSize == 0) {
                        for (int i = 0; i < resultSetFlowFiles.size(); ++i) {
                            HashMap<Object, String> newAttributesMap = new HashMap<Object, String>();
                            for (Map.Entry entry : statePropertyMap.entrySet()) {
                                String key = (String)entry.getKey();
                                String colName = key.substring(key.lastIndexOf("@!@") + "@!@".length());
                                newAttributesMap.put("maxvalue." + colName, (String)entry.getValue());
                            }
                            if (maxRowsPerFlowFile > 0) {
                                newAttributesMap.put(FRAGMENT_COUNT, Integer.toString(fragmentIndex));
                            }
                            resultSetFlowFiles.set(i, session.putAllAttributes((FlowFile)resultSetFlowFiles.get(i), newAttributesMap));
                        }
                    }
                }
                catch (SQLException e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (con.getAutoCommit() != originalAutoCommit) {
                            try {
                                con.setAutoCommit(originalAutoCommit);
                                logger.debug("Driver connection reset to original setAutoCommit({})", new Object[]{originalAutoCommit});
                            }
                            catch (Exception ex) {
                                logger.debug("Failed to setAutoCommit({}) due to {}: {}", new Object[]{originalAutoCommit, ex.getClass().getName(), ex.getMessage()});
                            }
                        }
                        throw throwable;
                    }
                }
                if (con.getAutoCommit() != originalAutoCommit) {
                    try {
                        con.setAutoCommit(originalAutoCommit);
                        logger.debug("Driver connection reset to original setAutoCommit({})", new Object[]{originalAutoCommit});
                    }
                    catch (Exception ex) {
                        logger.debug("Failed to setAutoCommit({}) due to {}: {}", new Object[]{originalAutoCommit, ex.getClass().getName(), ex.getMessage()});
                    }
                }
                session.transfer(resultSetFlowFiles, REL_SUCCESS);
            }
            try {
                session.setState(statePropertyMap, Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
            }
            session.commitAsync();
            break block92;
            catch (SQLException | ProcessException e) {
                try {
                    logger.error("Unable to execute SQL select query {} due to {}", new Object[]{selectQuery, e});
                    if (!resultSetFlowFiles.isEmpty()) {
                        session.remove(resultSetFlowFiles);
                    }
                    context.yield();
                }
                catch (Throwable throwable) {
                    try {
                        session.setState(statePropertyMap, Scope.CLUSTER);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                    }
                    session.commitAsync();
                    throw throwable;
                }
                try {
                    session.setState(statePropertyMap, Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                }
                session.commitAsync();
            }
        }
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("qdbt-max-rows", MAX_ROWS_PER_FLOW_FILE.getName());
        config.renameProperty("qdbt-output-batch-size", OUTPUT_BATCH_SIZE.getName());
        config.renameProperty("qdbt-max-frags", MAX_FRAGMENTS.getName());
        config.renameProperty("transaction-isolation-level", TRANS_ISOLATION_LEVEL.getName());
        config.renameProperty("initial-load-strategy", INITIAL_LOAD_STRATEGY.getName());
    }

    private String getQuery(DatabaseDialectService databaseDialectService, String databaseType, String tableName, String sqlQuery, List<String> columnNames, List<String> maxValColumnNames, String customWhereClause, Map<String, String> stateMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name must be specified");
        }
        Optional<String> derivedTableQuery = Optional.ofNullable(sqlQuery);
        List<ColumnDefinition> columnDefinitions = columnNames.stream().map(StandardColumnDefinition::new).map(ColumnDefinition.class::cast).toList();
        TableDefinition tableDefinition = new TableDefinition(Optional.empty(), Optional.empty(), tableName, columnDefinitions);
        StandardQueryStatementRequest statementRequest = new StandardQueryStatementRequest(StatementType.SELECT, tableDefinition, derivedTableQuery, Optional.empty(), Optional.empty(), Optional.empty());
        StatementResponse statementResponse = databaseDialectService.getStatement((StatementRequest)statementRequest);
        StringBuilder query = new StringBuilder();
        query.append(statementResponse.sql());
        ArrayList<CallSite> whereClauses = new ArrayList<CallSite>();
        if (stateMap != null && !stateMap.isEmpty() && maxValColumnNames != null) {
            IntStream.range(0, maxValColumnNames.size()).forEach(index -> {
                String colName = (String)maxValColumnNames.get(index);
                String maxValueKey = AbstractQueryDatabaseTable.getStateKey(tableName, colName);
                String maxValue = (String)stateMap.get(maxValueKey);
                if (StringUtils.isEmpty((CharSequence)maxValue)) {
                    maxValue = (String)stateMap.get(colName.toLowerCase());
                }
                if (!StringUtils.isEmpty((CharSequence)maxValue)) {
                    Integer type = (Integer)this.columnTypeMap.get(maxValueKey);
                    if (type == null) {
                        throw new IllegalArgumentException("No column type found for: " + colName);
                    }
                    whereClauses.add((CallSite)((Object)(colName + (index == 0 ? " > " : " >= ") + AbstractQueryDatabaseTable.getLiteralByType(type, maxValue, databaseType))));
                }
            });
        }
        if (customWhereClause != null) {
            whereClauses.add((CallSite)((Object)("(" + customWhereClause + ")")));
        }
        if (!whereClauses.isEmpty()) {
            query.append(" WHERE ");
            query.append(StringUtils.join(whereClauses, (String)" AND "));
        }
        return query.toString();
    }

    protected abstract SqlWriter configureSqlWriter(ProcessSession var1, ProcessContext var2);

    public class MaxValueResultSetRowCollector
    implements JdbcCommon.ResultSetRowCallback {
        final Map<String, String> newColMap;
        final Map<String, String> originalState;
        String tableName;

        public MaxValueResultSetRowCollector(String tableName, Map<String, String> stateMap) {
            this.originalState = stateMap;
            this.newColMap = new HashMap<String, String>();
            this.newColMap.putAll(stateMap);
            this.tableName = tableName;
        }

        public void processRow(ResultSet resultSet) throws IOException {
            if (resultSet == null) {
                return;
            }
            try {
                ResultSetMetaData meta = resultSet.getMetaData();
                int nrOfColumns = meta.getColumnCount();
                if (nrOfColumns > 0) {
                    for (int i = 1; i <= nrOfColumns; ++i) {
                        String newMaxValueString;
                        String colName = meta.getColumnName(i).toLowerCase();
                        String fullyQualifiedMaxValueKey = AbstractDatabaseFetchProcessor.getStateKey(this.tableName, colName);
                        Integer type = (Integer)AbstractQueryDatabaseTable.this.columnTypeMap.get(fullyQualifiedMaxValueKey);
                        if (type == null || resultSet.getObject(i) == null) continue;
                        String maxValueString = this.newColMap.get(fullyQualifiedMaxValueKey);
                        if (StringUtils.isEmpty((CharSequence)maxValueString)) {
                            maxValueString = this.newColMap.get(colName);
                        }
                        if ((newMaxValueString = AbstractDatabaseFetchProcessor.getMaxValueFromRow(resultSet, i, type, maxValueString)) == null) continue;
                        this.newColMap.put(fullyQualifiedMaxValueKey, newMaxValueString);
                    }
                }
            }
            catch (SQLException | ParseException e) {
                throw new IOException(e);
            }
        }

        public void applyStateChanges() {
            this.originalState.putAll(this.newColMap);
        }
    }
}

