/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.calcite.RecordPathFunctions;
import org.apache.nifi.processors.standard.enrichment.RecordJoinInput;
import org.apache.nifi.processors.standard.enrichment.SqlJoinCalciteParameters;
import org.apache.nifi.queryrecord.RecordDataSource;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.sql.CalciteDatabase;
import org.apache.nifi.sql.NiFiTable;
import org.apache.nifi.util.Tuple;

public class SqlJoinCache
implements AutoCloseable {
    private final ComponentLog logger;
    private final Cache<Tuple<String, RecordSchema>, BlockingQueue<SqlJoinCalciteParameters>> calciteParameterQueues = Caffeine.newBuilder().maximumSize(25L).removalListener(this::onCacheEviction).build();

    public SqlJoinCache(ComponentLog logger) {
        this.logger = logger;
    }

    public SqlJoinCalciteParameters getCalciteParameters(String sql, RecordSchema schema, RecordJoinInput originalInput, RecordJoinInput enrichmentInput) throws SQLException {
        Tuple tuple = new Tuple((Object)sql, (Object)schema);
        BlockingQueue queue = (BlockingQueue)this.calciteParameterQueues.get((Object)tuple, key -> new LinkedBlockingQueue());
        SqlJoinCalciteParameters cachedStmt = (SqlJoinCalciteParameters)queue.poll();
        if (cachedStmt != null) {
            return cachedStmt;
        }
        return this.createCalciteParameters(sql, originalInput, enrichmentInput);
    }

    public void returnCalciteParameters(String sql, RecordSchema schema, SqlJoinCalciteParameters parameters) {
        Tuple tuple = new Tuple((Object)sql, (Object)schema);
        BlockingQueue queue = (BlockingQueue)this.calciteParameterQueues.getIfPresent((Object)tuple);
        if (queue == null || !queue.offer(parameters)) {
            parameters.close();
        }
    }

    private SqlJoinCalciteParameters createCalciteParameters(String sql, RecordJoinInput originalInput, RecordJoinInput enrichmentInput) throws SQLException {
        CalciteDatabase database = new CalciteDatabase();
        RecordPathFunctions.addToDatabase(database);
        NiFiTable originalTable = new NiFiTable("ORIGINAL", RecordDataSource.createTableSchema(originalInput.getRecordSchema()), this.logger);
        database.addTable(originalTable);
        NiFiTable enrichmentTable = new NiFiTable("ENRICHMENT", RecordDataSource.createTableSchema(enrichmentInput.getRecordSchema()), this.logger);
        database.addTable(enrichmentTable);
        PreparedStatement preparedStatement = database.getConnection().prepareStatement(sql);
        return new SqlJoinCalciteParameters(sql, database, preparedStatement);
    }

    private void onCacheEviction(Tuple<String, RecordSchema> key, BlockingQueue<SqlJoinCalciteParameters> queue, RemovalCause cause) {
        this.clearQueue(queue);
    }

    private void clearQueue(BlockingQueue<SqlJoinCalciteParameters> parameterQueue) {
        SqlJoinCalciteParameters parameters;
        while ((parameters = (SqlJoinCalciteParameters)parameterQueue.poll()) != null) {
            parameters.close();
        }
    }

    @Override
    public void close() throws Exception {
        for (BlockingQueue statementQueue : this.calciteParameterQueues.asMap().values()) {
            this.clearQueue(statementQueue);
        }
        this.calciteParameterQueues.invalidateAll();
    }
}

