/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;

@SideEffectFree
@SupportsBatching
@Tags(value={"xml", "xslt", "transform"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Applies the provided XSLT file to the FlowFile XML payload. A new FlowFile is created with transformed content and is routed to the 'success' relationship. If the XSL transform fails, the original FlowFile is routed to the 'failure' relationship")
@DynamicProperty(name="An XSLT transform parameter name", value="An XSLT transform parameter value", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="These XSLT parameters are passed to the transformer")
public class TransformXml
extends AbstractProcessor {
    private static final List<String> OBSOLETE_XSLT_CONTROLLER_KEY_PROPERTY_NAMES = List.of("xslt-controller-key", "XSLT Lookup key");
    public static final PropertyDescriptor XSLT_FILE_NAME = new PropertyDescriptor.Builder().name("XSLT File Name").description("Provides the name (including full path) of the XSLT file to apply to the FlowFile XML content.One of the 'XSLT file name' and 'XSLT Lookup' properties must be defined.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).build();
    public static final PropertyDescriptor XSLT_CONTROLLER = new PropertyDescriptor.Builder().name("XSLT Lookup").description("Controller lookup used to store XSLT definitions. One of the 'XSLT file name' and 'XSLT Lookup' properties must be defined. WARNING: note that the lookup controller service should not be used to store large XSLT files.").required(false).identifiesControllerService(StringLookupService.class).build();
    public static final PropertyDescriptor XSLT_CONTROLLER_KEY = new PropertyDescriptor.Builder().name("XSLT Lookup Key").description("Key used to retrieve the XSLT definition from the XSLT lookup controller. This property must be set when using the XSLT controller property.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor INDENT_OUTPUT = new PropertyDescriptor.Builder().name("Indent").description("Whether or not to indent the output.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor SECURE_PROCESSING = new PropertyDescriptor.Builder().name("Secure Processing").description("Whether or not to mitigate various XML-related attacks like XXE (XML External Entity) attacks.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("Cache Size").description("Maximum number of stylesheets to cache. Zero disables the cache.").required(true).defaultValue("10").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CACHE_TTL_AFTER_LAST_ACCESS = new PropertyDescriptor.Builder().name("Cache Duration").description("The cache TTL (time-to-live) or how long to keep stylesheets in the cache after last access.").required(true).defaultValue("60 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(XSLT_FILE_NAME, XSLT_CONTROLLER, XSLT_CONTROLLER_KEY, INDENT_OUTPUT, SECURE_PROCESSING, CACHE_SIZE, CACHE_TTL_AFTER_LAST_ACCESS);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with transformed content will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid XML), it will be routed to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private LoadingCache<String, Templates> cache;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        LookupService lookupService;
        Set requiredKeys;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        PropertyValue filename = validationContext.getProperty(XSLT_FILE_NAME);
        PropertyValue controller = validationContext.getProperty(XSLT_CONTROLLER);
        PropertyValue key = validationContext.getProperty(XSLT_CONTROLLER_KEY);
        if (filename.isSet() && controller.isSet() || !filename.isSet() && !controller.isSet()) {
            results.add(new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("Exactly one of the \"XSLT file name\" and \"XSLT controller\" properties must be defined.").build());
        }
        if (controller.isSet() && !key.isSet()) {
            results.add(new ValidationResult.Builder().valid(false).subject(XSLT_CONTROLLER_KEY.getDisplayName()).explanation("If using \"XSLT controller\", the XSLT controller key property must be defined.").build());
        }
        if (controller.isSet() && ((requiredKeys = (lookupService = (LookupService)validationContext.getProperty(XSLT_CONTROLLER).asControllerService(StringLookupService.class)).getRequiredKeys()) == null || requiredKeys.size() != 1)) {
            results.add(new ValidationResult.Builder().valid(false).subject(XSLT_CONTROLLER.getDisplayName()).explanation("This processor requires a key-value lookup service supporting exactly one required key, was: " + (requiredKeys == null ? "null" : String.valueOf(requiredKeys.size()))).build());
        }
        return results;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).required(false).dynamic(true).build();
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        ComponentLog logger = this.getLogger();
        Integer cacheSize = context.getProperty(CACHE_SIZE).asInteger();
        Long cacheTTL = context.getProperty(CACHE_TTL_AFTER_LAST_ACCESS).asTimePeriod(TimeUnit.SECONDS);
        if (cacheSize > 0) {
            Caffeine cacheBuilder = Caffeine.newBuilder().maximumSize((long)cacheSize.intValue());
            if (cacheTTL > 0L) {
                cacheBuilder.expireAfterAccess(cacheTTL.longValue(), TimeUnit.SECONDS);
            }
            this.cache = cacheBuilder.build(path -> this.newTemplates(context, (String)path));
        } else {
            this.cache = null;
            logger.info("Stylesheet cache disabled because cache size is set to 0");
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        String path = context.getProperty(XSLT_FILE_NAME).isSet() ? context.getProperty(XSLT_FILE_NAME).evaluateAttributeExpressions(original).getValue() : context.getProperty(XSLT_CONTROLLER_KEY).evaluateAttributeExpressions(original).getValue();
        try {
            FlowFile transformed = session.write(original, (inputStream, outputStream) -> {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                    Templates templates = this.cache == null ? this.newTemplates(context, path) : (Templates)this.cache.get((Object)path);
                    Transformer transformer = templates.newTransformer();
                    String indentProperty = context.getProperty(INDENT_OUTPUT).asBoolean() != false ? "yes" : "no";
                    transformer.setOutputProperty("indent", indentProperty);
                    transformer.setErrorListener(this.getErrorListenerLogger());
                    for (Map.Entry entry : context.getProperties().entrySet()) {
                        if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
                        String value = context.newPropertyValue((String)entry.getValue()).evaluateAttributeExpressions(original).getValue();
                        transformer.setParameter(((PropertyDescriptor)entry.getKey()).getName(), value);
                    }
                    StreamSource source = new StreamSource(bufferedInputStream);
                    StreamResult result = new StreamResult(outputStream);
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    throw new IOException(String.format("XSLT Source Path [%s] Transform Failed", path), e);
                }
            });
            session.transfer(transformed, REL_SUCCESS);
            session.getProvenanceReporter().modifyContent(transformed, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            this.getLogger().info("Transformation Completed {}", new Object[]{original});
        }
        catch (ProcessException e) {
            this.getLogger().error("Transformation Failed", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("xslt-controller", XSLT_CONTROLLER.getName());
        OBSOLETE_XSLT_CONTROLLER_KEY_PROPERTY_NAMES.forEach(obsoletePropertyName -> config.renameProperty(obsoletePropertyName, XSLT_CONTROLLER_KEY.getName()));
        config.renameProperty("xslt-controller-key", XSLT_CONTROLLER_KEY.getName());
        config.renameProperty("indent-output", INDENT_OUTPUT.getName());
        config.renameProperty("secure-processing", SECURE_PROCESSING.getName());
        config.renameProperty("cache-size", CACHE_SIZE.getName());
        config.renameProperty("cache-ttl-after-last-access", CACHE_TTL_AFTER_LAST_ACCESS.getName());
        config.renameProperty("XSLT file name", XSLT_FILE_NAME.getName());
    }

    private ErrorListenerLogger getErrorListenerLogger() {
        return new ErrorListenerLogger(this.getLogger());
    }

    private Templates newTemplates(ProcessContext context, String path) throws TransformerConfigurationException, LookupFailureException {
        boolean secureProcessing = context.getProperty(SECURE_PROCESSING).asBoolean();
        TransformerFactory transformerFactory = this.getTransformerFactory(secureProcessing);
        LookupService lookupService = (LookupService)context.getProperty(XSLT_CONTROLLER).asControllerService(LookupService.class);
        boolean filePath = context.getProperty(XSLT_FILE_NAME).isSet();
        StreamSource templateSource = this.getTemplateSource((LookupService<String>)lookupService, path, filePath);
        StreamSource configuredTemplateSource = secureProcessing ? this.getSecureSource(templateSource) : templateSource;
        return transformerFactory.newTemplates(configuredTemplateSource);
    }

    private TransformerFactory getTransformerFactory(boolean secureProcessing) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (secureProcessing) {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://saxon.sf.net/feature/parserFeature?uri=http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://saxon.sf.net/feature/parserFeature?uri=http://xml.org/sax/features/external-general-entities", false);
        }
        factory.setErrorListener(this.getErrorListenerLogger());
        return factory;
    }

    private StreamSource getTemplateSource(LookupService<String> lookupService, String path, boolean filePath) throws LookupFailureException {
        StreamSource streamSource;
        if (filePath) {
            streamSource = new StreamSource(path);
        } else {
            String coordinateKey = (String)lookupService.getRequiredKeys().iterator().next();
            Map<String, String> coordinates = Collections.singletonMap(coordinateKey, path);
            Optional foundSource = lookupService.lookup(coordinates);
            if (foundSource.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)foundSource.get()))) {
                String source = (String)foundSource.get();
                StringReader reader = new StringReader(source);
                streamSource = new StreamSource(reader);
            } else {
                throw new LookupFailureException(String.format("XSLT Source Path [%s] not found in Lookup Service", path));
            }
        }
        return streamSource;
    }

    private Source getSecureSource(StreamSource streamSource) throws TransformerConfigurationException {
        StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
        try {
            XMLStreamReader streamReader = provider.getStreamReader(streamSource);
            return new StAXSource(streamReader);
        }
        catch (ProcessingException e) {
            throw new TransformerConfigurationException("XSLT Source Stream Reader creation failed", e);
        }
    }

    private static class ErrorListenerLogger
    implements ErrorListener {
        private final ComponentLog logger;

        ErrorListenerLogger(ComponentLog logger) {
            this.logger = logger;
        }

        @Override
        public void warning(TransformerException exception) {
            this.logger.warn(exception.getMessageAndLocation(), (Throwable)exception);
        }

        @Override
        public void error(TransformerException exception) {
            this.logger.error(exception.getMessageAndLocation(), (Throwable)exception);
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            this.logger.log(LogLevel.FATAL, exception.getMessageAndLocation(), (Throwable)exception);
            throw exception;
        }
    }
}

