/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"test", "debug", "processor", "utility", "flow", "FlowFile", "state"})
@CapabilityDescription(value="The DebugFlow processor aids testing and debugging the FlowFile framework by allowing various responses to be explicitly triggered in response to the receipt of a FlowFile or a timer event without a FlowFile if using timer or cron based scheduling.  It can force responses needed to exercise or test various failure modes that can occur when a processor runs. It can also generate large numbers of component state entries for testing state management limits.")
@Stateful(scopes={Scope.LOCAL, Scope.CLUSTER}, description="When 'Generate State Entries' is set to a positive integer, the processor will generate that many state entries with random values. This is useful for testing component state storage and display limits. State entries are stored with keys like 'debug_state_key_00000' with randomly generated values.", dropStateKeySupported=true)
public class DebugFlow
extends AbstractProcessor {
    private final AtomicReference<Set<Relationship>> relationships = new AtomicReference();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles processed successfully.").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to process.").build();
    private final AtomicReference<List<PropertyDescriptor>> properties = new AtomicReference();
    static final PropertyDescriptor FF_SUCCESS_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Success Iterations").description("Number of FlowFiles to forward to success relationship.").required(true).defaultValue("1").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_FAILURE_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Failure Iterations").description("Number of FlowFiles to forward to failure relationship.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_ROLLBACK_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Rollback Iterations").description("Number of FlowFiles to roll back (without penalty).").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_ROLLBACK_YIELD_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Rollback Yield Iterations").description("Number of FlowFiles to roll back and yield.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_ROLLBACK_PENALTY_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Rollback Penalty Iterations").description("Number of FlowFiles to roll back with penalty.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_EXCEPTION_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Exception Iterations").description("Number of FlowFiles to throw exception.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_EXCEPTION_CLASS = new PropertyDescriptor.Builder().name("FlowFile Exception Class").description("Exception class to be thrown (must extend java.lang.RuntimeException).").required(true).defaultValue("java.lang.RuntimeException").addValidator((Validator)new RuntimeExceptionValidator()).build();
    static final PropertyDescriptor NO_FF_SKIP_ITERATIONS = new PropertyDescriptor.Builder().name("No FlowFile Skip Iterations").description("Number of times to skip onTrigger if no FlowFile.").required(true).defaultValue("1").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor NO_FF_EXCEPTION_ITERATIONS = new PropertyDescriptor.Builder().name("No FlowFile Exception Iterations").description("Number of times to throw NPE exception if no FlowFile.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor NO_FF_YIELD_ITERATIONS = new PropertyDescriptor.Builder().name("No FlowFile Yield Iterations").description("Number of times to yield if no FlowFile.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor NO_FF_EXCEPTION_CLASS = new PropertyDescriptor.Builder().name("No FlowFile Exception Class").description("Exception class to be thrown if no FlowFile (must extend java.lang.RuntimeException).").required(true).defaultValue("java.lang.RuntimeException").addValidator((Validator)new RuntimeExceptionValidator()).build();
    static final PropertyDescriptor WRITE_ITERATIONS = new PropertyDescriptor.Builder().name("Write Iterations").description("Number of times to write to the FlowFile").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).required(true).defaultValue("0").build();
    static final PropertyDescriptor CONTENT_SIZE = new PropertyDescriptor.Builder().name("Content Size").description("The number of bytes to write each time that the FlowFile is written to").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).required(true).defaultValue("1 KB").build();
    static final PropertyDescriptor ON_SCHEDULED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnScheduled Pause Time").description("Specifies how long the processor should sleep in the @OnScheduled method, so that the processor can be forced to take a long time to start up").required(true).defaultValue("0 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor ON_SCHEDULED_FAIL = new PropertyDescriptor.Builder().name("Fail When @OnScheduled Called").description("Specifies whether or not the Processor should throw an Exception when the methods annotated with @OnScheduled are called").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor ON_UNSCHEDULED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnUnscheduled Pause Time").description("Specifies how long the processor should sleep in the @OnUnscheduled method, so that the processor can be forced to take a long time to respond when user clicks stop").required(true).defaultValue("0 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor ON_UNSCHEDULED_FAIL = new PropertyDescriptor.Builder().name("Fail When @OnUnscheduled Called").description("Specifies whether or not the Processor should throw an Exception when the methods annotated with @OnUnscheduled are called").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor ON_STOPPED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnStopped Pause Time").description("Specifies how long the processor should sleep in the @OnStopped method, so that the processor can be forced to take a long time to shutdown").required(true).defaultValue("0 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor ON_STOPPED_FAIL = new PropertyDescriptor.Builder().name("Fail When @OnStopped Called").description("Specifies whether or not the Processor should throw an Exception when the methods annotated with @OnStopped are called").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor ON_TRIGGER_SLEEP_TIME = new PropertyDescriptor.Builder().name("OnTrigger Pause Time").description("Specifies how long the processor should sleep in the onTrigger() method, so that the processor can be forced to take a long time to perform its task").required(true).defaultValue("0 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor CUSTOM_VALIDATE_SLEEP_TIME = new PropertyDescriptor.Builder().name("CustomValidate Pause Time").description("Specifies how long the processor should sleep in the customValidate() method").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").required(true).build();
    static final PropertyDescriptor IGNORE_INTERRUPTS = new PropertyDescriptor.Builder().name("Ignore Interrupts When Paused").description("If the Processor's thread(s) are sleeping (due to one of the \"Pause Time\" properties above), and the thread is interrupted, this indicates whether the Processor should ignore the interrupt and continue sleeping or if it should allow itself to be interrupted.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor GENERATE_STATE_ENTRIES = new PropertyDescriptor.Builder().name("Generate State Entries").description("If set to a positive integer, the processor will ensure that exactly this many state entries exist on each trigger, updating their values with random data. This is useful for testing component state limits. Set to 0 to disable state generation.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor STATE_SCOPE = new PropertyDescriptor.Builder().name("State Scope").description("The scope to use when storing component state entries").required(true).allowableValues(new String[]{"LOCAL", "CLUSTER"}).defaultValue("LOCAL").build();
    private volatile Integer flowFileMaxSuccess = 0;
    private volatile Integer flowFileMaxFailure = 0;
    private volatile Integer flowFileMaxRollback = 0;
    private volatile Integer flowFileMaxYield = 0;
    private volatile Integer flowFileMaxPenalty = 0;
    private volatile Integer flowFileMaxException = 0;
    private volatile Integer noFlowFileMaxSkip = 0;
    private volatile Integer noFlowFileMaxException = 0;
    private volatile Integer noFlowFileMaxYield = 0;
    private volatile Integer flowFileCurrSuccess = 0;
    private volatile Integer flowFileCurrFailure = 0;
    private volatile Integer flowFileCurrRollback = 0;
    private volatile Integer flowFileCurrYield = 0;
    private volatile Integer flowFileCurrPenalty = 0;
    private volatile Integer flowFileCurrException = 0;
    private volatile Integer noFlowFileCurrSkip = 0;
    private volatile Integer noFlowFileCurrException = 0;
    private volatile Integer noFlowFileCurrYield = 0;
    private volatile Class<? extends RuntimeException> flowFileExceptionClass = null;
    private volatile Class<? extends RuntimeException> noFlowFileExceptionClass = null;
    private final FlowFileResponse curr_ff_resp = new FlowFileResponse(this);
    private final NoFlowFileResponse curr_noff_resp = new NoFlowFileResponse(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Relationship> getRelationships() {
        AtomicReference<Set<Relationship>> atomicReference = this.relationships;
        synchronized (atomicReference) {
            if (this.relationships.get() == null) {
                this.relationships.compareAndSet(null, Set.of(REL_SUCCESS, REL_FAILURE));
            }
            return this.relationships.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicReference<List<PropertyDescriptor>> atomicReference = this.properties;
        synchronized (atomicReference) {
            if (this.properties.get() == null) {
                List<PropertyDescriptor> properties = List.of(FF_SUCCESS_ITERATIONS, FF_FAILURE_ITERATIONS, FF_ROLLBACK_ITERATIONS, FF_ROLLBACK_YIELD_ITERATIONS, FF_ROLLBACK_PENALTY_ITERATIONS, FF_EXCEPTION_ITERATIONS, FF_EXCEPTION_CLASS, NO_FF_SKIP_ITERATIONS, NO_FF_EXCEPTION_ITERATIONS, NO_FF_YIELD_ITERATIONS, NO_FF_EXCEPTION_CLASS, WRITE_ITERATIONS, CONTENT_SIZE, ON_SCHEDULED_SLEEP_TIME, ON_SCHEDULED_FAIL, ON_UNSCHEDULED_SLEEP_TIME, ON_UNSCHEDULED_FAIL, ON_STOPPED_SLEEP_TIME, ON_STOPPED_FAIL, ON_TRIGGER_SLEEP_TIME, CUSTOM_VALIDATE_SLEEP_TIME, IGNORE_INTERRUPTS, GENERATE_STATE_ENTRIES, STATE_SCOPE);
                this.properties.compareAndSet(null, properties);
            }
            return this.properties.get();
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws ClassNotFoundException, InterruptedException {
        this.flowFileMaxSuccess = context.getProperty(FF_SUCCESS_ITERATIONS).asInteger();
        this.flowFileMaxFailure = context.getProperty(FF_FAILURE_ITERATIONS).asInteger();
        this.flowFileMaxYield = context.getProperty(FF_ROLLBACK_YIELD_ITERATIONS).asInteger();
        this.flowFileMaxRollback = context.getProperty(FF_ROLLBACK_ITERATIONS).asInteger();
        this.flowFileMaxPenalty = context.getProperty(FF_ROLLBACK_PENALTY_ITERATIONS).asInteger();
        this.flowFileMaxException = context.getProperty(FF_EXCEPTION_ITERATIONS).asInteger();
        this.noFlowFileMaxException = context.getProperty(NO_FF_EXCEPTION_ITERATIONS).asInteger();
        this.noFlowFileMaxYield = context.getProperty(NO_FF_YIELD_ITERATIONS).asInteger();
        this.noFlowFileMaxSkip = context.getProperty(NO_FF_SKIP_ITERATIONS).asInteger();
        this.curr_ff_resp.reset();
        this.curr_noff_resp.reset();
        this.flowFileExceptionClass = Class.forName(context.getProperty(FF_EXCEPTION_CLASS).toString());
        this.noFlowFileExceptionClass = Class.forName(context.getProperty(NO_FF_EXCEPTION_CLASS).toString());
        this.sleep(context.getProperty(ON_SCHEDULED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS), context.getProperty(IGNORE_INTERRUPTS).asBoolean());
        this.fail(context.getProperty(ON_SCHEDULED_FAIL).asBoolean(), OnScheduled.class);
    }

    @OnUnscheduled
    public void onUnscheduled(ProcessContext context) throws InterruptedException {
        this.sleep(context.getProperty(ON_UNSCHEDULED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS), context.getProperty(IGNORE_INTERRUPTS).asBoolean());
        this.fail(context.getProperty(ON_UNSCHEDULED_FAIL).asBoolean(), OnUnscheduled.class);
    }

    @OnStopped
    public void onStopped(ProcessContext context) throws InterruptedException {
        this.sleep(context.getProperty(ON_STOPPED_SLEEP_TIME).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS), context.getProperty(IGNORE_INTERRUPTS).asBoolean());
        this.fail(context.getProperty(ON_STOPPED_FAIL).asBoolean(), OnStopped.class);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        try {
            this.sleep(validationContext.getProperty(CUSTOM_VALIDATE_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS), validationContext.getProperty(IGNORE_INTERRUPTS).asBoolean());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Set.of(new ValidationResult.Builder().valid(false).subject("Validation").explanation("Processor Interrupted while performing validation").build());
        }
        return super.customValidate(validationContext);
    }

    private void sleep(long millis, boolean ignoreInterrupts) throws InterruptedException {
        if (millis > 0L) {
            long endSleep = System.currentTimeMillis() + millis;
            while (System.currentTimeMillis() < endSleep) {
                try {
                    Thread.sleep(Math.max(1L, endSleep - System.currentTimeMillis()));
                }
                catch (InterruptedException ie) {
                    if (ignoreInterrupts) continue;
                    Thread.currentThread().interrupt();
                    throw ie;
                }
            }
        }
    }

    private void fail(boolean isAppropriate, Class<?> annotationClass) {
        if (isAppropriate) {
            throw new RuntimeException("Failure configured for " + annotationClass.getSimpleName() + " methods");
        }
    }

    private void handleStateGeneration(ProcessContext context, ComponentLog logger) {
        int numStateEntries = context.getProperty(GENERATE_STATE_ENTRIES).asInteger();
        if (numStateEntries > 0) {
            String scopeValue = context.getProperty(STATE_SCOPE).getValue();
            Scope scope = "CLUSTER".equals(scopeValue) ? Scope.CLUSTER : Scope.LOCAL;
            try {
                HashMap<String, CallSite> stateMap = new HashMap<String, CallSite>();
                Random random = new Random();
                for (int i = 0; i < numStateEntries; ++i) {
                    String key = String.format("debug_state_key_%05d", i);
                    String value = "value_" + random.nextInt(1000000) + "_" + System.currentTimeMillis();
                    stateMap.put(key, (CallSite)((Object)value));
                }
                context.getStateManager().setState(stateMap, scope);
            }
            catch (IOException e) {
                logger.error("Failed to generate state entries", (Throwable)e);
                throw new ProcessException("Failed to generate state entries", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        logger = this.getLogger();
        this.handleStateGeneration(context, logger);
        ff = session.get();
        try {
            for (pass = 2; pass > 0; --pass) {
                if (ff == null) {
                    if (this.curr_noff_resp.state() == NoFlowFileResponseState.NO_FF_SKIP_RESPONSE) {
                        if (this.noFlowFileCurrSkip < this.noFlowFileMaxSkip) {
                            this.noFlowFileCurrSkip = this.noFlowFileCurrSkip + 1;
                            logger.info("DebugFlow skipping with no flow file");
                            return;
                        }
                        this.noFlowFileCurrSkip = 0;
                        this.curr_noff_resp.getNextCycle();
                    }
                    if (this.curr_noff_resp.state() == NoFlowFileResponseState.NO_FF_EXCEPTION_RESPONSE) {
                        if (this.noFlowFileCurrException < this.noFlowFileMaxException) {
                            this.noFlowFileCurrException = this.noFlowFileCurrException + 1;
                            logger.info("DebugFlow throwing NPE with no flow file");
                            message = "forced by " + this.getClass().getName();
                            try {
                                rte = this.noFlowFileExceptionClass.getConstructor(new Class[]{String.class}).newInstance(new Object[]{message});
                                throw rte;
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                if (!logger.isErrorEnabled()) ** GOTO lbl28
                                logger.error("{} unexpected exception throwing DebugFlow exception: {}", new Object[]{this, e});
                            }
                        } else {
                            this.noFlowFileCurrException = 0;
                            this.curr_noff_resp.getNextCycle();
                        }
                    }
lbl28:
                    // 5 sources

                    if (this.curr_noff_resp.state() == NoFlowFileResponseState.NO_FF_YIELD_RESPONSE) {
                        if (this.noFlowFileCurrYield < this.noFlowFileMaxYield) {
                            this.noFlowFileCurrYield = this.noFlowFileCurrYield + 1;
                            logger.info("DebugFlow yielding with no flow file");
                            context.yield();
                            break;
                        }
                        this.noFlowFileCurrYield = 0;
                        this.curr_noff_resp.getNextCycle();
                    }
                    return;
                }
                writeIterations = context.getProperty(DebugFlow.WRITE_ITERATIONS).asInteger();
                if (writeIterations > 0 && pass == 1) {
                    random = new Random();
                    for (i = 0; i < writeIterations; ++i) {
                        data = new byte[context.getProperty(DebugFlow.CONTENT_SIZE).asDataSize(DataUnit.B).intValue()];
                        random.nextBytes(data);
                        ff = session.write(ff, (OutputStreamCallback)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/OutputStream;)V, lambda$onTrigger$0(byte[] java.io.OutputStream ), (Ljava/io/OutputStream;)V)((byte[])data));
                    }
                }
                if (this.curr_ff_resp.state() == FlowFileResponseState.FF_SUCCESS_RESPONSE) {
                    if (this.flowFileCurrSuccess < this.flowFileMaxSuccess) {
                        this.flowFileCurrSuccess = this.flowFileCurrSuccess + 1;
                        logger.info("DebugFlow transferring to success file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                        session.transfer(ff, DebugFlow.REL_SUCCESS);
                        break;
                    }
                    this.flowFileCurrSuccess = 0;
                    this.curr_ff_resp.getNextCycle();
                }
                if (this.curr_ff_resp.state() == FlowFileResponseState.FF_FAILURE_RESPONSE) {
                    if (this.flowFileCurrFailure < this.flowFileMaxFailure) {
                        this.flowFileCurrFailure = this.flowFileCurrFailure + 1;
                        logger.info("DebugFlow transferring to failure file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                        session.transfer(ff, DebugFlow.REL_FAILURE);
                        break;
                    }
                    this.flowFileCurrFailure = 0;
                    this.curr_ff_resp.getNextCycle();
                }
                if (this.curr_ff_resp.state() == FlowFileResponseState.FF_ROLLBACK_RESPONSE) {
                    if (this.flowFileCurrRollback < this.flowFileMaxRollback) {
                        this.flowFileCurrRollback = this.flowFileCurrRollback + 1;
                        logger.info("DebugFlow rolling back (no penalty) file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                        session.rollback();
                        break;
                    }
                    this.flowFileCurrRollback = 0;
                    this.curr_ff_resp.getNextCycle();
                }
                if (this.curr_ff_resp.state() == FlowFileResponseState.FF_YIELD_RESPONSE) {
                    if (this.flowFileCurrYield < this.flowFileMaxYield) {
                        this.flowFileCurrYield = this.flowFileCurrYield + 1;
                        logger.info("DebugFlow yielding file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                        session.rollback();
                        context.yield();
                        return;
                    }
                    this.flowFileCurrYield = 0;
                    this.curr_ff_resp.getNextCycle();
                }
                if (this.curr_ff_resp.state() == FlowFileResponseState.FF_PENALTY_RESPONSE) {
                    if (this.flowFileCurrPenalty < this.flowFileMaxPenalty) {
                        this.flowFileCurrPenalty = this.flowFileCurrPenalty + 1;
                        logger.info("DebugFlow rolling back (with penalty) file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                        session.rollback(true);
                        break;
                    }
                    this.flowFileCurrPenalty = 0;
                    this.curr_ff_resp.getNextCycle();
                }
                if (this.curr_ff_resp.state() != FlowFileResponseState.FF_EXCEPTION_RESPONSE) continue;
                if (this.flowFileCurrException < this.flowFileMaxException) {
                    this.flowFileCurrException = this.flowFileCurrException + 1;
                    message = "forced by " + this.getClass().getName();
                    logger.info("DebugFlow throwing NPE file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                    try {
                        rte = this.flowFileExceptionClass.getConstructor(new Class[]{String.class}).newInstance(new Object[]{message});
                        throw rte;
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        if (!logger.isErrorEnabled()) continue;
                        logger.error("{} unexpected exception throwing DebugFlow exception: {}", new Object[]{this, e});
                        continue;
                    }
                }
                this.flowFileCurrException = 0;
                this.curr_ff_resp.getNextCycle();
            }
        }
        finally {
            sleepMillis = context.getProperty(DebugFlow.ON_TRIGGER_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
            try {
                if (sleepMillis > 0L) {
                    this.sleep(sleepMillis, context.getProperty(DebugFlow.IGNORE_INTERRUPTS).asBoolean());
                    this.getLogger().info("DebugFlow finished sleeping at completion of its onTrigger() method");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("Fail When @OnScheduled called", ON_SCHEDULED_FAIL.getName());
        config.renameProperty("Fail When @OnUnscheduled called", ON_UNSCHEDULED_FAIL.getName());
        config.renameProperty("Fail When @OnStopped called", ON_STOPPED_FAIL.getName());
    }

    private static /* synthetic */ void lambda$onTrigger$0(byte[] data, OutputStream out) throws IOException {
        out.write(data);
    }

    private class FlowFileResponse {
        private final AtomicReference<FlowFileResponseState> current = new AtomicReference();

        FlowFileResponse(DebugFlow debugFlow) {
            this.current.set(FlowFileResponseState.FF_SUCCESS_RESPONSE);
        }

        synchronized FlowFileResponseState state() {
            return this.current.get();
        }

        synchronized void getNextCycle() {
            this.current.set(this.current.get().next());
        }

        synchronized void reset() {
            this.current.set(FlowFileResponseState.FF_SUCCESS_RESPONSE);
        }
    }

    private class NoFlowFileResponse {
        private final AtomicReference<NoFlowFileResponseState> current = new AtomicReference();

        NoFlowFileResponse(DebugFlow debugFlow) {
            this.current.set(NoFlowFileResponseState.NO_FF_SKIP_RESPONSE);
        }

        synchronized NoFlowFileResponseState state() {
            return this.current.get();
        }

        synchronized void getNextCycle() {
            this.current.set(this.current.get().next());
        }

        synchronized void reset() {
            this.current.set(NoFlowFileResponseState.NO_FF_SKIP_RESPONSE);
        }
    }

    private static enum NoFlowFileResponseState {
        NO_FF_SKIP_RESPONSE,
        NO_FF_EXCEPTION_RESPONSE,
        NO_FF_YIELD_RESPONSE;

        private NoFlowFileResponseState nextState;

        NoFlowFileResponseState next() {
            return this.nextState;
        }

        static {
            NoFlowFileResponseState.NO_FF_SKIP_RESPONSE.nextState = NO_FF_EXCEPTION_RESPONSE;
            NoFlowFileResponseState.NO_FF_EXCEPTION_RESPONSE.nextState = NO_FF_YIELD_RESPONSE;
            NoFlowFileResponseState.NO_FF_YIELD_RESPONSE.nextState = NO_FF_SKIP_RESPONSE;
        }
    }

    private static enum FlowFileResponseState {
        FF_SUCCESS_RESPONSE,
        FF_FAILURE_RESPONSE,
        FF_ROLLBACK_RESPONSE,
        FF_YIELD_RESPONSE,
        FF_PENALTY_RESPONSE,
        FF_EXCEPTION_RESPONSE;

        private FlowFileResponseState nextState;

        FlowFileResponseState next() {
            return this.nextState;
        }

        static {
            FlowFileResponseState.FF_SUCCESS_RESPONSE.nextState = FF_FAILURE_RESPONSE;
            FlowFileResponseState.FF_FAILURE_RESPONSE.nextState = FF_ROLLBACK_RESPONSE;
            FlowFileResponseState.FF_ROLLBACK_RESPONSE.nextState = FF_YIELD_RESPONSE;
            FlowFileResponseState.FF_YIELD_RESPONSE.nextState = FF_PENALTY_RESPONSE;
            FlowFileResponseState.FF_PENALTY_RESPONSE.nextState = FF_EXCEPTION_RESPONSE;
            FlowFileResponseState.FF_EXCEPTION_RESPONSE.nextState = FF_SUCCESS_RESPONSE;
        }
    }

    private static class RuntimeExceptionValidator
    implements Validator {
        private RuntimeExceptionValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder resultBuilder = new ValidationResult.Builder().subject(subject).input(input);
            try {
                Class<?> exceptionClass = Class.forName(input);
                if (RuntimeException.class.isAssignableFrom(exceptionClass)) {
                    resultBuilder.valid(true);
                } else {
                    resultBuilder.valid(false).explanation("Class " + input + " is a Checked Exception, not a RuntimeException");
                }
            }
            catch (ClassNotFoundException e) {
                resultBuilder.valid(false).explanation("Class " + input + " cannot be found");
            }
            return resultBuilder.build();
        }
    }
}

