/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.processors.standard.ssh.netty.StandardNettyIoSession;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.io.DefaultIoConnectFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.netty.NettyIoConnector;
import org.apache.sshd.netty.NettyIoService;
import org.apache.sshd.netty.NettyIoServiceFactory;

public class StandardNettyIoConnector
extends NettyIoConnector {
    private final EventLoopGroup eventLoopGroup;
    private final ProxyConfiguration proxyConfiguration;
    private final Duration socketTimeout;
    private final FactoryManager factoryManager;

    public StandardNettyIoConnector(NettyIoServiceFactory factory, IoHandler handler, EventLoopGroup eventLoopGroup, ProxyConfiguration proxyConfiguration, Duration socketTimeout, FactoryManager factoryManager) {
        super(factory, handler);
        this.eventLoopGroup = eventLoopGroup;
        this.proxyConfiguration = proxyConfiguration;
        this.socketTimeout = socketTimeout;
        this.factoryManager = factoryManager;
    }

    public IoConnectFuture connect(SocketAddress address, AttributeRepository context, SocketAddress localAddress) {
        DefaultIoConnectFuture connectFuture = new DefaultIoConnectFuture((Object)address, null);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).attr(CONNECT_FUTURE_KEY, (Object)connectFuture)).handler((ChannelHandler)new StandardChannelInitializer());
        Duration connectTimeout = (Duration)CoreModuleProperties.IO_CONNECT_TIMEOUT.getRequired((PropertyResolver)this.factoryManager);
        int connectTimeoutMillis = Math.toIntExact(connectTimeout.toMillis());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMillis);
        ChannelFuture channelFuture = localAddress == null ? bootstrap.connect(address) : bootstrap.connect(address, localAddress);
        connectFuture.addListener(f -> {
            if (f.isCanceled() && (channelFuture.cancel(true) || channelFuture.isCancelled())) {
                f.getCancellation().setCanceled();
            }
        });
        channelFuture.addListener(arg_0 -> StandardNettyIoConnector.lambda$connect$1((IoConnectFuture)connectFuture, arg_0));
        return connectFuture;
    }

    private ProxyHandler getProxyHandler() {
        Socks5ProxyHandler proxyHandler;
        String proxyServerHost = this.proxyConfiguration.getProxyServerHost();
        int proxyServerPort = this.proxyConfiguration.getProxyServerPort();
        InetSocketAddress proxyAddress = new InetSocketAddress(proxyServerHost, proxyServerPort);
        String proxyUsername = this.proxyConfiguration.getProxyUserName();
        String proxyPassword = this.proxyConfiguration.getProxyUserPassword();
        Proxy.Type proxyType = this.proxyConfiguration.getProxyType();
        if (Proxy.Type.SOCKS == proxyType) {
            proxyHandler = proxyPassword == null ? new Socks5ProxyHandler((SocketAddress)proxyAddress) : new Socks5ProxyHandler((SocketAddress)proxyAddress, proxyUsername, proxyPassword);
        } else if (Proxy.Type.HTTP == proxyType) {
            proxyHandler = proxyPassword == null ? new HttpProxyHandler((SocketAddress)proxyAddress) : new HttpProxyHandler((SocketAddress)proxyAddress, proxyUsername, proxyPassword);
        } else {
            throw new IllegalArgumentException("Proxy Type [%s] not supported".formatted(new Object[]{proxyType}));
        }
        return proxyHandler;
    }

    private static /* synthetic */ void lambda$connect$1(IoConnectFuture connectFuture, Future cf) throws Exception {
        CancelFuture cancellation;
        Throwable t = cf.cause();
        if (t != null) {
            connectFuture.setException(t);
        } else if (cf.isCancelled() && (cancellation = connectFuture.cancel()) != null) {
            cancellation.setCanceled();
        }
    }

    private class StandardChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private StandardChannelInitializer() {
        }

        protected void initChannel(SocketChannel socketChannel) {
            StandardNettyIoSession session = new StandardNettyIoSession((NettyIoService)StandardNettyIoConnector.this, StandardNettyIoConnector.this.handler, null);
            ChannelPipeline channelPipeline = socketChannel.pipeline();
            channelPipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(StandardNettyIoConnector.this.socketTimeout.toMillis(), TimeUnit.MILLISECONDS)});
            Proxy.Type proxyType = StandardNettyIoConnector.this.proxyConfiguration.getProxyType();
            if (Proxy.Type.SOCKS == proxyType || Proxy.Type.HTTP == proxyType) {
                ProxyHandler proxyHandler = StandardNettyIoConnector.this.getProxyHandler();
                channelPipeline.addLast(new ChannelHandler[]{proxyHandler});
            }
            channelPipeline.addLast(new ChannelHandler[]{session.getAdapter()});
        }
    }
}

