/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.sql.PreparedStatement;
import org.apache.nifi.sql.CalciteDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlJoinCalciteParameters
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SqlJoinCalciteParameters.class);
    private final String sql;
    private final CalciteDatabase database;
    private final PreparedStatement preparedStatement;

    public SqlJoinCalciteParameters(String sql, CalciteDatabase database, PreparedStatement preparedStatement) {
        this.sql = sql;
        this.database = database;
        this.preparedStatement = preparedStatement;
    }

    public String getSql() {
        return this.sql;
    }

    public CalciteDatabase getDatabase() {
        return this.database;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    @Override
    public void close() {
        this.closeQuietly(this.preparedStatement, "Calcite Prepared Statement");
        this.closeQuietly((AutoCloseable)this.database, "Calcite Database");
    }

    private void closeQuietly(AutoCloseable closeable, String description) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close {}", (Object)description, (Object)e);
        }
    }
}

