/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.file.transfer.FileInfo;
import org.apache.nifi.processor.util.file.transfer.FileTransfer;
import org.apache.nifi.processor.util.file.transfer.PermissionDeniedException;
import org.apache.nifi.processors.standard.ssh.SshClientProvider;
import org.apache.nifi.processors.standard.ssh.StandardSshClientProvider;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StringUtils;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpHelper;

public class SFTPTransfer
implements FileTransfer {
    private static final SshClientProvider CLIENT_PROVIDER = new StandardSshClientProvider();
    private static final String DOT_PREFIX = ".";
    private static final String RELATIVE_CURRENT_DIRECTORY = ".";
    private static final String RELATIVE_PARENT_DIRECTORY = "..";
    private static final Set<String> DEFAULT_KEY_ALGORITHM_NAMES = BuiltinSignatures.VALUES.stream().map(BuiltinSignatures::getName).collect(Collectors.toSet());
    private static final Set<String> DEFAULT_CIPHER_NAMES = BuiltinCiphers.VALUES.stream().map(BuiltinCiphers::getName).collect(Collectors.toSet());
    private static final Set<String> DEFAULT_MESSAGE_AUTHENTICATION_CODE_NAMES = BuiltinMacs.VALUES.stream().map(BuiltinMacs::getName).collect(Collectors.toSet());
    private static final Set<String> DEFAULT_KEY_EXCHANGE_ALGORITHM_NAMES = BuiltinDHFactories.VALUES.stream().map(BuiltinDHFactories::getName).collect(Collectors.toSet());
    public static final PropertyDescriptor PRIVATE_KEY_PATH = new PropertyDescriptor.Builder().name("Private Key Path").description("The fully qualified path to the Private Key file").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor PRIVATE_KEY_PASSPHRASE = new PropertyDescriptor.Builder().name("Private Key Passphrase").description("Password for the private key").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).build();
    public static final PropertyDescriptor HOST_KEY_FILE = new PropertyDescriptor.Builder().name("Host Key File").description("If supplied, the given file will be used as the Host Key; otherwise, if 'Strict Host Key Checking' property is applied (set to true) then uses the 'known_hosts' and 'known_hosts2' files from ~/.ssh directory else no host key file will be used").identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).required(false).build();
    public static final PropertyDescriptor STRICT_HOST_KEY_CHECKING = new PropertyDescriptor.Builder().name("Strict Host Key Checking").description("Indicates whether or not strict enforcement of hosts keys should be applied").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port that the remote system is listening on for file transfers").addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).defaultValue("22").build();
    public static final PropertyDescriptor USE_KEEPALIVE_ON_TIMEOUT = new PropertyDescriptor.Builder().name("Send Keep Alive On Timeout").description("Send a Keep Alive message every 5 seconds up to 5 times for an overall timeout of 25 seconds.").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor ALGORITHM_CONFIGURATION = new PropertyDescriptor.Builder().name("Algorithm Negotiation").description("Configuration strategy for SSH algorithm negotiation").required(true).allowableValues(AlgorithmConfiguration.class).defaultValue((DescribedValue)AlgorithmConfiguration.DEFAULT).build();
    public static final PropertyDescriptor KEY_ALGORITHMS_ALLOWED = new PropertyDescriptor.Builder().name("Key Algorithms Allowed").description("A comma-separated list of Key Algorithms allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_KEY_ALGORITHM_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(ALGORITHM_CONFIGURATION, (DescribedValue)AlgorithmConfiguration.CUSTOM, new DescribedValue[0]).build();
    public static final PropertyDescriptor CIPHERS_ALLOWED = new PropertyDescriptor.Builder().name("Ciphers Allowed").description("A comma-separated list of Ciphers allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_CIPHER_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(ALGORITHM_CONFIGURATION, (DescribedValue)AlgorithmConfiguration.CUSTOM, new DescribedValue[0]).build();
    public static final PropertyDescriptor MESSAGE_AUTHENTICATION_CODES_ALLOWED = new PropertyDescriptor.Builder().name("Message Authentication Codes Allowed").description("A comma-separated list of Message Authentication Codes allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_MESSAGE_AUTHENTICATION_CODE_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(ALGORITHM_CONFIGURATION, (DescribedValue)AlgorithmConfiguration.CUSTOM, new DescribedValue[0]).build();
    public static final PropertyDescriptor KEY_EXCHANGE_ALGORITHMS_ALLOWED = new PropertyDescriptor.Builder().name("Key Exchange Algorithms Allowed").description("A comma-separated list of Key Exchange Algorithms allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_KEY_EXCHANGE_ALGORITHM_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(ALGORITHM_CONFIGURATION, (DescribedValue)AlgorithmConfiguration.CUSTOM, new DescribedValue[0]).build();
    public static final PropertyDescriptor DISABLE_DIRECTORY_LISTING = new PropertyDescriptor.Builder().name("Disable Directory Listing").description("If set to 'true', directory listing is not performed prior to create missing directories. By default, this processor executes a directory listing command to see target directory existence before creating missing directories. However, there are situations that you might need to disable the directory listing such as the following. Directory listing might fail with some permission setups (e.g. chmod 100) on a directory. Also, if any other SFTP client created the directory after this processor performed a listing and before a directory creation request by this processor is finished, then an error is returned because the directory already exists.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH, ProxySpec.SOCKS_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])PROXY_SPECS);
    private final ComponentLog logger;
    private final PropertyContext ctx;
    private ClientSession clientSession;
    private SftpClient sftpClient;
    private volatile boolean closed = false;
    private String homeDir;
    private String activeHostname;
    private String activePort;
    private String activeUsername;
    private String activePassword;
    private String activePrivateKeyPath;
    private String activePrivateKeyPassphrase;
    private final boolean disableDirectoryListing;

    private static String convertFactorySetToString(Set<String> factorySetNames) {
        return factorySetNames.stream().sorted().collect(Collectors.joining(", "));
    }

    private static String buildFullPath(String path, String filename) {
        if (path == null) {
            return filename;
        }
        if (path.endsWith("/")) {
            return path + filename;
        }
        return path + "/" + filename;
    }

    public SFTPTransfer(PropertyContext propertyContext, ComponentLog logger) {
        this.ctx = propertyContext;
        this.logger = logger;
        PropertyValue disableListing = propertyContext.getProperty(DISABLE_DIRECTORY_LISTING);
        this.disableDirectoryListing = disableListing != null && Boolean.TRUE.equals(disableListing.asBoolean());
    }

    public static void migrateAlgorithmProperties(PropertyConfiguration propertyConfiguration) {
        if (!propertyConfiguration.hasProperty(ALGORITHM_CONFIGURATION)) {
            boolean customAlgorithmConfiguration;
            boolean bl = customAlgorithmConfiguration = propertyConfiguration.isPropertySet(KEY_ALGORITHMS_ALLOWED) || propertyConfiguration.isPropertySet(CIPHERS_ALLOWED) || propertyConfiguration.isPropertySet(MESSAGE_AUTHENTICATION_CODES_ALLOWED) || propertyConfiguration.isPropertySet(KEY_EXCHANGE_ALGORITHMS_ALLOWED);
            if (customAlgorithmConfiguration) {
                propertyConfiguration.setProperty(ALGORITHM_CONFIGURATION, AlgorithmConfiguration.CUSTOM.getValue());
            }
        }
    }

    public static void validateProxySpec(ValidationContext context, Collection<ValidationResult> results) {
        ProxyConfiguration.validateProxySpec((ValidationContext)context, results, (ProxySpec[])PROXY_SPECS);
    }

    public String getProtocolName() {
        return "sftp";
    }

    public List<FileInfo> getListing(boolean applyFilters) throws IOException {
        Integer configuredValue;
        String path = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean depth = false;
        PropertyValue batchSizeValue = this.ctx.getProperty(FileTransfer.REMOTE_POLL_BATCH_SIZE);
        int maxResults = batchSizeValue == null ? Integer.MAX_VALUE : ((configuredValue = batchSizeValue.asInteger()) == null ? Integer.MAX_VALUE : configuredValue);
        ArrayList<FileInfo> listing = new ArrayList<FileInfo>(1000);
        this.getListing(path, 0, maxResults, listing, applyFilters);
        return listing;
    }

    protected void getListing(String path, int depth, int maxResults, List<FileInfo> listing, boolean applyFilters) throws IOException {
        if (maxResults < 1 || listing.size() >= maxResults) {
            return;
        }
        if (depth >= 100) {
            this.logger.warn("{} had to stop recursively searching directories at a recursive depth of {} to avoid memory issues", new Object[]{this, depth});
            return;
        }
        boolean ignoreDottedFiles = this.ctx.getProperty(FileTransfer.IGNORE_DOTTED_FILES).asBoolean();
        boolean recurse = this.ctx.getProperty(FileTransfer.RECURSIVE_SEARCH).asBoolean();
        boolean symlink = this.ctx.getProperty(FileTransfer.FOLLOW_SYMLINK).asBoolean();
        String fileFilterRegex = this.ctx.getProperty(FileTransfer.FILE_FILTER_REGEX).getValue();
        Pattern fileFilterPattern = fileFilterRegex == null ? null : Pattern.compile(fileFilterRegex);
        String pathFilterRegex = this.ctx.getProperty(FileTransfer.PATH_FILTER_REGEX).getValue();
        Pattern pathPattern = !recurse || pathFilterRegex == null ? null : Pattern.compile(pathFilterRegex);
        String remotePath = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean pathFilterMatches = true;
        if (pathPattern != null) {
            Path relativeDir;
            Path path2 = relativeDir = path == null ? Paths.get(".", new String[0]) : Paths.get(path, new String[0]);
            if (remotePath != null) {
                relativeDir = Paths.get(remotePath, new String[0]).relativize(relativeDir);
            }
            if (!relativeDir.toString().isEmpty() && !pathPattern.matcher(relativeDir.toString().replace("\\", "/")).matches()) {
                pathFilterMatches = false;
            }
        }
        SftpClient sftpClient = this.getSFTPClient(null);
        boolean pathMatched = pathFilterMatches;
        boolean filteringDisabled = !applyFilters;
        ArrayList<SftpClient.DirEntry> subDirectoryPaths = new ArrayList<SftpClient.DirEntry>();
        try {
            String directory = path == null || path.isBlank() ? "." : path;
            for (SftpClient.DirEntry dirEntry : sftpClient.readDir(directory)) {
                String entryFilename = dirEntry.getFilename();
                if (".".equals(entryFilename) || RELATIVE_PARENT_DIRECTORY.equals(entryFilename) || ignoreDottedFiles && entryFilename.startsWith(".")) continue;
                if (this.isIncludedDirectory(dirEntry, recurse, symlink)) {
                    subDirectoryPaths.add(dirEntry);
                    continue;
                }
                if (!this.isIncludedFile(dirEntry, symlink) || !filteringDisabled && !pathMatched || !filteringDisabled && fileFilterPattern != null && !fileFilterPattern.matcher(entryFilename).matches()) continue;
                listing.add(this.newFileInfo(path, entryFilename, dirEntry.getAttributes()));
                if (listing.size() < maxResults) continue;
                break;
            }
        }
        catch (UncheckedIOException | SftpException e) {
            int status;
            String resolvedPath;
            String string = resolvedPath = path == null ? "current directory" : path;
            if (e instanceof SftpException) {
                SftpException sftpException = (SftpException)e;
                status = sftpException.getStatus();
            } else {
                Throwable throwable = e.getCause();
                if (throwable instanceof SftpException) {
                    SftpException sftpException = (SftpException)throwable;
                    status = sftpException.getStatus();
                } else {
                    status = 4;
                }
            }
            switch (status) {
                case 2: 
                case 9: {
                    throw new FileNotFoundException("No such file or directory [%s] on remote system".formatted(resolvedPath));
                }
                case 3: {
                    throw new PermissionDeniedException("Insufficient permissions to read directory [%s]".formatted(resolvedPath), e);
                }
            }
            throw new IOException("Failed to read directory [%s]".formatted(resolvedPath), e);
        }
        for (SftpClient.DirEntry dirEntry : subDirectoryPaths) {
            String entryFilename = dirEntry.getFilename();
            File newFullPath = new File(path, entryFilename);
            String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
            try {
                this.getListing(newFullForwardPath, depth + 1, maxResults, listing, applyFilters);
            }
            catch (IOException e) {
                this.logger.error("Unable to get listing from {}; skipping", new Object[]{newFullForwardPath, e});
            }
        }
    }

    private boolean isIncludedFile(SftpClient.DirEntry dirEntry, boolean symlinksEnabled) {
        SftpClient.Attributes attributes = dirEntry.getAttributes();
        return attributes.isRegularFile() || attributes.isOther() || symlinksEnabled && attributes.isSymbolicLink();
    }

    private boolean isIncludedDirectory(SftpClient.DirEntry dirEntry, boolean recursionEnabled, boolean symlinksEnabled) {
        boolean includedDirectory = false;
        SftpClient.Attributes entryAttributes = dirEntry.getAttributes();
        if (entryAttributes.isDirectory()) {
            includedDirectory = recursionEnabled;
        } else if (symlinksEnabled && entryAttributes.isSymbolicLink()) {
            String path = dirEntry.getFilename();
            try {
                SftpClient.Attributes attributes = this.sftpClient.stat(path);
                includedDirectory = attributes.isDirectory();
            }
            catch (IOException e) {
                this.logger.warn("Read symbolic link attributes failed [{}]", new Object[]{path, e});
            }
        }
        return includedDirectory;
    }

    private FileInfo newFileInfo(String path, String filename, SftpClient.Attributes attributes) {
        File newFullPath = new File(path, filename);
        String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
        StringBuilder permsBuilder = new StringBuilder();
        Set filePermissions = SftpHelper.permissionsToAttributes((int)attributes.getPermissions());
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.OWNER_READ, "r");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.OWNER_WRITE, "w");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.OWNER_EXECUTE, "x");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.GROUP_READ, "r");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.GROUP_WRITE, "w");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.GROUP_EXECUTE, "x");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.OTHERS_READ, "r");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.OTHERS_WRITE, "w");
        this.appendPermission(permsBuilder, filePermissions, PosixFilePermission.OTHERS_EXECUTE, "x");
        FileInfo.Builder builder = new FileInfo.Builder().filename(filename).fullPathFileName(newFullForwardPath).directory(attributes.isDirectory()).size(attributes.getSize()).lastModifiedTime(attributes.getModifyTime().toMillis()).permissions(permsBuilder.toString()).owner(Integer.toString(attributes.getUserId())).group(Integer.toString(attributes.getGroupId()));
        return builder.build();
    }

    private void appendPermission(StringBuilder builder, Set<PosixFilePermission> permissions, PosixFilePermission filePermission, String permString) {
        if (permissions.contains((Object)filePermission)) {
            builder.append(permString);
        } else {
            builder.append("-");
        }
    }

    public FlowFile getRemoteFile(String remoteFileName, FlowFile origFlowFile, ProcessSession session) throws ProcessException, IOException {
        FlowFile flowFile;
        block12: {
            SftpClient sftpClient = this.getSFTPClient(origFlowFile);
            InputStream inputStream = sftpClient.read(remoteFileName);
            try {
                flowFile = session.write(origFlowFile, out -> StreamUtils.copy((InputStream)inputStream, (OutputStream)out));
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SftpException e) {
                    int status = e.getStatus();
                    switch (status) {
                        case 2: {
                            throw new FileNotFoundException("No such file or directory [%s] on remote system".formatted(remoteFileName));
                        }
                        case 3: {
                            throw new PermissionDeniedException("Insufficient permissions to read [%s]".formatted(remoteFileName), (Throwable)e);
                        }
                    }
                    throw new IOException("Failed to read [%s]".formatted(remoteFileName), e);
                }
            }
            inputStream.close();
        }
        return flowFile;
    }

    public void deleteFile(FlowFile flowFile, String path, String remoteFileName) throws IOException {
        SftpClient sftpClient = this.getSFTPClient(flowFile);
        String fullPath = SFTPTransfer.buildFullPath(path, remoteFileName);
        try {
            sftpClient.remove(fullPath);
        }
        catch (SftpException e) {
            int status = e.getStatus();
            switch (status) {
                case 2: {
                    throw new FileNotFoundException("No such file or directory [%s] on remote system".formatted(fullPath));
                }
                case 3: {
                    throw new PermissionDeniedException("Insufficient permissions to delete [%s]".formatted(fullPath), (Throwable)e);
                }
            }
            throw new IOException("Failed to delete [%s]".formatted(fullPath), e);
        }
    }

    public void deleteDirectory(FlowFile flowFile, String remoteDirectoryName) throws IOException {
        SftpClient sftpClient = this.getSFTPClient(flowFile);
        sftpClient.rmdir(remoteDirectoryName);
    }

    public void ensureDirectoryExists(FlowFile flowFile, File directoryName) throws IOException {
        String remoteDirectory;
        SftpClient sftpClient;
        block8: {
            sftpClient = this.getSFTPClient(flowFile);
            remoteDirectory = directoryName.getAbsolutePath().replace("\\", "/").replaceAll("^.:", "");
            if (this.disableDirectoryListing) {
                try {
                    sftpClient.mkdir(remoteDirectory);
                    return;
                }
                catch (SftpException e) {
                    int status = e.getStatus();
                    String statusName = SftpConstants.getStatusName((int)status);
                    if (2 == status) {
                        this.logger.debug("Failed to create directory [{}] Status [{}] attempting to create parent directory", new Object[]{directoryName, statusName});
                        break block8;
                    }
                    if (4 == status) {
                        this.logger.debug("Failed to create directory [{}] Status [{}]", new Object[]{remoteDirectory, statusName});
                        return;
                    }
                    throw new IOException("Failed to create directory [%s] Status [%s]".formatted(remoteDirectory, statusName), e);
                }
            }
            try {
                sftpClient.stat(remoteDirectory);
                return;
            }
            catch (SftpException e) {
                int status = e.getStatus();
                if (2 == status) break block8;
                throw new IOException("Failed to determine remote directory existence [%s]".formatted(remoteDirectory), e);
            }
        }
        if (directoryName.getParent() != null && !directoryName.getParentFile().equals(new File(File.separator))) {
            this.ensureDirectoryExists(flowFile, directoryName.getParentFile());
        }
        this.logger.debug("Remote Directory {} does not exist; creating it", new Object[]{remoteDirectory});
        sftpClient.mkdir(remoteDirectory);
        this.logger.debug("Created {}", new Object[]{remoteDirectory});
    }

    protected SftpClient getSFTPClient(FlowFile flowFile) throws IOException {
        String evaledHostname = this.ctx.getProperty(HOSTNAME).evaluateAttributeExpressions(flowFile).getValue();
        String evaledPort = this.ctx.getProperty(PORT).evaluateAttributeExpressions(flowFile).getValue();
        String evaledUsername = this.ctx.getProperty(USERNAME).evaluateAttributeExpressions(flowFile).getValue();
        String evaledPassword = this.ctx.getProperty(PASSWORD).evaluateAttributeExpressions(flowFile).getValue();
        String evaledPrivateKeyPath = this.ctx.getProperty(PRIVATE_KEY_PATH).evaluateAttributeExpressions(flowFile).getValue();
        String evaledPrivateKeyPassphrase = this.ctx.getProperty(PRIVATE_KEY_PASSPHRASE).evaluateAttributeExpressions(flowFile).getValue();
        if (this.sftpClient != null) {
            if (Objects.equals(evaledHostname, this.activeHostname) && Objects.equals(evaledPort, this.activePort) && Objects.equals(evaledUsername, this.activeUsername) && Objects.equals(evaledPassword, this.activePassword) && Objects.equals(evaledPrivateKeyPath, this.activePrivateKeyPath) && Objects.equals(evaledPrivateKeyPassphrase, this.activePrivateKeyPassphrase)) {
                return this.sftpClient;
            }
            this.close();
        }
        Map attributes = flowFile == null ? Collections.emptyMap() : flowFile.getAttributes();
        this.clientSession = CLIENT_PROVIDER.getClientSession(this.ctx, attributes);
        SftpClientFactory sftpClientFactory = SftpClientFactory.instance();
        this.sftpClient = sftpClientFactory.createSftpClient(this.clientSession);
        this.activeHostname = evaledHostname;
        this.activePort = evaledPort;
        this.activePassword = evaledPassword;
        this.activeUsername = evaledUsername;
        this.activePrivateKeyPath = evaledPrivateKeyPath;
        this.activePrivateKeyPassphrase = evaledPrivateKeyPassphrase;
        this.closed = false;
        try {
            this.homeDir = this.sftpClient.canonicalPath("");
        }
        catch (IOException e) {
            this.homeDir = "";
            this.logger.debug("Failed to retrieve home directory due to {}", new Object[]{e.getMessage()});
        }
        return this.sftpClient;
    }

    public String getHomeDirectory(FlowFile flowFile) throws IOException {
        this.getSFTPClient(flowFile);
        return this.homeDir;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (null != this.sftpClient) {
                this.sftpClient.close();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to close SFTPClient", (Throwable)ex);
        }
        this.sftpClient = null;
        try {
            if (this.clientSession != null) {
                this.clientSession.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to close SSH Client", (Throwable)e);
        }
        this.clientSession = null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public FileInfo getRemoteFileInfo(FlowFile flowFile, String path, String filename) throws IOException {
        FileInfo fileInfo;
        SftpClient sftpClient = this.getSFTPClient(flowFile);
        String fullPath = SFTPTransfer.buildFullPath(path, filename);
        try {
            SftpClient.Attributes fileAttributes = sftpClient.stat(fullPath);
            fileInfo = fileAttributes.isDirectory() ? null : this.newFileInfo(path, filename, fileAttributes);
        }
        catch (SftpException e) {
            int status = e.getStatus();
            if (2 == status) {
                return null;
            }
            throw new IOException("Failed to read remote attributes [%s]".formatted(fullPath), e);
        }
        return fileInfo;
    }

    public String put(FlowFile flowFile, String path, String filename, InputStream content) throws IOException {
        String group;
        String owner;
        String lastModifiedTime;
        SftpClient.Attributes attributes;
        SftpClient sftpClient = this.getSFTPClient(flowFile);
        String fullPath = SFTPTransfer.buildFullPath(path, filename);
        Object tempFilename = this.ctx.getProperty(TEMP_FILENAME).evaluateAttributeExpressions(flowFile).getValue();
        if (tempFilename == null) {
            boolean dotRename = this.ctx.getProperty(DOT_RENAME).asBoolean();
            tempFilename = dotRename ? "." + filename : filename;
        }
        String tempPath = SFTPTransfer.buildFullPath(path, (String)tempFilename);
        try {
            sftpClient.put(content, tempPath);
            attributes = sftpClient.stat(tempPath);
        }
        catch (SftpException e) {
            throw new IOException("Failed to transfer content to [%s]".formatted(fullPath), e);
        }
        String permissions = this.ctx.getProperty(PERMISSIONS).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isNotEmpty((String)permissions)) {
            int perms = this.numberPermissions(permissions);
            attributes.setPermissions(perms);
        }
        if ((lastModifiedTime = this.ctx.getProperty(LAST_MODIFIED_TIME).evaluateAttributeExpressions(flowFile).getValue()) != null && !lastModifiedTime.isBlank()) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(lastModifiedTime, dateTimeFormatter);
            FileTime modifyTime = FileTime.from(offsetDateTime.toInstant());
            attributes.setModifyTime(modifyTime);
        }
        if (StringUtils.isNotEmpty((String)(owner = this.ctx.getProperty(REMOTE_OWNER).evaluateAttributeExpressions(flowFile).getValue()))) {
            attributes.setOwner(owner);
        }
        if (StringUtils.isNotEmpty((String)(group = this.ctx.getProperty(REMOTE_GROUP).evaluateAttributeExpressions(flowFile).getValue()))) {
            attributes.setGroup(group);
        }
        try {
            sftpClient.setStat(tempPath, attributes);
        }
        catch (SftpException e) {
            this.logger.warn("Failed to set attributes on Remote File [{}]", new Object[]{tempPath, e});
        }
        if (!filename.equals(tempFilename)) {
            try {
                sftpClient.remove(fullPath);
            }
            catch (SftpException e) {
                this.logger.debug("Failed to remove {} before renaming temporary file", new Object[]{fullPath, e});
            }
            try {
                sftpClient.rename(tempPath, fullPath);
            }
            catch (SftpException e) {
                try {
                    sftpClient.remove(tempPath);
                    throw new IOException("Failed to rename temporary file to [%s]".formatted(fullPath), e);
                }
                catch (SftpException removeException) {
                    throw new IOException("Failed to rename temporary file to [%s] and removal failed".formatted(fullPath), removeException);
                }
            }
        }
        return fullPath;
    }

    public void rename(FlowFile flowFile, String source, String target) throws IOException {
        SftpClient sftpClient = this.getSFTPClient(flowFile);
        try {
            sftpClient.rename(source, target);
        }
        catch (SftpException e) {
            int status = e.getStatus();
            switch (status) {
                case 2: {
                    throw new FileNotFoundException("No such file or directory [%s] on remote system".formatted(source));
                }
                case 3: {
                    throw new PermissionDeniedException("Insufficient permissions to rename [%s] to [%s]".formatted(source, target), (Throwable)e);
                }
            }
            throw new IOException("Failed to rename [%s] to [%s]".formatted(source, target), e);
        }
    }

    protected int numberPermissions(String perms) {
        int number = -1;
        Pattern rwxPattern = Pattern.compile("^[rwx-]{9}$");
        Pattern numPattern = Pattern.compile("\\d+");
        if (rwxPattern.matcher(perms).matches()) {
            number = 0;
            if (perms.charAt(0) == 'r') {
                number |= 0x100;
            }
            if (perms.charAt(1) == 'w') {
                number |= 0x80;
            }
            if (perms.charAt(2) == 'x') {
                number |= 0x40;
            }
            if (perms.charAt(3) == 'r') {
                number |= 0x20;
            }
            if (perms.charAt(4) == 'w') {
                number |= 0x10;
            }
            if (perms.charAt(5) == 'x') {
                number |= 8;
            }
            if (perms.charAt(6) == 'r') {
                number |= 4;
            }
            if (perms.charAt(7) == 'w') {
                number |= 2;
            }
            if (perms.charAt(8) == 'x') {
                number |= 1;
            }
        } else if (numPattern.matcher(perms).matches()) {
            try {
                number = Integer.parseInt(perms, 8);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    public static enum AlgorithmConfiguration implements DescribedValue
    {
        DEFAULT("Default algorithm negotiation based on standard settings for general compatibility with SSH servers"),
        CUSTOM("Custom algorithm negotiation based on defined settings");

        private final String description;

        private AlgorithmConfiguration(String description) {
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.name();
        }

        public String getDescription() {
            return this.description;
        }
    }
}

