/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.apache.nifi.processors.standard.ssh.netty.StandardNettyIoServiceFactory;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.AbstractIoServiceFactoryFactory;
import org.apache.sshd.common.io.IoServiceFactory;

public class StandardNettyIoServiceFactoryFactory
extends AbstractIoServiceFactoryFactory {
    private static final String THREAD_NAME_FORMAT = "SFTP-%s:%d";
    private static final int EVENT_LOOP_GROUP_THREADS = 1;
    private final ProxyConfiguration proxyConfiguration;
    private final EventLoopGroup eventLoopGroup;
    private final Duration socketTimeout;

    public StandardNettyIoServiceFactoryFactory(InetSocketAddress remoteAddress, ProxyConfiguration proxyConfiguration, Duration socketTimeout) {
        super(null);
        Objects.requireNonNull(remoteAddress);
        this.proxyConfiguration = Objects.requireNonNull(proxyConfiguration, "Proxy Configuration required");
        this.eventLoopGroup = this.createEventLoopGroup(remoteAddress);
        this.socketTimeout = Objects.requireNonNull(socketTimeout, "Socket Timeout required");
    }

    public IoServiceFactory create(FactoryManager manager) {
        Objects.requireNonNull(manager, "Factory Manager required");
        StandardNettyIoServiceFactory ioServiceFactory = new StandardNettyIoServiceFactory(manager, this.eventLoopGroup, this.proxyConfiguration, this.socketTimeout);
        ioServiceFactory.setIoServiceEventListener(manager.getIoServiceEventListener());
        return ioServiceFactory;
    }

    private EventLoopGroup createEventLoopGroup(InetSocketAddress remoteAddress) {
        String threadName = THREAD_NAME_FORMAT.formatted(remoteAddress.getHostString(), remoteAddress.getPort());
        ThreadFactory threadFactory = Thread.ofPlatform().name(threadName).factory();
        return new MultiThreadIoEventLoopGroup(1, threadFactory, NioIoHandler.newFactory());
    }
}

