/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.time.Duration;
import java.util.Objects;
import org.apache.nifi.processors.standard.ssh.netty.StandardNettyIoConnector;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.netty.NettyIoServiceFactory;

class StandardNettyIoServiceFactory
extends NettyIoServiceFactory {
    private final ProxyConfiguration proxyConfiguration;
    private final Duration socketTimeout;

    StandardNettyIoServiceFactory(FactoryManager manager, EventLoopGroup eventLoopGroup, ProxyConfiguration proxyConfiguration, Duration socketTimeout) {
        super(manager, eventLoopGroup);
        this.proxyConfiguration = Objects.requireNonNull(proxyConfiguration, "Proxy Configuration required");
        this.socketTimeout = Objects.requireNonNull(socketTimeout, "Socket Timeout required");
    }

    public IoConnector createConnector(IoHandler ioHandler) {
        return new StandardNettyIoConnector(this, ioHandler, this.eventLoopGroup, this.proxyConfiguration, this.socketTimeout, this.manager);
    }

    protected CloseFuture doCloseGracefully() {
        Future shutdownFuture = this.eventLoopGroup.shutdownGracefully();
        shutdownFuture.addListener(future -> this.closeFuture.setClosed());
        return this.closeFuture;
    }
}

