/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.impl.GenericDatabaseAdapter;
import org.apache.nifi.util.StringUtils;

public class PostgreSQLDatabaseAdapter
extends GenericDatabaseAdapter {
    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public String getDescription() {
        return "Generates PostgreSQL compatible SQL";
    }

    @Override
    public boolean supportsUpsert() {
        return true;
    }

    @Override
    public boolean supportsInsertIgnore() {
        return true;
    }

    @Override
    public String getUpsertStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String columns = String.join((CharSequence)", ", columnNames);
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        String updateValues = columnNames.stream().map(columnName -> "EXCLUDED." + columnName).collect(Collectors.joining(", "));
        String conflictClause = "(" + String.join((CharSequence)", ", uniqueKeyColumnNames) + ")";
        StringBuilder statementStringBuilder = new StringBuilder("INSERT INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")").append(" ON CONFLICT ").append(conflictClause).append(" DO UPDATE SET ").append("(").append(columns).append(")").append(" = ").append("(").append(updateValues).append(")");
        return statementStringBuilder.toString();
    }

    @Override
    public String getInsertIgnoreStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String columns = String.join((CharSequence)", ", columnNames);
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        String conflictClause = "(" + String.join((CharSequence)", ", uniqueKeyColumnNames) + ")";
        StringBuilder statementStringBuilder = new StringBuilder("INSERT INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")").append(" ON CONFLICT ").append(conflictClause).append(" DO NOTHING");
        return statementStringBuilder.toString();
    }

    @Override
    public boolean supportsCreateTableIfNotExists() {
        return true;
    }

    @Override
    public String getAlterTableStatement(String tableName, List<ColumnDescription> columnsToAdd) {
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columnsToAdd.size());
        for (ColumnDescription column : columnsToAdd) {
            String dataType = this.getSQLForDataType(column.getDataType());
            StringBuilder sb = new StringBuilder("ADD COLUMN ").append(column.getColumnName()).append(" ").append(dataType);
            columnsAndDatatypes.add(sb.toString());
        }
        StringBuilder alterTableStatement = new StringBuilder();
        return alterTableStatement.append("ALTER TABLE ").append(tableName).append(" ").append(String.join((CharSequence)", ", columnsAndDatatypes)).toString();
    }

    @Override
    public Optional<Boolean> getAutoCommitForReads(Integer fetchSize) {
        if (fetchSize != null && fetchSize != 0) {
            return Optional.of(Boolean.FALSE);
        }
        return Optional.empty();
    }

    @Override
    public String getSQLForDataType(int sqlType) {
        return switch (sqlType) {
            case 8 -> "DOUBLE PRECISION";
            case -16, -15, -9, -1, 1, 12, 1111, 2005, 2009, 2011 -> "TEXT";
            default -> JDBCType.valueOf(sqlType).getName();
        };
    }
}

