/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class ColumnDescription {
    private final String columnName;
    private final int dataType;
    private final boolean required;
    private final Integer columnSize;
    private final boolean nullable;

    public ColumnDescription(String columnName, int dataType, boolean required, Integer columnSize, boolean nullable) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.required = required;
        this.columnSize = columnSize;
        this.nullable = nullable;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Integer getColumnSize() {
        return this.columnSize;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public static ColumnDescription from(ResultSet resultSet) throws SQLException {
        ResultSetMetaData md = resultSet.getMetaData();
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 1; i < md.getColumnCount() + 1; ++i) {
            columns.add(md.getColumnName(i));
        }
        String defaultValue = resultSet.getString("COLUMN_DEF");
        String columnName = resultSet.getString("COLUMN_NAME");
        int dataType = resultSet.getInt("DATA_TYPE");
        int colSize = resultSet.getInt("COLUMN_SIZE");
        String nullableValue = resultSet.getString("IS_NULLABLE");
        boolean isNullable = "YES".equalsIgnoreCase(nullableValue) || nullableValue.isEmpty();
        String autoIncrementValue = "NO";
        if (columns.contains("IS_AUTOINCREMENT")) {
            autoIncrementValue = resultSet.getString("IS_AUTOINCREMENT");
        }
        boolean isAutoIncrement = "YES".equalsIgnoreCase(autoIncrementValue);
        boolean required = !isNullable && !isAutoIncrement && defaultValue == null;
        return new ColumnDescription(columnName, dataType, required, colSize == 0 ? null : Integer.valueOf(colSize), isNullable);
    }

    public static String normalizeColumnName(String colName, boolean translateColumnNames) {
        return colName == null ? null : (translateColumnNames ? colName.toUpperCase().replace("_", "") : colName);
    }

    public String toString() {
        return "Column[name=" + this.columnName + ", dataType=" + this.dataType + ", required=" + this.required + ", columnSize=" + this.columnSize + "]";
    }
}

