/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.json.schema.JsonSchema;
import org.apache.nifi.json.schema.SchemaVersion;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.JsonSchemaRegistryComponent;
import org.apache.nifi.schemaregistry.services.JsonSchemaRegistry;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"JSON", "schema", "validation"})
@WritesAttributes(value={@WritesAttribute(attribute="json.validation.errors", description="If the flow file is routed to the invalid relationship , this attribute will contain the error message resulting from the validation failure.")})
@CapabilityDescription(value="Validates the contents of FlowFiles against a configurable JSON Schema. See json-schema.org for specification standards. This Processor does not support input containing multiple JSON objects, such as newline-delimited JSON. If the input FlowFile contains newline-delimited JSON, only the first line will be validated.")
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="Validating JSON requires reading FlowFile content into memory")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Schema configuration can reference resources over HTTP")})
public class ValidateJson
extends AbstractProcessor {
    protected static final String ERROR_ATTRIBUTE_KEY = "json.validation.errors";
    private static final String SCHEMA_NAME_PROPERTY_NAME = "Schema Name";
    private static final String SCHEMA_CONTENT_PROPERTY_NAME = "JSON Schema";
    private static final String DEFAULT_MAX_STRING_LENGTH = "20 MB";
    public static final PropertyDescriptor SCHEMA_ACCESS_STRATEGY = new PropertyDescriptor.Builder().name("Schema Access Strategy").description("Specifies how to obtain the schema that is to be used for interpreting the data.").allowableValues(JsonSchemaStrategy.class).defaultValue((DescribedValue)JsonSchemaStrategy.SCHEMA_CONTENT_PROPERTY).required(true).build();
    public static final PropertyDescriptor SCHEMA_NAME = new PropertyDescriptor.Builder().name("Schema Name").description("Specifies the name of the schema to lookup in the Schema Registry property").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${schema.name}").dependsOn(SCHEMA_ACCESS_STRATEGY, (DescribedValue)JsonSchemaStrategy.SCHEMA_NAME_PROPERTY, new DescribedValue[0]).build();
    public static final PropertyDescriptor SCHEMA_REGISTRY = new PropertyDescriptor.Builder().name("JSON Schema Registry").description("Specifies the Controller Service to use for the JSON Schema Registry").identifiesControllerService(JsonSchemaRegistry.class).required(true).dependsOn(SCHEMA_ACCESS_STRATEGY, (DescribedValue)JsonSchemaStrategy.SCHEMA_NAME_PROPERTY, new DescribedValue[0]).build();
    public static final PropertyDescriptor SCHEMA_CONTENT = new PropertyDescriptor.Builder().name("JSON Schema").description("A URL or file path to the JSON schema or the actual JSON schema content").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.URL, ResourceType.TEXT}).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(SCHEMA_ACCESS_STRATEGY, (DescribedValue)JsonSchemaStrategy.SCHEMA_CONTENT_PROPERTY, new DescribedValue[0]).build();
    public static final PropertyDescriptor MAX_STRING_LENGTH = new PropertyDescriptor.Builder().name("Max String Length").description("The maximum allowed length of a string value when parsing the JSON document").required(true).defaultValue("20 MB").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor SCHEMA_VERSION = new PropertyDescriptor.Builder().fromPropertyDescriptor(JsonSchemaRegistryComponent.SCHEMA_VERSION).dependsOn(SCHEMA_ACCESS_STRATEGY, (DescribedValue)JsonSchemaStrategy.SCHEMA_CONTENT_PROPERTY, new DescribedValue[0]).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SCHEMA_ACCESS_STRATEGY, SCHEMA_NAME, SCHEMA_REGISTRY, SCHEMA_CONTENT, SCHEMA_VERSION, MAX_STRING_LENGTH);
    public static final Relationship REL_VALID = new Relationship.Builder().name("valid").description("FlowFiles that are successfully validated against the schema are routed to this relationship").build();
    public static final Relationship REL_INVALID = new Relationship.Builder().name("invalid").description("FlowFiles that are not valid according to the specified schema are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that cannot be read as JSON are routed to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_VALID, REL_INVALID, REL_FAILURE);
    private ObjectMapper mapper;
    private final ConcurrentMap<SchemaVersion, JsonSchemaFactory> schemaFactories = Arrays.stream(SchemaVersion.values()).collect(Collectors.toConcurrentMap(Function.identity(), schemaDraftVersion -> JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)((SpecVersion.VersionFlag)SpecVersion.VersionFlag.fromId((String)schemaDraftVersion.getUri()).get()))));
    private volatile com.networknt.schema.JsonSchema schema;
    private volatile JsonSchemaRegistry jsonSchemaRegistry;

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("Schema Version", SCHEMA_VERSION.getName());
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        JsonSchemaStrategy schemaAccessStrategy = this.getSchemaAccessStrategy((PropertyContext)validationContext);
        if (schemaAccessStrategy.equals((Object)JsonSchemaStrategy.SCHEMA_NAME_PROPERTY) && !validationContext.getProperty(SCHEMA_REGISTRY).isSet()) {
            validationResults.add(new ValidationResult.Builder().subject(SCHEMA_REGISTRY.getDisplayName()).explanation(this.getPropertyValidateMessage(schemaAccessStrategy, SCHEMA_REGISTRY)).valid(false).build());
        } else if (schemaAccessStrategy.equals((Object)JsonSchemaStrategy.SCHEMA_CONTENT_PROPERTY) && !validationContext.getProperty(SCHEMA_CONTENT).isSet()) {
            validationResults.add(new ValidationResult.Builder().subject(SCHEMA_CONTENT.getDisplayName()).explanation(this.getPropertyValidateMessage(schemaAccessStrategy, SCHEMA_CONTENT)).valid(false).build());
        }
        return validationResults;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        switch (this.getSchemaAccessStrategy((PropertyContext)context).ordinal()) {
            case 0: {
                this.jsonSchemaRegistry = (JsonSchemaRegistry)context.getProperty(SCHEMA_REGISTRY).asControllerService(JsonSchemaRegistry.class);
                break;
            }
            case 1: {
                InputStream inputStream = context.getProperty(SCHEMA_CONTENT).asResource().read();
                try {
                    SchemaVersion schemaVersion = SchemaVersion.valueOf((String)context.getProperty(SCHEMA_VERSION).getValue());
                    JsonSchemaFactory factory = (JsonSchemaFactory)this.schemaFactories.get(schemaVersion);
                    this.schema = factory.getSchema(inputStream);
                    if (inputStream == null) break;
                }
                catch (Throwable schemaVersion) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            schemaVersion.addSuppressed(throwable);
                        }
                    }
                    throw schemaVersion;
                }
                inputStream.close();
                break;
            }
        }
        int maxStringLength = context.getProperty(MAX_STRING_LENGTH).asDataSize(DataUnit.B).intValue();
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxStringLength(maxStringLength).build();
        this.mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.mapper.getFactory().setStreamReadConstraints(streamReadConstraints);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        JsonSchemaStrategy schemaAccessStrategy = this.getSchemaAccessStrategy((PropertyContext)context);
        if (schemaAccessStrategy.equals((Object)JsonSchemaStrategy.SCHEMA_NAME_PROPERTY)) {
            try {
                String schemaName = context.getProperty(SCHEMA_NAME).evaluateAttributeExpressions(flowFile).getValue();
                JsonSchema jsonSchema = this.jsonSchemaRegistry.retrieveSchema(schemaName);
                JsonSchemaFactory factory = (JsonSchemaFactory)this.schemaFactories.get(jsonSchema.getSchemaVersion());
                this.schema = factory.getSchema(jsonSchema.getSchemaText());
            }
            catch (Exception e) {
                this.getLogger().error("Could not retrieve JSON schema for {}", new Object[]{flowFile, e});
                session.getProvenanceReporter().route(flowFile, REL_FAILURE);
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
        }
        try (InputStream in = session.read(flowFile);){
            JsonNode node = this.mapper.readTree(in);
            Set errors = this.schema.validate(node);
            if (errors.isEmpty()) {
                this.getLogger().debug("JSON {} valid", new Object[]{flowFile});
                session.getProvenanceReporter().route(flowFile, REL_VALID);
                session.transfer(flowFile, REL_VALID);
            } else {
                String validationMessages = errors.toString();
                flowFile = session.putAttribute(flowFile, ERROR_ATTRIBUTE_KEY, validationMessages);
                this.getLogger().warn("JSON {} invalid: Validation Errors {}", new Object[]{flowFile, validationMessages});
                session.getProvenanceReporter().route(flowFile, REL_INVALID);
                session.transfer(flowFile, REL_INVALID);
            }
        }
        catch (Exception e) {
            this.getLogger().error("JSON processing failed {}", new Object[]{flowFile, e});
            session.getProvenanceReporter().route(flowFile, REL_FAILURE);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private String getPropertyValidateMessage(JsonSchemaStrategy schemaAccessStrategy, PropertyDescriptor property) {
        return "The '" + schemaAccessStrategy.getValue() + "' Schema Access Strategy requires that the " + property.getDisplayName() + " property be set.";
    }

    private JsonSchemaStrategy getSchemaAccessStrategy(PropertyContext context) {
        return (JsonSchemaStrategy)context.getProperty(SCHEMA_ACCESS_STRATEGY).asAllowableValue(JsonSchemaStrategy.class);
    }

    public static enum JsonSchemaStrategy implements DescribedValue
    {
        SCHEMA_NAME_PROPERTY("Schema Name Property", "The name of the Schema to use is specified by the 'Schema Name' Property. The value of this property is used to lookup the Schema in the configured JSON Schema Registry Service."),
        SCHEMA_CONTENT_PROPERTY("JSON Schema Property", "A URL or file path to the JSON schema or the actual JSON schema is specified by the 'JSON Schema' Property. No matter how the JSON schema is specified, it must be a valid JSON schema");

        private final String displayName;
        private final String description;

        private JsonSchemaStrategy(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

