/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBigDecimal;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseChar;
import org.supercsv.cellprocessor.ParseDate;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.constraint.DMinMax;
import org.supercsv.cellprocessor.constraint.Equals;
import org.supercsv.cellprocessor.constraint.ForbidSubStr;
import org.supercsv.cellprocessor.constraint.IsIncludedIn;
import org.supercsv.cellprocessor.constraint.LMinMax;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.RequireHashCode;
import org.supercsv.cellprocessor.constraint.RequireSubStr;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.constraint.StrNotNullOrEmpty;
import org.supercsv.cellprocessor.constraint.StrRegEx;
import org.supercsv.cellprocessor.constraint.Strlen;
import org.supercsv.cellprocessor.constraint.Unique;
import org.supercsv.cellprocessor.constraint.UniqueHashCode;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"csv", "schema", "validation"})
@CapabilityDescription(value="Validates the contents of FlowFiles or a FlowFile attribute value against a user-specified CSV schema. Take a look at the additional documentation of this processor for some schema examples.")
@WritesAttributes(value={@WritesAttribute(attribute="count.valid.lines", description="If line by line validation, number of valid lines extracted from the source data"), @WritesAttribute(attribute="count.invalid.lines", description="If line by line validation, number of invalid lines extracted from the source data"), @WritesAttribute(attribute="count.total.lines", description="If line by line validation, total number of lines in the source data"), @WritesAttribute(attribute="validation.error.message", description="For flow files routed to invalid, message of the first validation error")})
public class ValidateCsv
extends AbstractProcessor {
    private static final List<String> ALLOWED_OPERATORS = List.of("ParseBigDecimal", "ParseBool", "ParseChar", "ParseDate", "ParseDouble", "ParseInt", "ParseLong", "Optional", "DMinMax", "Equals", "ForbidSubStr", "LMinMax", "NotNull", "Null", "RequireHashCode", "RequireSubStr", "Strlen", "StrMinMax", "StrNotNullOrEmpty", "StrRegEx", "Unique", "UniqueHashCode", "IsIncludedIn");
    private static final String ROUTE_WHOLE_FLOW_FILE = "FlowFile validation";
    private static final String ROUTE_LINES_INDIVIDUALLY = "Line by line validation";
    public static final AllowableValue VALIDATE_WHOLE_FLOWFILE = new AllowableValue("FlowFile validation", "FlowFile validation", "As soon as an error is found in the CSV file, the validation will stop and the whole flow file will be routed to the 'invalid' relationship. This option offers best performances.");
    public static final AllowableValue VALIDATE_LINES_INDIVIDUALLY = new AllowableValue("Line by line validation", "Line by line validation", "In case an error is found, the input CSV file will be split into two FlowFiles: one routed to the 'valid' relationship containing all the correct lines and one routed to the 'invalid' relationship containing all the incorrect lines. Take care if choosing this option while using Unique cell processors in schema definition:the first occurrence will be considered valid and the next ones as invalid.");
    public static final PropertyDescriptor SCHEMA = new PropertyDescriptor.Builder().name("validate-csv-schema").displayName("Schema").description("The schema to be used for validation. Is expected a comma-delimited string representing the cell processors to apply. The following cell processors are allowed in the schema definition: " + String.valueOf(ALLOWED_OPERATORS) + ". Note: cell processors cannot be nested except with Optional. Schema is required if Header is false.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor HEADER = new PropertyDescriptor.Builder().name("validate-csv-header").displayName("Header").description("True if the incoming flow file contains a header to ignore, false otherwise.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor QUOTE_CHARACTER = new PropertyDescriptor.Builder().name("validate-csv-quote").displayName("Quote character").description("Character used as 'quote' in the incoming data. Example: \"").required(true).defaultValue("\"").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MAX_LINES_PER_ROW = new PropertyDescriptor.Builder().name("Max Lines Per Row").description("The maximum number of lines that a row can span before an exception is thrown. This option allows\nthe processor to fail fast when encountering CSV with mismatching quotes - the normal behaviour\nwould be to continue reading until the matching quote is found, which could potentially mean reading\nthe whole file (and exhausting all available memory). Zero value will disable this option.\n").required(true).defaultValue("0").expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor DELIMITER_CHARACTER = new PropertyDescriptor.Builder().name("validate-csv-delimiter").displayName("Delimiter character").description("Character used as 'delimiter' in the incoming data. Example: ,").required(true).defaultValue(",").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor END_OF_LINE_CHARACTER = new PropertyDescriptor.Builder().name("validate-csv-eol").displayName("End of line symbols").description("Symbols used as 'end of line' in the incoming data. Example: \\n").required(true).defaultValue("\\n").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor VALIDATION_STRATEGY = new PropertyDescriptor.Builder().name("validate-csv-strategy").displayName("Validation strategy").description("Strategy to apply when routing input files to output relationships.").required(true).defaultValue((DescribedValue)VALIDATE_WHOLE_FLOWFILE).allowableValues(new DescribedValue[]{VALIDATE_LINES_INDIVIDUALLY, VALIDATE_WHOLE_FLOWFILE}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CSV_SOURCE_ATTRIBUTE = new PropertyDescriptor.Builder().name("CSV Source Attribute").description("The name of the attribute containing CSV data to be validated. If this property is blank, the FlowFile content will be validated.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.ATTRIBUTE_KEY_VALIDATOR).dependsOn(VALIDATION_STRATEGY, new AllowableValue[]{VALIDATE_WHOLE_FLOWFILE}).build();
    public static final PropertyDescriptor INCLUDE_ALL_VIOLATIONS = new PropertyDescriptor.Builder().name("validate-csv-violations").displayName("Include all violations").description("If true, the validation.error.message attribute would include the list of all the violations for the first invalid line. Note that setting this property to true would slightly decrease the performances as all columns would be validated. If false, a line is invalid as soon as a column is found violating the specified constraint and only this violation for the first invalid line will be included in the validation.error.message attribute.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SCHEMA, CSV_SOURCE_ATTRIBUTE, HEADER, DELIMITER_CHARACTER, QUOTE_CHARACTER, MAX_LINES_PER_ROW, END_OF_LINE_CHARACTER, VALIDATION_STRATEGY, INCLUDE_ALL_VIOLATIONS);
    public static final Relationship REL_VALID = new Relationship.Builder().name("valid").description("FlowFiles that are successfully validated against the schema are routed to this relationship").build();
    public static final Relationship REL_INVALID = new Relationship.Builder().name("invalid").description("FlowFiles that are not valid according to the specified schema, or no schema or CSV header can be identified, are routed to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_VALID, REL_INVALID);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        PropertyValue schemaProp = context.getProperty(SCHEMA);
        PropertyValue headerProp = context.getProperty(HEADER);
        String schema = schemaProp.getValue();
        String subject = SCHEMA.getName();
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(schema)) {
            return List.of(new ValidationResult.Builder().subject(subject).input(schema).explanation("Expression Language Present").valid(true).build());
        }
        try {
            if (schema != null) {
                this.parseSchema(schema);
            } else if (!headerProp.asBoolean().booleanValue()) {
                throw new Exception("Schema cannot be empty if Header property is false.");
            }
        }
        catch (Exception e) {
            ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>(1);
            problems.add(new ValidationResult.Builder().subject(subject).input(schema).valid(false).explanation("Error while parsing the schema: " + e.getMessage()).build());
            return problems;
        }
        return super.customValidate(context);
    }

    public CsvPreference getPreference(ProcessContext context, FlowFile flowFile) {
        String msgDemarcator = context.getProperty(END_OF_LINE_CHARACTER).evaluateAttributeExpressions(flowFile).getValue().replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
        char quoteChar = context.getProperty(QUOTE_CHARACTER).evaluateAttributeExpressions(flowFile).getValue().charAt(0);
        char delimiterChar = context.getProperty(DELIMITER_CHARACTER).evaluateAttributeExpressions(flowFile).getValue().charAt(0);
        int maxLinesPerRow = context.getProperty(MAX_LINES_PER_ROW).asInteger();
        return new CsvPreference.Builder(quoteChar, (int)delimiterChar, msgDemarcator).maxLinesPerRow(maxLinesPerRow).build();
    }

    private CellProcessor[] parseSchema(String schema) {
        ArrayList<CellProcessor> processorsList = new ArrayList<CellProcessor>();
        String remaining = schema;
        while (!remaining.isEmpty()) {
            remaining = this.setProcessor(remaining, processorsList);
        }
        return processorsList.toArray(new CellProcessor[0]);
    }

    private String setProcessor(String remaining, List<CellProcessor> processorsList) {
        StringBuilder buffer = new StringBuilder();
        String inputString = remaining;
        int i = 0;
        int opening = 0;
        int closing = 0;
        while (buffer.length() != inputString.length()) {
            char c = remaining.charAt(i);
            ++i;
            if (opening == 0 && c == ',') {
                if (i != 1) break;
                inputString = inputString.substring(1);
                continue;
            }
            buffer.append(c);
            if (c == '(') {
                ++opening;
            } else if (c == ')') {
                ++closing;
            }
            if (opening <= 0 || opening != closing) continue;
            break;
        }
        String procString = buffer.toString().trim();
        opening = procString.indexOf(40);
        String method = procString;
        String argument = null;
        if (opening != -1) {
            argument = method.substring(opening + 1, method.length() - 1);
            method = method.substring(0, opening);
        }
        processorsList.add(this.getProcessor(method.toLowerCase(), argument));
        return remaining.substring(i);
    }

    private CellProcessor getProcessor(String method, String argument) {
        switch (method) {
            case "optional": {
                int opening = argument.indexOf(40);
                String subMethod = argument;
                String subArgument = null;
                if (opening != -1) {
                    subArgument = subMethod.substring(opening + 1, subMethod.length() - 1);
                    subMethod = subMethod.substring(0, opening);
                }
                return new Optional(this.getProcessor(subMethod.toLowerCase(), subArgument));
            }
            case "parsedate": {
                return new ParseDate(argument.substring(1, argument.length() - 1));
            }
            case "parsedouble": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("ParseDouble does not expect any argument but has " + argument);
                }
                return new ParseDouble();
            }
            case "parsebigdecimal": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("ParseBigDecimal does not expect any argument but has " + argument);
                }
                return new ParseBigDecimal();
            }
            case "parsebool": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("ParseBool does not expect any argument but has " + argument);
                }
                return new ParseBool();
            }
            case "parsechar": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("ParseChar does not expect any argument but has " + argument);
                }
                return new ParseChar();
            }
            case "parseint": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("ParseInt does not expect any argument but has " + argument);
                }
                return new ParseInt();
            }
            case "parselong": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("ParseLong does not expect any argument but has " + argument);
                }
                return new ParseLong();
            }
            case "notnull": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("NotNull does not expect any argument but has " + argument);
                }
                return new NotNull();
            }
            case "strregex": {
                return new StrRegEx(argument.substring(1, argument.length() - 1));
            }
            case "unique": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("Unique does not expect any argument but has " + argument);
                }
                return new Unique();
            }
            case "uniquehashcode": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("UniqueHashCode does not expect any argument but has " + argument);
                }
                return new UniqueHashCode();
            }
            case "strlen": {
                String[] splts = argument.split(",");
                int[] requiredLengths = new int[splts.length];
                for (int i = 0; i < splts.length; ++i) {
                    requiredLengths[i] = Integer.parseInt(splts[i]);
                }
                return new Strlen(requiredLengths);
            }
            case "strminmax": {
                String[] splits = argument.split(",");
                return new StrMinMax(Long.parseLong(splits[0]), Long.parseLong(splits[1]));
            }
            case "lminmax": {
                String[] args = argument.split(",");
                return new LMinMax(Long.parseLong(args[0]), Long.parseLong(args[1]));
            }
            case "dminmax": {
                String[] doubles = argument.split(",");
                return new DMinMax(Double.parseDouble(doubles[0]), Double.parseDouble(doubles[1]));
            }
            case "equals": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("Equals does not expect any argument but has " + argument);
                }
                return new Equals();
            }
            case "forbidsubstr": {
                String[] forbiddenSubStrings = argument.replaceAll("\"", "").split(",[ ]*");
                return new ForbidSubStr(forbiddenSubStrings);
            }
            case "requiresubstr": {
                String[] requiredSubStrings = argument.replaceAll("\"", "").split(",[ ]*");
                return new RequireSubStr(requiredSubStrings);
            }
            case "strnotnullorempty": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("StrNotNullOrEmpty does not expect any argument but has " + argument);
                }
                return new StrNotNullOrEmpty();
            }
            case "requirehashcode": {
                String[] hashs = argument.split(",");
                int[] hashcodes = new int[hashs.length];
                for (int i = 0; i < hashs.length; ++i) {
                    hashcodes[i] = Integer.parseInt(hashs[i]);
                }
                return new RequireHashCode(hashcodes);
            }
            case "null": {
                if (argument != null && !argument.isEmpty()) {
                    throw new IllegalArgumentException("Null does not expect any argument but has " + argument);
                }
                return null;
            }
            case "isincludedin": {
                Object[] elements = argument.replaceAll("\"", "").split(",[ ]*");
                return new IsIncludedIn(elements);
            }
        }
        throw new IllegalArgumentException("[" + method + "] is not an allowed method to define a Cell Processor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) {
        String validationError;
        FlowFile validFF;
        FlowFile invalidFF;
        int totalCount;
        int okCount;
        boolean valid;
        boolean isWholeFFValidation;
        ComponentLog logger;
        FlowFile flowFile;
        block34: {
            InputStream stream;
            String validationStrategy;
            flowFile = session.get();
            if (flowFile == null) {
                return;
            }
            CsvPreference csvPref = this.getPreference(context, flowFile);
            boolean header = context.getProperty(HEADER).asBoolean();
            logger = this.getLogger();
            String schema = context.getProperty(SCHEMA).evaluateAttributeExpressions(flowFile).getValue();
            CellProcessor[] cellProcs = null;
            if (schema != null) {
                cellProcs = this.parseSchema(schema);
            }
            isWholeFFValidation = !(validationStrategy = context.getProperty(VALIDATION_STRATEGY).getValue()).equals(VALIDATE_LINES_INDIVIDUALLY.getValue());
            boolean includeAllViolations = context.getProperty(INCLUDE_ALL_VIOLATIONS).asBoolean();
            valid = true;
            okCount = 0;
            totalCount = 0;
            invalidFF = null;
            validFF = null;
            validationError = null;
            AtomicReference<Boolean> isFirstLineValid = new AtomicReference<Boolean>(true);
            AtomicReference<Boolean> isFirstLineInvalid = new AtomicReference<Boolean>(true);
            if (!isWholeFFValidation) {
                invalidFF = session.create(flowFile);
                validFF = session.create(flowFile);
            }
            if (isWholeFFValidation && context.getProperty(CSV_SOURCE_ATTRIBUTE).isSet()) {
                String csvAttribute = flowFile.getAttribute(context.getProperty(CSV_SOURCE_ATTRIBUTE).evaluateAttributeExpressions().getValue());
                stream = new ByteArrayInputStream(Objects.requireNonNullElse(csvAttribute, "").getBytes(StandardCharsets.UTF_8));
            } else {
                stream = session.read(flowFile);
            }
            try (NifiCsvListReader listReader = new NifiCsvListReader(this, new InputStreamReader(stream), csvPref);){
                if (header) {
                    List headers = listReader.read();
                    if (schema == null) {
                        if (headers == null || headers.isEmpty()) {
                            validationError = "No schema or CSV header could be identified.";
                            valid = false;
                            break block34;
                        }
                        String newSchema = "Optional(StrNotNullOrEmpty()),".repeat(headers.size());
                        schema = newSchema.substring(0, newSchema.length() - 1);
                        cellProcs = this.parseSchema(schema);
                    }
                    if (!isWholeFFValidation) {
                        invalidFF = session.append(invalidFF, out -> out.write(this.print(listReader.getUntokenizedRow(), csvPref, true)));
                        validFF = session.append(validFF, out -> out.write(this.print(listReader.getUntokenizedRow(), csvPref, true)));
                        isFirstLineValid.set(false);
                        isFirstLineInvalid.set(false);
                    }
                }
                boolean stop = false;
                while (!stop) {
                    try {
                        boolean bl = stop = listReader.read(includeAllViolations && valid, cellProcs) == null;
                        if (isWholeFFValidation || stop) continue;
                        validFF = session.append(validFF, out -> out.write(this.print(listReader.getUntokenizedRow(), csvPref, (Boolean)isFirstLineValid.get())));
                        ++okCount;
                        if (!isFirstLineValid.get().booleanValue()) continue;
                        isFirstLineValid.set(false);
                    }
                    catch (SuperCsvException e) {
                        valid = false;
                        if (isWholeFFValidation) {
                            validationError = e.getLocalizedMessage();
                            logger.debug("Failed to validate {} against schema due to {}; routing to 'invalid'", new Object[]{flowFile, e});
                            break;
                        }
                        invalidFF = session.append(invalidFF, out -> out.write(this.print(listReader.getUntokenizedRow(), csvPref, (Boolean)isFirstLineInvalid.get())));
                        if (isFirstLineInvalid.get().booleanValue()) {
                            isFirstLineInvalid.set(false);
                        }
                        if (validationError != null) continue;
                        validationError = e.getLocalizedMessage();
                    }
                    finally {
                        if (isWholeFFValidation) continue;
                        ++totalCount;
                    }
                }
            }
            catch (IOException e) {
                valid = false;
                logger.error("Failed to validate {} against schema due to {}", new Object[]{flowFile, e});
            }
        }
        if (isWholeFFValidation) {
            if (valid) {
                logger.debug("Successfully validated {} against schema; routing to 'valid'", new Object[]{flowFile});
                session.getProvenanceReporter().route(flowFile, REL_VALID);
                session.transfer(flowFile, REL_VALID);
            } else {
                session.getProvenanceReporter().route(flowFile, REL_INVALID);
                session.putAttribute(flowFile, "validation.error.message", validationError);
                session.transfer(flowFile, REL_INVALID);
            }
        } else if (valid) {
            logger.debug("Successfully validated {} against schema; routing to 'valid'", new Object[]{validFF});
            session.getProvenanceReporter().route(validFF, REL_VALID, "All " + totalCount + " line(s) are valid");
            session.putAttribute(validFF, "count.valid.lines", Integer.toString(totalCount));
            session.putAttribute(validFF, "count.total.lines", Integer.toString(totalCount));
            session.transfer(validFF, REL_VALID);
            session.remove(invalidFF);
            session.remove(flowFile);
        } else if (okCount != 0) {
            logger.debug("Successfully validated {}/{} line(s) in {} against schema; routing valid lines to 'valid' and invalid lines to 'invalid'", new Object[]{okCount, --totalCount, flowFile});
            session.getProvenanceReporter().route(validFF, REL_VALID, okCount + " valid line(s)");
            session.putAttribute(validFF, "count.total.lines", Integer.toString(totalCount));
            session.putAttribute(validFF, "count.valid.lines", Integer.toString(okCount));
            session.transfer(validFF, REL_VALID);
            session.getProvenanceReporter().route(invalidFF, REL_INVALID, totalCount - okCount + " invalid line(s)");
            session.putAttribute(invalidFF, "count.invalid.lines", Integer.toString(totalCount - okCount));
            session.putAttribute(invalidFF, "count.total.lines", Integer.toString(totalCount));
            session.putAttribute(invalidFF, "validation.error.message", validationError);
            session.transfer(invalidFF, REL_INVALID);
            session.remove(flowFile);
        } else {
            logger.debug("All lines in {} are invalid; routing to 'invalid'", new Object[]{invalidFF});
            session.getProvenanceReporter().route(invalidFF, REL_INVALID, "All " + totalCount + " line(s) are invalid");
            session.putAttribute(invalidFF, "count.invalid.lines", Integer.toString(totalCount));
            session.putAttribute(invalidFF, "count.total.lines", Integer.toString(totalCount));
            session.putAttribute(invalidFF, "validation.error.message", validationError);
            session.transfer(invalidFF, REL_INVALID);
            session.remove(validFF);
            session.remove(flowFile);
        }
    }

    private byte[] print(String row, CsvPreference csvPref, boolean isFirstLine) {
        StringBuffer buffer = new StringBuffer();
        if (!isFirstLine) {
            buffer.append(csvPref.getEndOfLineSymbols());
        }
        return buffer.append(row).toString().getBytes();
    }

    private class NifiCsvListReader
    extends CsvListReader {
        public NifiCsvListReader(ValidateCsv validateCsv, Reader reader, CsvPreference preferences) {
            super(reader, preferences);
        }

        public List<Object> read(boolean includeAllViolations, CellProcessor ... processors) throws IOException {
            if (processors == null) {
                throw new NullPointerException("Processors should not be null");
            }
            if (this.readRow()) {
                this.executeProcessors(new ArrayList<Object>(this.getColumns().size()), processors, includeAllViolations);
                return new ArrayList<Object>(this.getColumns());
            }
            return null;
        }

        protected List<Object> executeProcessors(List<Object> processedColumns, CellProcessor[] processors, boolean includeAllViolations) {
            this.executeCellProcessors(processedColumns, this.getColumns(), processors, this.getLineNumber(), this.getRowNumber(), includeAllViolations);
            return processedColumns;
        }

        private void executeCellProcessors(List<Object> destination, List<?> source, CellProcessor[] processors, int lineNo, int rowNo, boolean includeAllViolations) {
            CsvContext context = new CsvContext(lineNo, rowNo, 1);
            context.setRowSource(new ArrayList(source));
            if (source.size() != processors.length) {
                throw new SuperCsvException(String.format("The number of columns to be processed (%d) must match the number of CellProcessors (%d): check that the number of CellProcessors you have defined matches the expected number of columns being read/written", source.size(), processors.length), context);
            }
            destination.clear();
            ArrayList<Object> errors = new ArrayList<Object>();
            for (int i = 0; i < source.size(); ++i) {
                try {
                    context.setColumnNumber(i + 1);
                    if (processors[i] == null) {
                        destination.add(source.get(i));
                        continue;
                    }
                    destination.add(processors[i].execute(source.get(i), context));
                    continue;
                }
                catch (SuperCsvException e) {
                    String errorMessage;
                    String coordinates;
                    if (includeAllViolations) {
                        if (errors.isEmpty()) {
                            errors.add(String.format("At {line=%d, row=%d}", e.getCsvContext().getLineNumber(), e.getCsvContext().getRowNumber()));
                        }
                        coordinates = String.format("{column=%d}", e.getCsvContext().getColumnNumber());
                        errorMessage = e.getLocalizedMessage() + " at " + coordinates;
                        errors.add(errorMessage);
                        continue;
                    }
                    coordinates = String.format("{line=%d, row=%d, column=%d}", e.getCsvContext().getLineNumber(), e.getCsvContext().getRowNumber(), e.getCsvContext().getColumnNumber());
                    errorMessage = e.getLocalizedMessage() + " at " + coordinates;
                    throw new SuperCsvException(errorMessage);
                }
            }
            if (!errors.isEmpty()) {
                throw new SuperCsvException(String.join((CharSequence)", ", errors));
            }
        }
    }
}

