/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.datafaker.Faker;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.avro.AvroSchemaValidator;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.faker.FakerUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.DecimalDataType;
import org.apache.nifi.serialization.record.type.EnumDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.util.StringUtils;

@SupportsBatching
@Tags(value={"test", "random", "generate", "fake"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile")})
@CapabilityDescription(value="This processor creates FlowFiles with records having random value for the specified fields. GenerateRecord is useful for testing, configuration, and simulation. It uses either user-defined properties to define a record schema or a provided schema and generates the specified number of records using random data for the fields in the schema.")
@DynamicProperties(value={@DynamicProperty(name="Field name in generated record", value="Faker category for generated record values", description="Custom properties define the generated record schema using configured field names and value data types in absence of the Schema Text property")})
public class GenerateRecord
extends AbstractProcessor {
    private static final AllowableValue[] fakerDatatypeValues = FakerUtils.createFakerPropertyList();
    private static final String KEY1 = "key1";
    private static final String KEY2 = "key2";
    private static final String KEY3 = "key3";
    private static final String KEY4 = "key4";
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Writer").description("Specifies the Controller Service to use for writing out the records").identifiesControllerService(RecordSetWriterFactory.class).required(true).build();
    static final PropertyDescriptor NUM_RECORDS = new PropertyDescriptor.Builder().name("number-of-records").displayName("Number of Records").description("Specifies how many records will be generated for each outgoing FlowFile.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("100").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor NULLABLE_FIELDS = new PropertyDescriptor.Builder().name("nullable-fields").displayName("Nullable Fields").description("Whether the generated fields will be nullable. Note that this property is ignored if Schema Text is set. Also it only affects the schema of the generated data, not whether any values will be null. If this property is true, see 'Null Value Percentage' to set the probability that any generated field will be null.").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    static final PropertyDescriptor NULL_PERCENTAGE = new PropertyDescriptor.Builder().name("null-percentage").displayName("Null Value Percentage").description("The percent probability (0-100%) that a generated value for any nullable field will be null. Set this property to zero to have no null values, or 100 to have all null values.").addValidator(StandardValidators.createLongValidator((long)0L, (long)100L, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).defaultValue("0").dependsOn(NULLABLE_FIELDS, "true", new String[0]).build();
    static final PropertyDescriptor SCHEMA_TEXT = new PropertyDescriptor.Builder().name("schema-text").displayName("Schema Text").description("The text of an Avro-formatted Schema used to generate record data. If this property is set, any user-defined properties are ignored.").addValidator((Validator)new AvroSchemaValidator()).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(RECORD_WRITER, NUM_RECORDS, NULLABLE_FIELDS, NULL_PERCENTAGE, SCHEMA_TEXT);
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are successfully created will be routed to this relationship").build();
    static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);
    private volatile Faker faker = new Faker();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues((DescribedValue[])fakerDatatypeValues).defaultValue("Address.fullAddress").required(false).dynamic(true).build();
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.faker = new Faker(Locale.US);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String schemaText = context.getProperty(SCHEMA_TEXT).evaluateAttributeExpressions().getValue();
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        int numRecords = context.getProperty(NUM_RECORDS).evaluateAttributeExpressions().asInteger();
        boolean nullable = context.getProperty(NULLABLE_FIELDS).asBoolean();
        int nullPercentage = nullable ? context.getProperty(NULL_PERCENTAGE).evaluateAttributeExpressions().asInteger() : 0;
        FlowFile flowFile = session.create();
        HashMap attributes = new HashMap();
        AtomicInteger recordCount = new AtomicInteger();
        try {
            flowFile = session.write(flowFile, out -> {
                boolean usingSchema;
                RecordSchema recordSchema;
                if (StringUtils.isNotEmpty((String)schemaText)) {
                    Schema avroSchema = new Schema.Parser().parse(schemaText);
                    recordSchema = AvroTypeUtil.createSchema((Schema)avroSchema);
                    usingSchema = true;
                } else {
                    Map<String, String> fields = this.getFields(context);
                    recordSchema = this.generateRecordSchema(fields, nullable);
                    usingSchema = false;
                }
                try {
                    RecordSchema writeSchema = writerFactory.getSchema(attributes, recordSchema);
                    try (RecordSetWriter writer = writerFactory.createWriter(this.getLogger(), writeSchema, out, attributes);){
                        writer.beginRecordSet();
                        List writeFieldNames = writeSchema.getFields();
                        HashMap<String, Object> recordEntries = new HashMap<String, Object>();
                        for (int i = 0; i < numRecords; ++i) {
                            for (RecordField writeRecordField : writeFieldNames) {
                                Object writeFieldValue;
                                String writeFieldName = writeRecordField.getFieldName();
                                if (usingSchema) {
                                    writeFieldValue = this.generateValueFromRecordField(writeRecordField, this.faker, nullPercentage);
                                } else {
                                    boolean nullValue;
                                    boolean bl = nullValue = nullPercentage > 0 && this.faker.number().numberBetween(0, 100) <= nullPercentage;
                                    if (nullValue) {
                                        writeFieldValue = null;
                                    } else {
                                        String propertyValue = context.getProperty(writeFieldName).getValue();
                                        writeFieldValue = FakerUtils.getFakeData(propertyValue, this.faker);
                                    }
                                }
                                recordEntries.put(writeFieldName, writeFieldValue);
                            }
                            MapRecord record = new MapRecord(recordSchema, recordEntries);
                            writer.write((Record)record);
                        }
                        WriteResult writeResult = writer.finishRecordSet();
                        attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                        attributes.put(CoreAttributes.MIME_TYPE.key(), writer.getMimeType());
                        attributes.putAll(writeResult.getAttributes());
                        recordCount.set(writeResult.getRecordCount());
                    }
                }
                catch (SchemaNotFoundException e) {
                    throw new ProcessException("Schema not found while writing records", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ProcessException) {
                throw e;
            }
            throw new ProcessException("Record generation failed", (Throwable)e);
        }
        flowFile = session.putAllAttributes(flowFile, attributes);
        session.transfer(flowFile, REL_SUCCESS);
        int count = recordCount.get();
        session.adjustCounter("Records Processed", (long)count, false);
        this.getLogger().info("Generated records [{}] for {}", new Object[]{count, flowFile});
    }

    protected Map<String, String> getFields(ProcessContext context) {
        return context.getProperties().entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).isDynamic() && e.getValue() != null).collect(Collectors.toMap(e -> ((PropertyDescriptor)e.getKey()).getName(), e -> context.getProperty((PropertyDescriptor)e.getKey()).getValue()));
    }

    private Object generateValueFromRecordField(RecordField recordField, Faker faker, int nullPercentage) {
        if (recordField.isNullable() && faker.number().numberBetween(0, 100) < nullPercentage) {
            return null;
        }
        return switch (recordField.getDataType().getFieldType()) {
            default -> throw new MatchException(null, null);
            case RecordFieldType.BIGINT -> new BigInteger(String.valueOf(faker.number().numberBetween(Long.MIN_VALUE, Long.MAX_VALUE)));
            case RecordFieldType.BOOLEAN -> FakerUtils.getFakeData("Bool.bool", faker);
            case RecordFieldType.BYTE -> (byte)faker.number().numberBetween(-128, 127);
            case RecordFieldType.CHAR -> Character.valueOf((char)faker.number().numberBetween(0, 65535));
            case RecordFieldType.DATE -> FakerUtils.getFakeData("DateAndTime.pastDate", faker);
            case RecordFieldType.DOUBLE -> faker.number().randomDouble(6, Long.MIN_VALUE, Long.MAX_VALUE);
            case RecordFieldType.FLOAT -> {
                double randomDouble = faker.number().randomDouble(6, Long.MIN_VALUE, Long.MAX_VALUE);
                yield Float.valueOf((float)randomDouble);
            }
            case RecordFieldType.DECIMAL -> faker.number().randomDouble(((DecimalDataType)recordField.getDataType()).getScale(), Long.MIN_VALUE, Long.MAX_VALUE);
            case RecordFieldType.INT -> faker.number().numberBetween(Integer.MIN_VALUE, Integer.MAX_VALUE);
            case RecordFieldType.LONG -> faker.number().numberBetween(Long.MIN_VALUE, Long.MAX_VALUE);
            case RecordFieldType.SHORT -> faker.number().numberBetween(Short.MIN_VALUE, Short.MAX_VALUE);
            case RecordFieldType.ENUM -> {
                List enums = ((EnumDataType)recordField.getDataType()).getEnums();
                yield (String)enums.get(faker.number().numberBetween(0, enums.size() - 1));
            }
            case RecordFieldType.TIME -> {
                Date fakeDate = (Date)FakerUtils.getFakeData("DateAndTime.pastDate", faker);
                LocalDate fakeLocalDate = fakeDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                yield fakeLocalDate.format(DateTimeFormatter.ISO_LOCAL_TIME);
            }
            case RecordFieldType.TIMESTAMP -> ((Date)FakerUtils.getFakeData("DateAndTime.pastDate", faker)).getTime();
            case RecordFieldType.UUID -> UUID.randomUUID();
            case RecordFieldType.ARRAY -> {
                ArrayDataType arrayDataType = (ArrayDataType)recordField.getDataType();
                DataType elementType = arrayDataType.getElementType();
                int numElements = faker.number().numberBetween(0, 10);
                Object[] returnValue = new Object[numElements];
                for (int i = 0; i < numElements; ++i) {
                    RecordField tempRecordField = new RecordField(recordField.getFieldName() + "[" + i + "]", elementType, arrayDataType.isElementsNullable());
                    returnValue[i] = this.generateValueFromRecordField(tempRecordField, faker, arrayDataType.isElementsNullable() ? nullPercentage : 0);
                }
                yield returnValue;
            }
            case RecordFieldType.MAP -> {
                MapDataType mapDataType = (MapDataType)recordField.getDataType();
                DataType valueType = mapDataType.getValueType();
                HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
                returnMap.put(KEY1, this.generateValueFromRecordField(new RecordField(KEY1, valueType), faker, nullPercentage));
                returnMap.put(KEY2, this.generateValueFromRecordField(new RecordField(KEY2, valueType), faker, nullPercentage));
                returnMap.put(KEY3, this.generateValueFromRecordField(new RecordField(KEY3, valueType), faker, nullPercentage));
                returnMap.put(KEY4, this.generateValueFromRecordField(new RecordField(KEY4, valueType), faker, nullPercentage));
                yield returnMap;
            }
            case RecordFieldType.RECORD -> {
                RecordDataType recordType = (RecordDataType)recordField.getDataType();
                RecordSchema childSchema = recordType.getChildSchema();
                HashMap<String, Object> recordValues = new HashMap<String, Object>();
                for (RecordField writeRecordField : childSchema.getFields()) {
                    String writeFieldName = writeRecordField.getFieldName();
                    Object writeFieldValue = this.generateValueFromRecordField(writeRecordField, faker, nullPercentage);
                    recordValues.put(writeFieldName, writeFieldValue);
                }
                yield new MapRecord(childSchema, recordValues);
            }
            case RecordFieldType.CHOICE -> {
                ChoiceDataType choiceDataType = (ChoiceDataType)recordField.getDataType();
                List subTypes = choiceDataType.getPossibleSubTypes();
                DataType chosenType = (DataType)subTypes.get(faker.number().numberBetween(0, subTypes.size() - 1));
                RecordField tempRecordField = new RecordField(recordField.getFieldName(), chosenType);
                yield this.generateValueFromRecordField(tempRecordField, faker, nullPercentage);
            }
            case RecordFieldType.STRING -> this.generateRandomString();
        };
    }

    private String generateRandomString() {
        int categoryChoice = this.faker.number().numberBetween(0, 10);
        return switch (categoryChoice) {
            case 0 -> this.faker.name().fullName();
            case 1 -> this.faker.lorem().word();
            case 2 -> this.faker.shakespeare().romeoAndJulietQuote();
            case 3 -> this.faker.educator().university();
            case 4 -> this.faker.zelda().game();
            case 5 -> this.faker.company().name();
            case 6 -> this.faker.chuckNorris().fact();
            case 7 -> this.faker.book().title();
            case 8 -> this.faker.dog().breed();
            default -> this.faker.animal().name();
        };
    }

    protected RecordSchema generateRecordSchema(Map<String, String> fields, boolean nullable) {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>(fields.size());
        for (Map.Entry<String, String> field : fields.entrySet()) {
            String fieldName = field.getKey();
            String fieldType = field.getValue();
            DataType fieldDataType = FakerUtils.getDataType(fieldType);
            RecordField recordField = new RecordField(fieldName, fieldDataType, nullable);
            recordFields.add(recordField);
        }
        return new SimpleRecordSchema(recordFields);
    }
}

