/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.merge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.standard.merge.AttributeStrategy;

public class KeepUniqueAttributeStrategy
implements AttributeStrategy {
    @Override
    public Map<String, String> getMergedAttributes(List<FlowFile> flowFiles) {
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        HashSet<String> conflicting = new HashSet<String>();
        for (FlowFile flowFile : flowFiles) {
            for (Map.Entry attributeEntry : flowFile.getAttributes().entrySet()) {
                String name = (String)attributeEntry.getKey();
                String value = (String)attributeEntry.getValue();
                String existingValue = (String)newAttributes.get(name);
                if (existingValue != null && !existingValue.equals(value)) {
                    conflicting.add(name);
                    continue;
                }
                newAttributes.put(name, value);
            }
        }
        for (String attributeToRemove : conflicting) {
            newAttributes.remove(attributeToRemove);
        }
        newAttributes.remove(CoreAttributes.UUID.key());
        return newAttributes;
    }
}

