/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.merge;

import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.merge.AttributeStrategy;
import org.apache.nifi.processors.standard.merge.KeepCommonAttributeStrategy;
import org.apache.nifi.processors.standard.merge.KeepUniqueAttributeStrategy;

public class AttributeStrategyUtil {
    public static final AllowableValue ATTRIBUTE_STRATEGY_ALL_COMMON = new AllowableValue("Keep Only Common Attributes", "Keep Only Common Attributes", "Any attribute that is not the same on all FlowFiles in a bin will be dropped. Those that are the same across all FlowFiles will be retained.");
    public static final AllowableValue ATTRIBUTE_STRATEGY_ALL_UNIQUE = new AllowableValue("Keep All Unique Attributes", "Keep All Unique Attributes", "Any attribute that has the same value for all FlowFiles in a bin, or has no value for a FlowFile, will be kept. For example, if a bin consists of 3 FlowFiles and 2 of them have a value of 'hello' for the 'greeting' attribute and the third FlowFile has no 'greeting' attribute then the outbound FlowFile will get a 'greeting' attribute with the value 'hello'.");
    public static final PropertyDescriptor ATTRIBUTE_STRATEGY = new PropertyDescriptor.Builder().required(true).name("Attribute Strategy").description("Determines which FlowFile attributes should be added to the bundle. If 'Keep All Unique Attributes' is selected, any attribute on any FlowFile that gets bundled will be kept unless its value conflicts with the value from another FlowFile. If 'Keep Only Common Attributes' is selected, only the attributes that exist on all FlowFiles in the bundle, with the same value, will be preserved.").allowableValues(new DescribedValue[]{ATTRIBUTE_STRATEGY_ALL_COMMON, ATTRIBUTE_STRATEGY_ALL_UNIQUE}).defaultValue(ATTRIBUTE_STRATEGY_ALL_COMMON.getValue()).build();

    public static AttributeStrategy strategyFor(ProcessContext context) {
        String strategyName = context.getProperty(ATTRIBUTE_STRATEGY).getValue();
        if (ATTRIBUTE_STRATEGY_ALL_UNIQUE.getValue().equals(strategyName)) {
            return new KeepUniqueAttributeStrategy();
        }
        if (ATTRIBUTE_STRATEGY_ALL_COMMON.getValue().equals(strategyName)) {
            return new KeepCommonAttributeStrategy();
        }
        return null;
    }
}

