/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.faker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.datafaker.Faker;
import net.datafaker.service.files.EnFile;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.faker.FakerMethodHolder;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;

public class FakerUtils {
    public static final String DEFAULT_DATE_PROPERTY_NAME = "DateAndTime.pastDate";
    private static final int RANDOM_DATE_DAYS = 365;
    private static final Map<String, FakerMethodHolder> datatypeFunctionMap = new LinkedHashMap<String, FakerMethodHolder>();
    private static final List<String> PROVIDER_PACKAGES = List.of("base", "entertainment", "food", "sport", "videogame");
    static final AllowableValue FT_BOOL = new AllowableValue("Boolean.bool", "Boolean - bool (true/false)", "A value of 'true' or 'false'");
    static final AllowableValue FT_FUTURE_DATE = new AllowableValue("DateAndTime.futureDate", "Date And Time - Future Date", "Generates a date up to one year in the future from the time the processor is executed");
    static final AllowableValue FT_PAST_DATE = new AllowableValue("DateAndTime.pastDate", "Date And Time - Past Date", "Generates a date up to one year in the past from the time the processor is executed");
    static final AllowableValue FT_BIRTHDAY = new AllowableValue("DateAndTime.birthday", "Date And Time - Birthday", "Generates a random birthday between 65 and 18 years ago");
    static final AllowableValue FT_NUMBER = new AllowableValue("Number.Integer", "Number - Integer", "A integer number");
    static final AllowableValue FT_SHA256 = new AllowableValue("Crypto.SHA-256", "Crypto - SHA-256", "A SHA-256 hash");
    static final AllowableValue FT_SHA512 = new AllowableValue("Crypto.SHA-512", "Crypto - SHA-512", "A SHA-512 hash");
    private static final String PACKAGE_PREFIX = "net.datafaker.providers";

    public static AllowableValue[] createFakerPropertyList() {
        List fakerFiles = EnFile.getFiles().toList();
        HashMap possibleFakerTypeMap = new HashMap(fakerFiles.size());
        for (EnFile fakerFile : fakerFiles) {
            String className = FakerUtils.normalizeClassName(fakerFile.getFile().substring(0, fakerFile.getFile().indexOf(46)));
            try {
                Class<?> fakerTypeClass = null;
                for (String subPackage : PROVIDER_PACKAGES) {
                    try {
                        fakerTypeClass = Class.forName("net.datafaker.providers." + subPackage + "." + className);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                if (fakerTypeClass == null) continue;
                possibleFakerTypeMap.put(className, fakerTypeClass);
            }
            catch (Exception fakerTypeClass) {}
        }
        Faker faker = new Faker();
        ArrayList<AllowableValue> supportedDataTypes = new ArrayList<AllowableValue>();
        for (Map.Entry entry : possibleFakerTypeMap.entrySet()) {
            List<Method> fakerMethods = Arrays.stream(((Class)entry.getValue()).getDeclaredMethods()).filter(method -> Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 0 && method.getReturnType() == String.class).toList();
            try {
                Object methodObject = faker.getClass().getMethod(FakerUtils.normalizeMethodName((String)entry.getKey()), new Class[0]).invoke((Object)faker, new Object[0]);
                for (Method method2 : fakerMethods) {
                    String allowableValueName = FakerUtils.normalizeClassName((String)entry.getKey()) + "." + method2.getName();
                    String allowableValueDisplayName = FakerUtils.normalizeDisplayName((String)entry.getKey()) + " - " + FakerUtils.normalizeDisplayName(method2.getName());
                    datatypeFunctionMap.put(allowableValueName, new FakerMethodHolder(allowableValueName, methodObject, method2));
                    supportedDataTypes.add(new AllowableValue(allowableValueName, allowableValueDisplayName, allowableValueDisplayName));
                }
            }
            catch (Exception exception) {
            }
        }
        supportedDataTypes.add(FT_FUTURE_DATE);
        supportedDataTypes.add(FT_PAST_DATE);
        supportedDataTypes.add(FT_BIRTHDAY);
        supportedDataTypes.add(FT_NUMBER);
        supportedDataTypes.add(FT_SHA256);
        supportedDataTypes.add(FT_SHA512);
        supportedDataTypes.sort(Comparator.comparing(AllowableValue::getDisplayName));
        return supportedDataTypes.toArray(new AllowableValue[0]);
    }

    public static Object getFakeData(String type, Faker faker) {
        if (FT_NUMBER.getValue().equals(type)) {
            return faker.number().numberBetween(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (FT_FUTURE_DATE.getValue().equals(type)) {
            return faker.timeAndDate().future(365L, TimeUnit.DAYS);
        }
        if (FT_PAST_DATE.getValue().equals(type)) {
            return faker.timeAndDate().past(365L, TimeUnit.DAYS);
        }
        if (FT_BIRTHDAY.getValue().equals(type)) {
            return faker.timeAndDate().birthday();
        }
        if (FT_SHA256.getValue().equals(type)) {
            return faker.hashing().sha256();
        }
        if (FT_SHA512.getValue().equals(type)) {
            return faker.hashing().sha512();
        }
        try {
            FakerMethodHolder fakerMethodHolder = datatypeFunctionMap.get(type);
            return fakerMethodHolder.getMethod().invoke(fakerMethodHolder.getMethodObject(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ProcessException(type + " is not a valid value", (Throwable)e);
        }
    }

    public static DataType getDataType(String type) {
        if (FT_FUTURE_DATE.getValue().equals(type) || FT_PAST_DATE.getValue().equals(type) || FT_BIRTHDAY.getValue().equals(type)) {
            return RecordFieldType.DATE.getDataType();
        }
        if (FT_NUMBER.getValue().equals(type)) {
            return RecordFieldType.INT.getDataType();
        }
        if (FT_BOOL.getValue().equals(type)) {
            return RecordFieldType.BOOLEAN.getDataType();
        }
        return RecordFieldType.STRING.getDataType();
    }

    public static Map<String, FakerMethodHolder> getDatatypeFunctionMap() {
        return datatypeFunctionMap;
    }

    private static String normalizeClassName(String name) {
        String[] segments = name.split("_");
        return Arrays.stream(segments).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining());
    }

    private static String normalizeMethodName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private static String normalizeDisplayName(String name) {
        String[] upperCaseSegments = name.split("(?=\\p{Upper})");
        return Arrays.stream(upperCaseSegments).map(upperCaseSegment -> upperCaseSegment.substring(0, 1).toUpperCase() + upperCaseSegment.substring(1)).collect(Collectors.joining(" "));
    }
}

