/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.util.StringUtils;

public final class PhoenixDatabaseAdapter
implements DatabaseAdapter {
    public static final String NAME = "Phoenix";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Generates Phoenix compliant SQL";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        return this.getSelectStatement(tableName, columnNames, whereClause, orderByClause, limit, offset, null);
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset, String columnForPartitioning) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
                query.append(" AND ");
                query.append(columnForPartitioning);
                query.append(" >= ");
                query.append(offset != null ? offset : "0");
                if (limit != null) {
                    query.append(" AND ");
                    query.append(columnForPartitioning);
                    query.append(" < ");
                    query.append((offset == null ? 0L : offset) + limit);
                }
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderByClause) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            if (limit != null) {
                query.append(" LIMIT ");
                query.append(limit);
            }
            if (offset != null && offset > 0L) {
                query.append(" OFFSET ");
                query.append(offset);
            }
        }
        return query.toString();
    }

    @Override
    public String getUpsertStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String columns = String.join((CharSequence)", ", columnNames);
        String parameterizedUpsertValues = columnNames.stream().map(columnName -> "?").collect(Collectors.joining(", "));
        StringBuilder statementStringBuilder = new StringBuilder("UPSERT INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedUpsertValues).append(")");
        return statementStringBuilder.toString();
    }

    @Override
    public boolean supportsUpsert() {
        return true;
    }

    @Override
    public boolean supportsCreateTableIfNotExists() {
        return true;
    }

    @Override
    public String getAlterTableStatement(String tableName, List<ColumnDescription> columnsToAdd) {
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columnsToAdd.size());
        for (ColumnDescription column : columnsToAdd) {
            String dataType = this.getSQLForDataType(column.getDataType());
            StringBuilder sb = new StringBuilder("ADD COLUMN ").append(column.getColumnName()).append(" ").append(dataType);
            columnsAndDatatypes.add(sb.toString());
        }
        StringBuilder alterTableStatement = new StringBuilder();
        return alterTableStatement.append("ALTER TABLE ").append(tableName).append(" ").append(String.join((CharSequence)", ", columnsAndDatatypes)).toString();
    }

    @Override
    public String getSQLForDataType(int sqlType) {
        switch (sqlType) {
            case 8: {
                return "DOUBLE PRECISION";
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: 
            case 2009: 
            case 2011: {
                return "TEXT";
            }
        }
        return JDBCType.valueOf(sqlType).getName();
    }
}

