/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.util.file.monitor.LastModifiedMonitor;
import org.apache.nifi.util.file.monitor.SynchronousFileWatcher;
import org.apache.nifi.util.file.monitor.UpdateMonitor;
import org.apache.nifi.util.search.Search;
import org.apache.nifi.util.search.SearchTerm;
import org.apache.nifi.util.search.ahocorasick.SearchState;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"aho-corasick", "scan", "content", "byte sequence", "search", "find", "dictionary"})
@CapabilityDescription(value="Scans the content of FlowFiles for terms that are found in a user-supplied dictionary. If a term is matched, the UTF-8 encoded version of the term will be added to the FlowFile using the 'matching.term' attribute")
@WritesAttribute(attribute="matching.term", description="The term that caused the Processor to route the FlowFile to the 'matched' relationship; if FlowFile is routed to the 'unmatched' relationship, this attribute is not added")
public class ScanContent
extends AbstractProcessor {
    public static final String TEXT_ENCODING = "text";
    public static final String BINARY_ENCODING = "binary";
    public static final String MATCH_ATTRIBUTE_KEY = "matching.term";
    public static final PropertyDescriptor DICTIONARY = new PropertyDescriptor.Builder().name("Dictionary File").description("The filename of the terms dictionary").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).build();
    public static final PropertyDescriptor DICTIONARY_ENCODING = new PropertyDescriptor.Builder().name("Dictionary Encoding").description("Indicates how the dictionary is encoded. If 'text', dictionary terms are new-line delimited and UTF-8 encoded; if 'binary', dictionary terms are denoted by a 4-byte integer indicating the term length followed by the term itself").required(true).allowableValues(new String[]{"text", "binary"}).defaultValue("text").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(DICTIONARY, DICTIONARY_ENCODING);
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("FlowFiles that match at least one term in the dictionary are routed to this relationship").build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("FlowFiles that do not match any term in the dictionary are routed to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_MATCH, REL_NO_MATCH);
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    private final AtomicReference<SynchronousFileWatcher> fileWatcherRef = new AtomicReference();
    private final AtomicReference<Search<byte[]>> searchRef = new AtomicReference();
    private final ReentrantLock dictionaryUpdateLock = new ReentrantLock();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)DICTIONARY)) {
            this.fileWatcherRef.set(new SynchronousFileWatcher(Paths.get(newValue, new String[0]), (UpdateMonitor)new LastModifiedMonitor(), 60000L));
        }
    }

    /*
     * Exception decompiling
     */
    private boolean reloadDictionary(ProcessContext context, boolean force, ComponentLog logger) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TermLoader createTermLoader(ProcessContext context, InputStream in) {
        if (context.getProperty(DICTIONARY_ENCODING).getValue().equalsIgnoreCase(TEXT_ENCODING)) {
            return new TextualTermLoader(in);
        }
        return new BinaryTermLoader(in);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ComponentLog logger = this.getLogger();
        SynchronousFileWatcher fileWatcher = this.fileWatcherRef.get();
        try {
            if (fileWatcher.checkAndReset()) {
                this.reloadDictionary(context, true, logger);
            }
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        Search<byte[]> search = this.searchRef.get();
        try {
            if (search == null && this.reloadDictionary(context, false, logger)) {
                search = this.searchRef.get();
            }
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        if (search == null) {
            return;
        }
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Search<byte[]> finalSearch = search;
        AtomicReference<Object> termRef = new AtomicReference<Object>(null);
        termRef.set(null);
        session.read(flowFile, rawIn -> {
            try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                SearchState searchResult = finalSearch.search((InputStream)in, false);
                if (searchResult.foundMatch()) {
                    termRef.set(((SearchTerm)searchResult.getResults().keySet().iterator().next()));
                }
            }
        });
        SearchTerm matchingTerm = termRef.get();
        if (matchingTerm == null) {
            logger.info("Routing {} to 'unmatched'", new Object[]{flowFile});
            session.getProvenanceReporter().route(flowFile, REL_NO_MATCH);
            session.transfer(flowFile, REL_NO_MATCH);
        } else {
            String matchingTermString = matchingTerm.toString(UTF8);
            logger.info("Routing {} to 'matched' because it matched term {}", new Object[]{flowFile, matchingTermString});
            flowFile = session.putAttribute(flowFile, MATCH_ATTRIBUTE_KEY, matchingTermString);
            session.getProvenanceReporter().route(flowFile, REL_MATCH);
            session.transfer(flowFile, REL_MATCH);
        }
    }

    private static interface TermLoader
    extends Closeable {
        public SearchTerm<byte[]> nextTerm() throws IOException;
    }

    private static class TextualTermLoader
    implements TermLoader {
        private final BufferedReader reader;

        public TextualTermLoader(InputStream inStream) {
            this.reader = new BufferedReader(new InputStreamReader(inStream));
        }

        @Override
        public SearchTerm<byte[]> nextTerm() throws IOException {
            String nextLine = this.reader.readLine();
            if (nextLine == null || nextLine.isEmpty()) {
                return null;
            }
            return new SearchTerm(nextLine.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class BinaryTermLoader
    implements TermLoader {
        private final DataInputStream inStream;

        public BinaryTermLoader(InputStream inStream) {
            this.inStream = new DataInputStream(new BufferedInputStream(inStream));
        }

        @Override
        public SearchTerm<byte[]> nextTerm() throws IOException {
            this.inStream.mark(1);
            int nextByte = this.inStream.read();
            if (nextByte == -1) {
                return null;
            }
            this.inStream.reset();
            int termLength = this.inStream.readInt();
            byte[] term = new byte[termLength];
            this.inStream.readFully(term);
            return new SearchTerm(term);
        }

        @Override
        public void close() throws IOException {
            this.inStream.close();
        }
    }
}

