/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Servlet;
import jakarta.ws.rs.Path;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.jetty.configuration.connector.StandardServerConnectorFactory;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.ControlRate;
import org.apache.nifi.processors.standard.filters.HttpMethodFilter;
import org.apache.nifi.processors.standard.http.HttpProtocolStrategy;
import org.apache.nifi.processors.standard.servlets.ContentAcknowledgmentServlet;
import org.apache.nifi.processors.standard.servlets.HealthCheckServlet;
import org.apache.nifi.processors.standard.servlets.ListenHTTPServlet;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.ssl.SSLContextProvider;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"ingest", "http", "https", "rest", "listen"})
@CapabilityDescription(value="Starts an HTTP Server and listens on a given base path to transform incoming requests into FlowFiles. The default URI of the Service will be http://{hostname}:{port}/contentListener. Only HEAD and POST requests are supported. GET, PUT, DELETE, OPTIONS and TRACE will result in an error and the HTTP response status code 405; CONNECT will also result in an error and the HTTP response status code 400. GET is supported on <service_URI>/healthcheck. If the service is available, it returns \"200 OK\" with the content \"OK\". The health check functionality can be configured to be accessible via a different port. For details see the documentation of the \"Listening Port for health check requests\" property. A Record Reader and Record Writer property can be enabled on the processor to process incoming requests as records. Record processing is not allowed for multipart requests and request in FlowFileV3 format (minifi).")
@UseCase(description="Unpack FlowFileV3 content received in a POST", keywords={"flowfile", "flowfilev3", "unpack"}, notes="POST requests with \"Content-Type: application/flowfile-v3\" will have their payload interpreted as FlowFileV3 format\nand will be automatically unpacked. This will output the original FlowFile(s) from within the FlowFileV3 format and\nwill not require a separate UnpackContent processor.\n", configuration="This feature of ListenHTTP is always on, no configuration required.\n\nThe MergeContent and PackageFlowFile processors can generate FlowFileV3 formatted data.\n")
@MultiProcessorUseCase(description="Limit the date flow rate that is accepted", keywords={"rate", "limit"}, notes="When ListenHTTP cannot output FlowFiles due to back pressure, it will send HTTP 503 Service Unavailable\nresponse to clients, or deny connections, until more space is available in the output queue.\n", configurations={@ProcessorConfiguration(processorClass=ListenHTTP.class, configuration="Connect the 'success' relationship of ListenHTTP to a ControlRate processor and configure back pressure on that\nconnection so that a small amount of data will fill the queue. The size of the back pressure configuration\ndetermines how much data to buffer to handle spikes in rate without affecting clients.\n"), @ProcessorConfiguration(processorClass=ControlRate.class, configuration="Use the ControlRate properties to set the desired data flow rate limit. When the limit it reached,\nthe ControlRate input connection will start accumulating files. When this connection is full, ListenHTTP\nwill limit the input data flow rate.\n")})
public class ListenHTTP
extends AbstractSessionFactoryProcessor {
    private static final String MATCH_ALL = ".*";
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean runOnPrimary = new AtomicBoolean(false);
    public static final PropertyDescriptor BASE_PATH = new PropertyDescriptor.Builder().name("Base Path").description("Base path for incoming connections").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("contentListener").addValidator(StandardValidators.URI_VALIDATOR).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("(^[^/]+.*[^/]+$|^[^/]+$|^$)"))).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Listening Port").description("The Port to listen on for incoming connections").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor HEALTH_CHECK_PORT = new PropertyDescriptor.Builder().name("health-check-port").displayName("Listening Port for Health Check Requests").description("The port to listen on for incoming health check requests. If set, it must be different from the Listening Port. Configure this port if the processor is set to use two-way SSL and a load balancer that does not support client authentication for health check requests is used. Only /<base_path>/healthcheck service is available via this port and only GET and HEAD requests are supported. If the processor is set not to use SSL, SSL will not be used on this port, either. If the processor is set to use one-way SSL, one-way SSL will be used on this port. If the processor is set to use two-way SSL, one-way SSL will be used on this port (client authentication not required).").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor AUTHORIZED_DN_PATTERN = new PropertyDescriptor.Builder().name("Authorized DN Pattern").displayName("Authorized Subject DN Pattern").description("A Regular Expression to apply against the Subject's Distinguished Name of incoming connections. If the Pattern does not match the Subject DN, the the processor will respond with a status of HTTP 403 Forbidden.").required(true).defaultValue(".*").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor AUTHORIZED_ISSUER_DN_PATTERN = new PropertyDescriptor.Builder().name("authorized-issuer-dn-pattern").displayName("Authorized Issuer DN Pattern").description("A Regular Expression to apply against the Issuer's Distinguished Name of incoming connections. If the Pattern does not match the Issuer DN, the processor will respond with a status of HTTP 403 Forbidden.").required(false).defaultValue(".*").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor MAX_UNCONFIRMED_TIME = new PropertyDescriptor.Builder().name("Max Unconfirmed Flowfile Time").description("The maximum amount of time to wait for a FlowFile to be confirmed before it is removed from the cache").required(true).defaultValue("60 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("SSL Context Service enables support for HTTPS").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor HTTP_PROTOCOL_STRATEGY = new PropertyDescriptor.Builder().name("HTTP Protocols").description("HTTP Protocols supported for Application Layer Protocol Negotiation with TLS").required(true).allowableValues(HttpProtocolStrategy.class).defaultValue((DescribedValue)HttpProtocolStrategy.HTTP_1_1).dependsOn(SSL_CONTEXT_SERVICE, new AllowableValue[0]).build();
    public static final PropertyDescriptor HEADERS_AS_ATTRIBUTES_REGEX = new PropertyDescriptor.Builder().name("HTTP Headers to receive as Attributes (Regex)").description("Specifies the Regular Expression that determines the names of HTTP Headers that should be passed along as FlowFile attributes").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(false).build();
    public static final PropertyDescriptor REQUEST_HEADER_MAX_SIZE = new PropertyDescriptor.Builder().name("Request Header Maximum Size").description("The maximum supported size of HTTP headers in requests sent to this processor").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("8 KB").build();
    public static final PropertyDescriptor RETURN_CODE = new PropertyDescriptor.Builder().name("Return Code").description("The HTTP return code returned after every HTTP call").defaultValue(String.valueOf(200)).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor MULTIPART_REQUEST_MAX_SIZE = new PropertyDescriptor.Builder().name("multipart-request-max-size").displayName("Multipart Request Max Size").description("The max size of the request. Only applies for requests with Content-Type: multipart/form-data, and is used to prevent denial of service type of attacks, to prevent filling up the heap or disk space").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    public static final PropertyDescriptor MULTIPART_READ_BUFFER_SIZE = new PropertyDescriptor.Builder().name("multipart-read-buffer-size").displayName("Multipart Read Buffer Size").description("The threshold size, at which the contents of an incoming file would be written to disk. Only applies for requests with Content-Type: multipart/form-data. It is used to prevent denial of service type of attacks, to prevent filling up the heap or disk space.").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("512 KB").build();
    public static final PropertyDescriptor CLIENT_AUTHENTICATION = new PropertyDescriptor.Builder().name("client-authentication").displayName("Client Authentication").description("Client Authentication policy for TLS connections. Required when SSL Context Service configured.").required(false).allowableValues((DescribedValue[])Arrays.stream(ClientAuthentication.values()).map(ClientAuthentication::getAllowableValue).toList().toArray(new AllowableValue[0])).defaultValue(ClientAuthentication.AUTO.name()).dependsOn(SSL_CONTEXT_SERVICE, new AllowableValue[0]).build();
    public static final PropertyDescriptor MAX_THREAD_POOL_SIZE = new PropertyDescriptor.Builder().name("max-thread-pool-size").displayName("Maximum Thread Pool Size").description("The maximum number of threads to be used by the embedded Jetty server. The value can be set between 8 and 1000. The value of this property affects the performance of the flows and the operating system, therefore the default value should only be changed in justified cases. A value that is less than the default value may be suitable if only a small number of HTTP clients connect to the server. A greater value may be suitable if a large number of HTTP clients are expected to make requests to the server simultaneously.").required(true).addValidator(StandardValidators.createLongValidator((long)8L, (long)1000L, (boolean)true)).defaultValue("200").build();
    public static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("The Record Reader to use parsing the incoming FlowFile into Records").required(false).identifiesControllerService(RecordReaderFactory.class).build();
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Writer").description("The Record Writer to use for serializing Records after they have been transformed").required(true).identifiesControllerService(RecordSetWriterFactory.class).dependsOn(RECORD_READER, new AllowableValue[0]).build();
    protected static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BASE_PATH, PORT, HEALTH_CHECK_PORT, SSL_CONTEXT_SERVICE, HTTP_PROTOCOL_STRATEGY, CLIENT_AUTHENTICATION, AUTHORIZED_DN_PATTERN, AUTHORIZED_ISSUER_DN_PATTERN, MAX_UNCONFIRMED_TIME, HEADERS_AS_ATTRIBUTES_REGEX, REQUEST_HEADER_MAX_SIZE, RETURN_CODE, MULTIPART_REQUEST_MAX_SIZE, MULTIPART_READ_BUFFER_SIZE, MAX_THREAD_POOL_SIZE, RECORD_READER, RECORD_WRITER);
    public static final Relationship RELATIONSHIP_SUCCESS = new Relationship.Builder().name("success").description("Relationship for successfully received FlowFiles").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(RELATIONSHIP_SUCCESS);
    public static final String CONTEXT_ATTRIBUTE_PROCESSOR = "processor";
    public static final String CONTEXT_ATTRIBUTE_LOGGER = "logger";
    public static final String CONTEXT_ATTRIBUTE_SESSION_FACTORY_HOLDER = "sessionFactoryHolder";
    public static final String CONTEXT_ATTRIBUTE_PROCESS_CONTEXT_HOLDER = "processContextHolder";
    public static final String CONTEXT_ATTRIBUTE_AUTHORITY_PATTERN = "authorityPattern";
    public static final String CONTEXT_ATTRIBUTE_AUTHORITY_ISSUER_PATTERN = "authorityIssuerPattern";
    public static final String CONTEXT_ATTRIBUTE_HEADER_PATTERN = "headerPattern";
    public static final String CONTEXT_ATTRIBUTE_FLOWFILE_MAP = "flowFileMap";
    public static final String CONTEXT_ATTRIBUTE_BASE_PATH = "basePath";
    public static final String CONTEXT_ATTRIBUTE_RETURN_CODE = "returnCode";
    public static final String CONTEXT_ATTRIBUTE_MULTIPART_REQUEST_MAX_SIZE = "multipartRequestMaxSize";
    public static final String CONTEXT_ATTRIBUTE_MULTIPART_READ_BUFFER_SIZE = "multipartReadBufferSize";
    public static final String CONTEXT_ATTRIBUTE_PORT = "port";
    private volatile Server server = null;
    private final ConcurrentMap<String, FlowFileEntryTimeWrapper> flowFileMap = new ConcurrentHashMap<String, FlowFileEntryTimeWrapper>();
    private final AtomicReference<ProcessSessionFactory> sessionFactoryReference = new AtomicReference();

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        this.validatePortsAreNotEqual(validationContext, validationResults);
        return validationResults;
    }

    private void validatePortsAreNotEqual(ValidationContext context, Collection<ValidationResult> validationResults) {
        Integer port;
        Integer healthCheckPort = context.getProperty(HEALTH_CHECK_PORT).evaluateAttributeExpressions().asInteger();
        if (healthCheckPort != null && (port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger()).equals(healthCheckPort)) {
            String explanation = String.format("'%s' and '%s' cannot have the same value.", PORT.getDisplayName(), HEALTH_CHECK_PORT.getDisplayName());
            validationResults.add(this.createValidationResult(HEALTH_CHECK_PORT.getDisplayName(), explanation));
        }
    }

    private ValidationResult createValidationResult(String subject, String explanation) {
        return new ValidationResult.Builder().subject(subject).valid(false).explanation(explanation).build();
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        if (config.removeProperty("Max Data to Receive per Second")) {
            this.getLogger().warn("ListenHTTP rate limit feature was removed. Please see ListenHTTP documentation for alternatives.");
        }
    }

    @OnShutdown
    @OnStopped
    public void shutdownHttpServer() {
        Server toShutdown = this.server;
        if (toShutdown == null) {
            return;
        }
        this.shutdownHttpServer(toShutdown);
    }

    Server getServer() {
        return this.server;
    }

    private void shutdownHttpServer(Server toShutdown) {
        try {
            toShutdown.stop();
            toShutdown.destroy();
            this.clearInit();
        }
        catch (Exception ex) {
            this.getLogger().warn("unable to cleanly shutdown embedded server", (Throwable)ex);
            this.server = null;
        }
    }

    private synchronized void createHttpServerFromService(ProcessContext context) throws Exception {
        if (this.initialized.get()) {
            return;
        }
        this.runOnPrimary.set(context.getExecutionNode().equals((Object)ExecutionNode.PRIMARY));
        String basePath = context.getProperty(BASE_PATH).evaluateAttributeExpressions().getValue();
        SSLContextProvider sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        int returnCode = context.getProperty(RETURN_CODE).asInteger();
        long requestMaxSize = context.getProperty(MULTIPART_REQUEST_MAX_SIZE).asDataSize(DataUnit.B).longValue();
        int readBufferSize = context.getProperty(MULTIPART_READ_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        int maxThreadPoolSize = context.getProperty(MAX_THREAD_POOL_SIZE).asInteger();
        int requestHeaderSize = context.getProperty(REQUEST_HEADER_MAX_SIZE).asDataSize(DataUnit.B).intValue();
        ClientAuthentication clientAuthentication = this.getClientAuthentication(sslContextProvider, context);
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreadPoolSize);
        threadPool.setName(String.format("%s (%s) Web Server", ((Object)((Object)this)).getClass().getSimpleName(), this.getIdentifier()));
        Server server = new Server((ThreadPool)threadPool);
        int port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
        HttpProtocolStrategy httpProtocolStrategy = sslContextProvider == null ? HttpProtocolStrategy.valueOf(HTTP_PROTOCOL_STRATEGY.getDefaultValue()) : (HttpProtocolStrategy)context.getProperty(HTTP_PROTOCOL_STRATEGY).asAllowableValue(HttpProtocolStrategy.class);
        ServerConnector connector = this.createServerConnector(server, port, requestHeaderSize, sslContextProvider, clientAuthentication, httpProtocolStrategy);
        server.addConnector((Connector)connector);
        Integer healthCheckPort = context.getProperty(HEALTH_CHECK_PORT).evaluateAttributeExpressions().asInteger();
        if (healthCheckPort != null) {
            ServerConnector healthCheckConnector = this.createServerConnector(server, healthCheckPort, requestHeaderSize, sslContextProvider, ClientAuthentication.NONE, httpProtocolStrategy);
            server.addConnector((Connector)healthCheckConnector);
        }
        boolean securityEnabled = sslContextProvider != null;
        ServletContextHandler contextHandler = new ServletContextHandler("/", true, securityEnabled);
        for (Class<? extends Servlet> cls : this.getServerClasses()) {
            Path path = cls.getAnnotation(Path.class);
            if (basePath.isEmpty() && !path.value().isEmpty()) {
                contextHandler.addServlet(cls, path.value());
                continue;
            }
            contextHandler.addServlet(cls, "/" + basePath + path.value());
        }
        contextHandler.addFilter(HttpMethodFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_PROCESSOR, (Object)this);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_LOGGER, (Object)this.getLogger());
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_SESSION_FACTORY_HOLDER, this.sessionFactoryReference);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_PROCESS_CONTEXT_HOLDER, (Object)context);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_FLOWFILE_MAP, this.flowFileMap);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_AUTHORITY_PATTERN, (Object)Pattern.compile(context.getProperty(AUTHORIZED_DN_PATTERN).getValue()));
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_AUTHORITY_ISSUER_PATTERN, (Object)Pattern.compile(context.getProperty(AUTHORIZED_ISSUER_DN_PATTERN).isSet() ? context.getProperty(AUTHORIZED_ISSUER_DN_PATTERN).getValue() : MATCH_ALL));
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_BASE_PATH, (Object)basePath);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_RETURN_CODE, (Object)returnCode);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_MULTIPART_REQUEST_MAX_SIZE, (Object)requestMaxSize);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_MULTIPART_READ_BUFFER_SIZE, (Object)readBufferSize);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_PORT, (Object)port);
        if (context.getProperty(HEADERS_AS_ATTRIBUTES_REGEX).isSet()) {
            contextHandler.setAttribute(CONTEXT_ATTRIBUTE_HEADER_PATTERN, (Object)Pattern.compile(context.getProperty(HEADERS_AS_ATTRIBUTES_REGEX).getValue()));
        }
        server.setHandler((Handler)contextHandler);
        try {
            server.start();
        }
        catch (Exception e) {
            this.shutdownHttpServer(server);
            throw e;
        }
        for (ServletHolder holder : contextHandler.getServletHandler().getServlets()) {
            Servlet servlet = holder.getServlet();
            if (!(servlet instanceof ListenHTTPServlet)) continue;
            ((ListenHTTPServlet)servlet).setPort(connector.getLocalPort());
        }
        this.server = server;
        this.initialized.set(true);
    }

    private ClientAuthentication getClientAuthentication(SSLContextProvider sslContextProvider, ProcessContext context) {
        X509TrustManager trustManager;
        PropertyValue clientAuthenticationProperty;
        ClientAuthentication clientAuthentication = ClientAuthentication.NONE;
        if (sslContextProvider != null && (clientAuthenticationProperty = context.getProperty(CLIENT_AUTHENTICATION)).isSet() && (clientAuthentication = ClientAuthentication.valueOf(clientAuthenticationProperty.getValue())) == ClientAuthentication.AUTO && this.isTrustManagerConfigured(trustManager = sslContextProvider.createTrustManager())) {
            clientAuthentication = ClientAuthentication.REQUIRED;
            this.getLogger().debug("Client Authentication REQUIRED from SSLContextService Trust Manager configuration");
        }
        return clientAuthentication;
    }

    private boolean isTrustManagerConfigured(X509TrustManager configuredTrustManager) {
        boolean trustManagerConfigured = false;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            TrustManager trustManager = trustManagers[0];
            if (trustManager instanceof X509TrustManager) {
                Object[] acceptedIssuers;
                X509TrustManager defaultTrustManager = (X509TrustManager)trustManager;
                Object[] defaultAcceptedIssuers = defaultTrustManager.getAcceptedIssuers();
                trustManagerConfigured = !Arrays.deepEquals(defaultAcceptedIssuers, acceptedIssuers = configuredTrustManager.getAcceptedIssuers());
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Loading default SSLContext for Client Authentication evaluation failed", (Throwable)e);
        }
        return trustManagerConfigured;
    }

    private ServerConnector createServerConnector(Server server, int port, int requestMaxHeaderSize, SSLContextProvider sslContextProvider, ClientAuthentication clientAuthentication, HttpProtocolStrategy httpProtocolStrategy) {
        StandardServerConnectorFactory serverConnectorFactory = new StandardServerConnectorFactory(server, port);
        serverConnectorFactory.setRequestHeaderSize(requestMaxHeaderSize);
        SSLContext sslContext = sslContextProvider == null ? null : sslContextProvider.createContext();
        serverConnectorFactory.setSslContext(sslContext);
        String[] enabledProtocols = sslContext == null ? new String[]{} : sslContext.getDefaultSSLParameters().getProtocols();
        serverConnectorFactory.setIncludeSecurityProtocols(enabledProtocols);
        if (ClientAuthentication.REQUIRED == clientAuthentication) {
            serverConnectorFactory.setNeedClientAuth(true);
        } else if (ClientAuthentication.WANT == clientAuthentication) {
            serverConnectorFactory.setWantClientAuth(true);
        }
        serverConnectorFactory.setApplicationLayerProtocols(httpProtocolStrategy.getApplicationLayerProtocols());
        return serverConnectorFactory.getServerConnector();
    }

    @OnScheduled
    public void clearInit() {
        this.initialized.set(false);
    }

    protected Set<Class<? extends Servlet>> getServerClasses() {
        return Set.of(ListenHTTPServlet.class, ContentAcknowledgmentServlet.class, HealthCheckServlet.class);
    }

    private Set<String> findOldFlowFileIds(ProcessContext ctx) {
        HashSet<String> old = new HashSet<String>();
        long expiryMillis = ctx.getProperty(MAX_UNCONFIRMED_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        long cutoffTime = System.currentTimeMillis() - expiryMillis;
        for (Map.Entry entry : this.flowFileMap.entrySet()) {
            FlowFileEntryTimeWrapper wrapper = (FlowFileEntryTimeWrapper)entry.getValue();
            if (wrapper == null || wrapper.getEntryTime() >= cutoffTime) continue;
            old.add((String)entry.getKey());
        }
        return old;
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        try {
            if (!this.initialized.get()) {
                this.createHttpServerFromService(context);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to start http server during initialization", (Throwable)e);
            context.yield();
            throw new ProcessException("Failed to initialize the server", (Throwable)e);
        }
        this.sessionFactoryReference.compareAndSet(null, sessionFactory);
        for (String id : this.findOldFlowFileIds(context)) {
            FlowFileEntryTimeWrapper wrapper = (FlowFileEntryTimeWrapper)this.flowFileMap.remove(id);
            if (wrapper == null) continue;
            this.getLogger().warn("failed to receive acknowledgment for HOLD with ID {} sent by {}; rolling back session", new Object[]{id, wrapper.getClientIP()});
            wrapper.session.rollback();
        }
        context.yield();
    }

    @OnPrimaryNodeStateChange
    public void onPrimaryNodeChange(PrimaryNodeState newState) {
        if (this.runOnPrimary.get() && newState.equals((Object)PrimaryNodeState.PRIMARY_NODE_REVOKED)) {
            try {
                this.shutdownHttpServer();
            }
            catch (Exception shutdownException) {
                this.getLogger().warn("Processor is configured to run only on Primary Node, but failed to shutdown HTTP server following revocation of primary node status due to {}", (Throwable)shutdownException);
            }
        }
    }

    public static enum ClientAuthentication {
        AUTO("Inferred based on SSL Context Service properties. The presence of Trust Store properties implies REQUIRED, otherwise NONE is configured."),
        WANT(ClientAuth.WANT.getDescription()),
        REQUIRED(ClientAuth.REQUIRED.getDescription()),
        NONE(ClientAuth.NONE.getDescription());

        private final String description;

        private ClientAuthentication(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public AllowableValue getAllowableValue() {
            return new AllowableValue(this.name(), this.name(), this.description);
        }
    }

    public static class FlowFileEntryTimeWrapper {
        private final Set<FlowFile> flowFiles;
        private final long entryTime;
        private final ProcessSession session;
        private final String clientIP;

        public FlowFileEntryTimeWrapper(ProcessSession session, Set<FlowFile> flowFiles, long entryTime, String clientIP) {
            this.flowFiles = flowFiles;
            this.entryTime = entryTime;
            this.session = session;
            this.clientIP = clientIP;
        }

        public Set<FlowFile> getFlowFiles() {
            return this.flowFiles;
        }

        public long getEntryTime() {
            return this.entryTime;
        }

        public ProcessSession getSession() {
            return this.session;
        }

        public String getClientIP() {
            return this.clientIP;
        }
    }
}

