/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"compression", "gzip", "bzip2", "zip", "MIME", "mime.type", "file", "identify"})
@CapabilityDescription(value="Attempts to identify the MIME Type used for a FlowFile. If the MIME Type can be identified, an attribute with the name 'mime.type' is added with the value being the MIME Type. If the MIME Type cannot be determined, the value will be set to 'application/octet-stream'. In addition, the attribute 'mime.extension' will be set if a common file extension for the MIME Type is known. If the MIME Type detected is of type text/*, attempts to identify the charset used and an attribute with the name 'mime.charset' is added with the value being the charset.")
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="This Processor sets the FlowFile's mime.type attribute to the detected MIME Type. If unable to detect the MIME Type, the attribute's value will be set to application/octet-stream"), @WritesAttribute(attribute="mime.extension", description="This Processor sets the FlowFile's mime.extension attribute to the file extension associated with the detected MIME Type. If there is no correlated extension, the attribute's value will be empty"), @WritesAttribute(attribute="mime.charset", description="This Processor sets the FlowFile's mime.charset attribute to the detected charset. If unable to detect the charset or the detected MIME type is not of type text/*, the attribute will not be set")})
public class IdentifyMimeType
extends AbstractProcessor {
    static final AllowableValue PRESET = new AllowableValue("Preset", "Preset", "Use default NiFi MIME Types.");
    static final AllowableValue REPLACE = new AllowableValue("Replace", "Replace", "Use custom MIME types configuration only.");
    static final AllowableValue MERGE = new AllowableValue("Merge", "Merge", "Use custom MIME types configuration together with default NiFi MIME types.");
    public static final PropertyDescriptor USE_FILENAME_IN_DETECTION = new PropertyDescriptor.Builder().displayName("Use Filename In Detection").name("use-filename-in-detection").description("If true will pass the filename to Tika to aid in detection.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor CONFIG_STRATEGY = new PropertyDescriptor.Builder().displayName("Config Strategy").name("config-strategy").description("Select the loading strategy for MIME Type configuration to be used.").required(true).allowableValues(new DescribedValue[]{PRESET, REPLACE, MERGE}).defaultValue(PRESET.getValue()).build();
    public static final PropertyDescriptor CUSTOM_MIME_CONFIGURATION = new PropertyDescriptor.Builder().name("Custom MIME Configuration").description("A URL or file path to a custom Tika Mime type configuration or the actual content of a custom Tika Mime type configuration.").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.URL, ResourceType.TEXT}).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(CONFIG_STRATEGY, new AllowableValue[]{REPLACE, MERGE}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(USE_FILENAME_IN_DETECTION, CONFIG_STRATEGY, CUSTOM_MIME_CONFIGURATION);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are routed to success").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);
    private static final String CUSTOM_MIME_TYPES_FILENAME = "custom-mimetypes.xml";
    private static final String DEFAULT_MIME_TYPES_PATH = "org/apache/tika/mime/tika-mimetypes.xml";
    private final TikaConfig config = TikaConfig.getDefaultConfig();
    private Detector detector;
    private EncodingDetector encodingDetector;
    private MimeTypes mimeTypes;

    public void migrateProperties(PropertyConfiguration config) {
        String configFileProperty = "config-file";
        String configBodyProperty = "config-body";
        if (!config.hasProperty(CONFIG_STRATEGY) && (config.isPropertySet("config-file") || config.isPropertySet("config-body"))) {
            config.setProperty(CONFIG_STRATEGY, REPLACE.getValue());
        }
        if (config.isPropertySet("config-file")) {
            config.setProperty(CUSTOM_MIME_CONFIGURATION.getName(), config.getRawPropertyValue("config-file").orElse(""));
        } else if (config.isPropertySet("config-body")) {
            config.setProperty(CUSTOM_MIME_CONFIGURATION.getName(), config.getRawPropertyValue("config-body").orElse(""));
        }
        config.removeProperty("config-file");
        config.removeProperty("config-body");
    }

    @OnScheduled
    public void setup(ProcessContext context) throws IOException {
        String configStrategy = context.getProperty(CONFIG_STRATEGY).getValue();
        if (configStrategy.equals(PRESET.getValue())) {
            this.detector = this.config.getDetector();
            this.mimeTypes = this.config.getMimeRepository();
        } else {
            try {
                this.detector = this.createCustomMimeTypes(configStrategy, (PropertyContext)context);
                this.mimeTypes = (MimeTypes)this.detector;
            }
            catch (Exception e) {
                context.yield();
                throw new ProcessException("Failed to load configuration", (Throwable)e);
            }
        }
        this.encodingDetector = this.config.getEncodingDetector();
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        Charset charset;
        String extension;
        String mediaTypeString;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        try (InputStream flowFileStream = session.read(flowFile);
             TikaInputStream tikaStream = TikaInputStream.get((InputStream)flowFileStream);){
            String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
            Metadata metadata = new Metadata();
            if (filename != null && context.getProperty(USE_FILENAME_IN_DETECTION).asBoolean().booleanValue()) {
                metadata.add("resourceName", filename);
            }
            MediaType mediaType = this.detector.detect((InputStream)tikaStream, metadata);
            mediaTypeString = mediaType.getBaseType().toString();
            extension = this.lookupExtension(mediaTypeString, logger);
            charset = this.identifyCharset(tikaStream, metadata, mediaType);
        }
        catch (IOException e) {
            throw new ProcessException("Failed to identify MIME type from content stream", (Throwable)e);
        }
        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), mediaTypeString);
        flowFile = session.putAttribute(flowFile, "mime.extension", extension);
        if (charset != null) {
            flowFile = session.putAttribute(flowFile, "mime.charset", charset.name());
        }
        logger.info("Identified {} as having MIME Type {}", new Object[]{flowFile, mediaTypeString});
        session.getProvenanceReporter().modifyAttributes(flowFile);
        session.transfer(flowFile, REL_SUCCESS);
    }

    private String lookupExtension(String mediaTypeString, ComponentLog logger) {
        String extension = "";
        try {
            MimeType mimeType = this.mimeTypes.forName(mediaTypeString);
            extension = mimeType.getExtension();
        }
        catch (MimeTypeException e) {
            logger.warn("MIME type extension lookup failed", (Throwable)e);
        }
        if (mediaTypeString.equals("application/gzip") && extension.equals(".tgz")) {
            extension = ".gz";
        }
        return extension;
    }

    private Charset identifyCharset(TikaInputStream tikaStream, Metadata metadata, MediaType mediaType) throws IOException {
        if (mediaType.getType().equals("text")) {
            metadata.add("Content-Type", mediaType.toString());
            return this.encodingDetector.detect((InputStream)tikaStream, metadata);
        }
        return null;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        String configStrategy = validationContext.getProperty(CONFIG_STRATEGY).getValue();
        if (!configStrategy.equals(PRESET.getValue())) {
            try {
                this.createCustomMimeTypes(configStrategy, (PropertyContext)validationContext);
            }
            catch (Exception e) {
                results.add(new ValidationResult.Builder().subject(CUSTOM_MIME_CONFIGURATION.getDisplayName()).input(validationContext.getProperty(CUSTOM_MIME_CONFIGURATION).getValue()).valid(false).explanation("Invalid configuration " + ExceptionUtils.getRootCauseMessage((Throwable)e)).build());
            }
        }
        return results;
    }

    /*
     * Exception decompiling
     */
    private MimeTypes createCustomMimeTypes(String configStrategy, PropertyContext context) throws MimeTypeException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

