/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ssl;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.ssl.PEMEncodedSSLContextProvider;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.StandardSSLContextService;

@DeprecationNotice(reason="No longer provides differentiated security features", alternatives={PEMEncodedSSLContextProvider.class, StandardSSLContextService.class})
@Tags(value={"tls", "ssl", "secure", "certificate", "keystore", "truststore", "jks", "p12", "pkcs12", "pkcs"})
@CapabilityDescription(value="Restricted implementation of the SSLContextService. Provides the ability to configure keystore and/or truststore properties once and reuse that configuration throughout the application, but only allows a restricted set of TLS/SSL protocols to be chosen (no SSL protocols are supported). The set of protocols selectable will evolve over time as new protocols emerge and older protocols are deprecated. This service is recommended over StandardSSLContextService if a component doesn't expect to communicate with legacy systems since it is unlikely that legacy systems will support these protocols.")
public class StandardRestrictedSSLContextService
extends StandardSSLContextService
implements RestrictedSSLContextService {
    public static final PropertyDescriptor RESTRICTED_SSL_ALGORITHM = new PropertyDescriptor.Builder().name("TLS Protocol").defaultValue("TLS").required(false).allowableValues((DescribedValue[])StandardRestrictedSSLContextService.getRestrictedProtocolAllowableValues()).description("TLS Protocol Version for encrypted connections. Supported versions depend on the specific version of Java used.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(KEYSTORE, KEYSTORE_PASSWORD, KEY_PASSWORD, KEYSTORE_TYPE, TRUSTSTORE, TRUSTSTORE_PASSWORD, TRUSTSTORE_TYPE, RESTRICTED_SSL_ALGORITHM);

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public String getSslAlgorithm() {
        return this.configContext.getProperty(RESTRICTED_SSL_ALGORITHM).getValue();
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("SSL Protocol", RESTRICTED_SSL_ALGORITHM.getName());
    }

    private static AllowableValue[] getRestrictedProtocolAllowableValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(new AllowableValue("TLS", "TLS", "Negotiate latest protocol version based on platform supported versions"));
        for (String preferredProtocol : TlsPlatform.getPreferredProtocols()) {
            String description = String.format("Require %s protocol version", preferredProtocol);
            allowableValues.add(new AllowableValue(preferredProtocol, preferredProtocol, description));
        }
        return allowableValues.toArray(new AllowableValue[allowableValues.size()]);
    }
}

