/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.datasources.GroupStatusCache;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.IterableRowStream;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class ProcessorStatusDataSource
implements ResettableDataSource {
    private static final NiFiTableSchema SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("id", String.class, false), new ColumnSchema("groupId", String.class, false), new ColumnSchema("name", String.class, false), new ColumnSchema("processorType", String.class, false), new ColumnSchema("averageLineageDuration", Long.TYPE, false), new ColumnSchema("bytesRead", Long.TYPE, false), new ColumnSchema("bytesWritten", Long.TYPE, false), new ColumnSchema("bytesReceived", Long.TYPE, false), new ColumnSchema("bytesSent", Long.TYPE, false), new ColumnSchema("flowFilesRemoved", Integer.TYPE, false), new ColumnSchema("flowFilesReceived", Integer.TYPE, false), new ColumnSchema("flowFilesSent", Integer.TYPE, false), new ColumnSchema("inputCount", Integer.TYPE, false), new ColumnSchema("inputBytes", Long.TYPE, false), new ColumnSchema("outputCount", Integer.TYPE, false), new ColumnSchema("outputBytes", Long.TYPE, false), new ColumnSchema("activeThreadCount", Integer.TYPE, false), new ColumnSchema("terminatedThreadCount", Integer.TYPE, false), new ColumnSchema("invocations", Integer.TYPE, false), new ColumnSchema("processingNanos", Long.TYPE, false), new ColumnSchema("runStatus", String.class, false), new ColumnSchema("executionNode", String.class, false), new ColumnSchema("cpuDuration", Long.TYPE, false), new ColumnSchema("contentReadDuration", Long.TYPE, false), new ColumnSchema("contentWriteDuration", Long.TYPE, false), new ColumnSchema("sessionCommitDuration", Long.TYPE, false), new ColumnSchema("garbageCollectionDuration", Long.TYPE, false)));
    private final ReportingContext reportingContext;
    private final GroupStatusCache groupStatusCache;
    private ProcessGroupStatus lastFetchedStatus = null;
    private List<ProcessorStatus> lastStatuses = null;

    public ProcessorStatusDataSource(ReportingContext reportingContext, GroupStatusCache groupStatusCache) {
        this.reportingContext = reportingContext;
        this.groupStatusCache = groupStatusCache;
    }

    public NiFiTableSchema getSchema() {
        return SCHEMA;
    }

    public RowStream reset() {
        ProcessGroupStatus groupStatus = this.groupStatusCache.getGroupStatus(this.reportingContext);
        List<ProcessorStatus> processorStatuses = groupStatus == this.lastFetchedStatus ? this.lastStatuses : (this.lastStatuses = this.gatherProcessorStatuses(groupStatus));
        this.lastFetchedStatus = groupStatus;
        return new IterableRowStream(processorStatuses, this::toArray);
    }

    private List<ProcessorStatus> gatherProcessorStatuses(ProcessGroupStatus groupStatus) {
        ArrayList<ProcessorStatus> allStatuses = new ArrayList<ProcessorStatus>();
        this.gatherProcessorStatuses(groupStatus, allStatuses);
        return allStatuses;
    }

    private void gatherProcessorStatuses(ProcessGroupStatus groupStatus, List<ProcessorStatus> processorStatuses) {
        processorStatuses.addAll(groupStatus.getProcessorStatus());
        for (ProcessGroupStatus childStatus : groupStatus.getProcessGroupStatus()) {
            this.gatherProcessorStatuses(childStatus, processorStatuses);
        }
    }

    private Object[] toArray(ProcessorStatus status) {
        return new Object[]{status.getId(), status.getGroupId(), status.getName(), status.getType(), status.getAverageLineageDuration(TimeUnit.MILLISECONDS), status.getBytesRead(), status.getBytesWritten(), status.getBytesReceived(), status.getBytesSent(), status.getFlowFilesRemoved(), status.getFlowFilesReceived(), status.getFlowFilesSent(), status.getInputCount(), status.getInputBytes(), status.getOutputCount(), status.getOutputBytes(), status.getActiveThreadCount(), status.getTerminatedThreadCount(), status.getInvocations(), status.getProcessingNanos(), status.getRunStatus().name(), status.getExecutionNode() == null ? null : status.getExecutionNode().name(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getCpuDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getContentReadDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getContentWriteDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getSessionCommitDuration(), status.getProcessingPerformanceStatus() == null ? -1L : status.getProcessingPerformanceStatus().getGarbageCollectionDuration()};
    }
}

