/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.util.List;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConfigureDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.action.details.PurgeDetails;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.IterableRowStream;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class FlowConfigHistoryDataSource
implements ResettableDataSource {
    public static final NiFiTableSchema SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("actionId", Integer.TYPE, false), new ColumnSchema("actionTimestamp", Long.TYPE, false), new ColumnSchema("actionUserIdentity", String.class, false), new ColumnSchema("actionSourceId", String.class, false), new ColumnSchema("actionSourceName", String.class, false), new ColumnSchema("actionSourceType", String.class, false), new ColumnSchema("actionOperation", String.class, false), new ColumnSchema("configureDetailsName", String.class, false), new ColumnSchema("configureDetailsPreviousValue", String.class, false), new ColumnSchema("configureDetailsValue", String.class, false), new ColumnSchema("connectionSourceId", String.class, false), new ColumnSchema("connectionSourceName", String.class, false), new ColumnSchema("connectionSourceType", String.class, false), new ColumnSchema("connectionDestinationId", String.class, false), new ColumnSchema("connectionDestinationName", String.class, false), new ColumnSchema("connectionDestinationType", String.class, false), new ColumnSchema("connectionRelationship", String.class, false), new ColumnSchema("moveGroup", String.class, false), new ColumnSchema("moveGroupId", String.class, false), new ColumnSchema("movePreviousGroup", String.class, false), new ColumnSchema("movePreviousGroupId", String.class, false), new ColumnSchema("purgeEndDate", Long.TYPE, false)));
    private final ReportingContext reportingContext;

    public FlowConfigHistoryDataSource(ReportingContext reportingContext) {
        this.reportingContext = reportingContext;
    }

    public NiFiTableSchema getSchema() {
        return SCHEMA;
    }

    public RowStream reset() {
        List fullFlowConfigHistoryList = this.reportingContext.getEventAccess().getFlowChanges(0, Short.MAX_VALUE);
        return new IterableRowStream((Iterable)fullFlowConfigHistoryList, this::toArray);
    }

    private Object[] toArray(Action action) {
        ActionDetails details = action.getActionDetails();
        return new Object[]{action.getId(), action.getTimestamp().getTime(), action.getUserIdentity(), action.getSourceId(), action.getSourceName(), action.getSourceType(), action.getOperation().toString(), details instanceof ConfigureDetails ? ((ConfigureDetails)details).getName() : null, details instanceof ConfigureDetails ? ((ConfigureDetails)details).getPreviousValue() : null, details instanceof ConfigureDetails ? ((ConfigureDetails)details).getValue() : null, details instanceof ConnectDetails ? ((ConnectDetails)details).getSourceId() : null, details instanceof ConnectDetails ? ((ConnectDetails)details).getSourceName() : null, details instanceof ConnectDetails ? ((ConnectDetails)details).getSourceType() : null, details instanceof ConnectDetails ? ((ConnectDetails)details).getDestinationId() : null, details instanceof ConnectDetails ? ((ConnectDetails)details).getDestinationName() : null, details instanceof ConnectDetails ? ((ConnectDetails)details).getDestinationType() : null, details instanceof ConnectDetails ? ((ConnectDetails)details).getRelationship() : null, details instanceof MoveDetails ? ((MoveDetails)details).getGroup() : null, details instanceof MoveDetails ? ((MoveDetails)details).getGroupId() : null, details instanceof MoveDetails ? ((MoveDetails)details).getPreviousGroup() : null, details instanceof MoveDetails ? ((MoveDetails)details).getPreviousGroupId() : null, details instanceof PurgeDetails ? Long.valueOf(((PurgeDetails)details).getEndDate().getTime()) : null};
    }
}

