/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.util.TrackedQueryTime;

public interface QueryTimeAware {
    default public String processStartAndEndTimes(ReportingContext context, String sql, TrackedQueryTime queryStartTime, TrackedQueryTime queryEndTime) throws IOException {
        StateManager stateManager = context.getStateManager();
        HashMap<String, String> stateMap = new HashMap<String, String>(stateManager.getState(Scope.LOCAL).toMap());
        if (sql.contains(queryStartTime.getSqlPlaceholder()) && sql.contains(queryEndTime.getSqlPlaceholder())) {
            long startTime = stateMap.get(queryStartTime.name()) == null ? 0L : Long.parseLong((String)stateMap.get(queryStartTime.name()));
            long currentTime = this.getCurrentTime();
            sql = sql.replace(queryStartTime.getSqlPlaceholder(), String.valueOf(startTime));
            sql = sql.replace(queryEndTime.getSqlPlaceholder(), String.valueOf(currentTime));
            stateMap.put(queryStartTime.name(), String.valueOf(currentTime));
            stateManager.setState(stateMap, Scope.LOCAL);
        }
        return sql;
    }

    default public long getCurrentTime() {
        return Instant.now().toEpochMilli();
    }
}

