/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.time.Duration;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.reporting.ReportingContext;

public class GroupStatusCache {
    private final long refreshMillis;
    private long nextRefreshTime;
    private ProcessGroupStatus cached;

    public GroupStatusCache(Duration refreshFrequency) {
        this.refreshMillis = refreshFrequency.toMillis();
        this.nextRefreshTime = 0L;
    }

    public synchronized ProcessGroupStatus getGroupStatus(ReportingContext context) {
        if (this.cached == null || System.currentTimeMillis() > this.nextRefreshTime) {
            ProcessGroupStatus retrieved;
            this.cached = retrieved = context.getEventAccess().getControllerStatus();
            long now = System.currentTimeMillis();
            this.nextRefreshTime = now + this.refreshMillis;
            return retrieved;
        }
        return this.cached;
    }
}

