/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.util.List;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.IterableRowStream;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class BulletinDataSource
implements ResettableDataSource {
    private static final NiFiTableSchema SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("bulletinId", Long.TYPE, false), new ColumnSchema("bulletinCategory", String.class, false), new ColumnSchema("bulletinGroupId", String.class, true), new ColumnSchema("bulletinGroupName", String.class, true), new ColumnSchema("bulletinGroupPath", String.class, true), new ColumnSchema("bulletinLevel", String.class, false), new ColumnSchema("bulletinMessage", String.class, false), new ColumnSchema("bulletinNodeAddress", String.class, true), new ColumnSchema("bulletinNodeId", String.class, true), new ColumnSchema("bulletinSourceId", String.class, true), new ColumnSchema("bulletinSourceName", String.class, true), new ColumnSchema("bulletinSourceType", String.class, true), new ColumnSchema("bulletinTimestamp", Long.TYPE, false), new ColumnSchema("bulletinFlowFileUuid", String.class, true)));
    private final ReportingContext reportingContext;

    public BulletinDataSource(ReportingContext reportingContext) {
        this.reportingContext = reportingContext;
    }

    public NiFiTableSchema getSchema() {
        return SCHEMA;
    }

    public RowStream reset() {
        String clusterNodeId;
        boolean isClustered = this.reportingContext.isClustered();
        String nodeId = "unknown";
        if (isClustered && (clusterNodeId = this.reportingContext.getClusterNodeIdentifier()) != null) {
            nodeId = clusterNodeId;
        }
        String resolvedNodeId = nodeId;
        BulletinRepository bulletinRepo = this.reportingContext.getBulletinRepository();
        List bulletins = bulletinRepo.findBulletins(new BulletinQuery.Builder().build());
        return new IterableRowStream((Iterable)bulletins, bulletin -> this.toArray((Bulletin)bulletin, resolvedNodeId));
    }

    private Object[] toArray(Bulletin bulletin, String nodeId) {
        return new Object[]{bulletin.getId(), bulletin.getCategory(), bulletin.getGroupId(), bulletin.getGroupName(), bulletin.getGroupPath(), bulletin.getLevel(), bulletin.getMessage(), bulletin.getNodeAddress(), nodeId, bulletin.getSourceId(), bulletin.getSourceName(), bulletin.getSourceType() == null ? null : bulletin.getSourceType().name(), bulletin.getTimestamp() == null ? null : Long.valueOf(bulletin.getTimestamp().getTime()), bulletin.getFlowFileUuid()};
    }
}

