/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.bulletins;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Pair;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.bulletins.BulletinEnumerator;
import org.apache.nifi.reporting.sql.bulletins.BulletinTableScan;

public class BulletinTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final ComponentLog logger;
    private RelDataType relDataType = null;
    private volatile ReportingContext context;
    private volatile int maxRecordsRead;
    private final Set<BulletinEnumerator> enumerators = new HashSet<BulletinEnumerator>();

    public BulletinTable(ReportingContext context, ComponentLog logger) {
        this.context = context;
        this.logger = logger;
    }

    public String toString() {
        return "BulletinTable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<BulletinEnumerator> set = this.enumerators;
        synchronized (set) {
            for (BulletinEnumerator enumerator : this.enumerators) {
                enumerator.close();
            }
        }
    }

    public Enumerable<Object> project(final int[] fields) {
        return new AbstractEnumerable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Enumerator<Object> enumerator() {
                BulletinEnumerator bulletinEnumerator = new BulletinEnumerator(BulletinTable.this.context, BulletinTable.this.logger, fields){

                    @Override
                    protected void onFinish() {
                        int recordCount = this.getRecordsRead();
                        if (recordCount > BulletinTable.this.maxRecordsRead) {
                            BulletinTable.this.maxRecordsRead = recordCount;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        Set set = BulletinTable.this.enumerators;
                        synchronized (set) {
                            BulletinTable.this.enumerators.remove(this);
                        }
                        super.close();
                    }
                };
                Set set = BulletinTable.this.enumerators;
                synchronized (set) {
                    BulletinTable.this.enumerators.add(bulletinEnumerator);
                }
                return bulletinEnumerator;
            }
        };
    }

    public int getRecordsRead() {
        return this.maxRecordsRead;
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = i;
        }
        return new BulletinTableScan(context.getCluster(), relOptTable, this, fields);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.relDataType != null) {
            return this.relDataType;
        }
        List<String> names = Arrays.asList("bulletinId", "bulletinCategory", "bulletinGroupId", "bulletinGroupName", "bulletinGroupPath", "bulletinLevel", "bulletinMessage", "bulletinNodeAddress", "bulletinNodeId", "bulletinSourceId", "bulletinSourceName", "bulletinSourceType", "bulletinTimestamp");
        List<RelDataType> types = Arrays.asList(typeFactory.createJavaType(Long.TYPE), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(Date.class));
        this.relDataType = typeFactory.createStructType(Pair.zip(names, types));
        return this.relDataType;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TEMPORARY_TABLE;
    }
}

