/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.record.sink.RecordSinkService;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.sql.MetricsQueryService;
import org.apache.nifi.reporting.sql.MetricsSqlQueryService;
import org.apache.nifi.reporting.sql.QueryResult;
import org.apache.nifi.reporting.sql.util.QueryMetricsUtil;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.ResultSetRecordSet;
import org.apache.nifi.util.StopWatch;

@Tags(value={"status", "connection", "processor", "jvm", "metrics", "history", "bulletin", "prediction", "process", "group", "provenance", "record", "sql"})
@CapabilityDescription(value="Publishes NiFi status information based on the results of a user-specified SQL query. The query may make use of the CONNECTION_STATUS, PROCESSOR_STATUS, BULLETINS, PROCESS_GROUP_STATUS, JVM_METRICS, CONNECTION_STATUS_PREDICTIONS, or PROVENANCE tables, and can use any functions or capabilities provided by Apache Calcite. Note that the CONNECTION_STATUS_PREDICTIONS table is not available for querying if analytics are not enabled (see the nifi.analytics.predict.enabled property in nifi.properties). Attempting a query on the table when the capability is disabled will cause an error.")
public class QueryNiFiReportingTask
extends AbstractReportingTask {
    private List<PropertyDescriptor> properties;
    private volatile RecordSinkService recordSinkService;
    private MetricsQueryService metricsQueryService;

    protected void init(ReportingInitializationContext config) {
        this.metricsQueryService = new MetricsSqlQueryService(this.getLogger());
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(QueryMetricsUtil.QUERY);
        properties.add(QueryMetricsUtil.RECORD_SINK);
        properties.add(QueryMetricsUtil.INCLUDE_ZERO_RECORD_RESULTS);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnScheduled
    public void setup(ConfigurationContext context) throws IOException {
        this.recordSinkService = (RecordSinkService)context.getProperty(QueryMetricsUtil.RECORD_SINK).asControllerService(RecordSinkService.class);
        this.recordSinkService.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ReportingContext context) {
        StopWatch stopWatch = new StopWatch(true);
        try {
            ResultSetRecordSet recordSet;
            String sql = context.getProperty(QueryMetricsUtil.QUERY).evaluateAttributeExpressions().getValue();
            QueryResult queryResult = this.metricsQueryService.query(context, sql);
            try {
                this.getLogger().debug("Executing query: {}", new Object[]{sql});
                recordSet = this.metricsQueryService.getResultSetRecordSet(queryResult);
            }
            catch (Exception e) {
                this.getLogger().error("Error creating record set from query results due to {}", new Object[]{e.getMessage()}, (Throwable)e);
                return;
            }
            try {
                HashMap<String, String> attributes = new HashMap<String, String>();
                String transactionId = UUID.randomUUID().toString();
                attributes.put("reporting.task.transaction.id", transactionId);
                attributes.put("reporting.task.name", this.getName());
                attributes.put("reporting.task.uuid", this.getIdentifier());
                attributes.put("reporting.task.type", ((Object)((Object)this)).getClass().getSimpleName());
                this.recordSinkService.sendData((RecordSet)recordSet, attributes, context.getProperty(QueryMetricsUtil.INCLUDE_ZERO_RECORD_RESULTS).asBoolean().booleanValue());
            }
            catch (Exception e) {
                try {
                    this.getLogger().error("Error during transmission of query results due to {}", new Object[]{e.getMessage()}, (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.metricsQueryService.closeQuietly(queryResult);
                    throw throwable;
                }
                this.metricsQueryService.closeQuietly(queryResult);
                return;
            }
            this.metricsQueryService.closeQuietly(queryResult);
            long elapsedMillis = stopWatch.getElapsed(TimeUnit.MILLISECONDS);
            this.getLogger().debug("Successfully queried and sent in {} millis", new Object[]{elapsedMillis});
        }
        catch (Exception e) {
            this.getLogger().error("Error processing the query due to {}", new Object[]{e.getMessage()}, (Throwable)e);
        }
    }
}

