/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.splunk;

import com.splunk.HttpException;
import com.splunk.JobExportArgs;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.ssl.SSLContextProvider;

@TriggerSerially
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"get", "splunk", "logs"})
@CapabilityDescription(value="Retrieves data from Splunk Enterprise.")
@WritesAttributes(value={@WritesAttribute(attribute="splunk.query", description="The query that performed to produce the FlowFile."), @WritesAttribute(attribute="splunk.earliest.time", description="The value of the earliest time that was used when performing the query."), @WritesAttribute(attribute="splunk.latest.time", description="The value of the latest time that was used when performing the query.")})
@RequiresInstanceClassLoading(cloneAncestorResources=true)
@Stateful(scopes={Scope.CLUSTER}, description="If using one of the managed Time Range Strategies, this processor will store the values of the latest and earliest times from the previous execution so that the next execution of the can pick up where the last execution left off. The state will be cleared and start over if the query is changed.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class GetSplunk
extends AbstractProcessor
implements ClassloaderIsolationKeyProvider {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final PropertyDescriptor SCHEME = new PropertyDescriptor.Builder().name("Scheme").description("The scheme for connecting to Splunk.").allowableValues(new String[]{"https", "http"}).defaultValue("https").required(true).build();
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The ip address or hostname of the Splunk server.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("localhost").required(true).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port of the Splunk server.").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("8089").build();
    public static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("Max wait time for connection to the Splunk server.").required(false).defaultValue("5 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").description("Max wait time for response from the Splunk server.").required(false).defaultValue("15 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("Query").description("The query to execute. Typically beginning with a <search> command followed by a search clause, such as <search source=\"tcp:7689\"> to search for messages received on TCP port 7689.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("search * | head 100").required(true).build();
    public static final AllowableValue EVENT_TIME_VALUE = new AllowableValue("Event Time", "Event Time", "Search based on the time of the event which may be different than when the event was indexed.");
    public static final AllowableValue INDEX_TIME_VALUE = new AllowableValue("Index Time", "Index Time", "Search based on the time the event was indexed in Splunk.");
    public static final PropertyDescriptor TIME_FIELD_STRATEGY = new PropertyDescriptor.Builder().name("Time Field Strategy").description("Indicates whether to search by the time attached to the event, or by the time the event was indexed in Splunk.").allowableValues(new DescribedValue[]{EVENT_TIME_VALUE, INDEX_TIME_VALUE}).defaultValue(EVENT_TIME_VALUE.getValue()).required(true).build();
    public static final AllowableValue MANAGED_BEGINNING_VALUE = new AllowableValue("Managed from Beginning", "Managed from Beginning", "The processor will manage the date ranges of the query starting from the beginning of time.");
    public static final AllowableValue MANAGED_CURRENT_VALUE = new AllowableValue("Managed from Current", "Managed from Current", "The processor will manage the date ranges of the query starting from the current time.");
    public static final AllowableValue PROVIDED_VALUE = new AllowableValue("Provided", "Provided", "The the time range provided through the Earliest Time and Latest Time properties will be used.");
    public static final PropertyDescriptor TIME_RANGE_STRATEGY = new PropertyDescriptor.Builder().name("Time Range Strategy").description("Indicates how to apply time ranges to each execution of the query. Selecting a managed option allows the processor to apply a time range from the last execution time to the current execution time. When using <Managed from Beginning>, an earliest time will not be applied on the first execution, and thus all records searched. When using <Managed from Current> the earliest time of the first execution will be the initial execution time. When using <Provided>, the time range will come from the Earliest Time and Latest Time properties, or no time range will be applied if these properties are left blank.").allowableValues(new DescribedValue[]{MANAGED_BEGINNING_VALUE, MANAGED_CURRENT_VALUE, PROVIDED_VALUE}).defaultValue(PROVIDED_VALUE.getValue()).required(true).build();
    public static final PropertyDescriptor EARLIEST_TIME = new PropertyDescriptor.Builder().name("Earliest Time").description("The value to use for the earliest time when querying. Only used with a Time Range Strategy of Provided. See Splunk's documentation on Search Time Modifiers for guidance in populating this field.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor LATEST_TIME = new PropertyDescriptor.Builder().name("Latest Time").description("The value to use for the latest time when querying. Only used with a Time Range Strategy of Provided. See Splunk's documentation on Search Time Modifiers for guidance in populating this field.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor TIME_ZONE = new PropertyDescriptor.Builder().name("Time Zone").description("The Time Zone to use for formatting dates when performing a search. Only used with Managed time strategies.").allowableValues(TimeZone.getAvailableIDs()).defaultValue("UTC").required(true).build();
    public static final PropertyDescriptor APP = new PropertyDescriptor.Builder().name("Application").description("The Splunk Application to query.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor OWNER = new PropertyDescriptor.Builder().name("Owner").description("The owner to pass to Splunk.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor TOKEN = new PropertyDescriptor.Builder().name("Token").description("The token to pass to Splunk.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("The username to authenticate to Splunk.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password to authenticate to Splunk.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).sensitive(true).build();
    public static final AllowableValue ATOM_VALUE = new AllowableValue(JobExportArgs.OutputMode.ATOM.name(), JobExportArgs.OutputMode.ATOM.name());
    public static final AllowableValue CSV_VALUE = new AllowableValue(JobExportArgs.OutputMode.CSV.name(), JobExportArgs.OutputMode.CSV.name());
    public static final AllowableValue JSON_VALUE = new AllowableValue(JobExportArgs.OutputMode.JSON.name(), JobExportArgs.OutputMode.JSON.name());
    public static final AllowableValue JSON_COLS_VALUE = new AllowableValue(JobExportArgs.OutputMode.JSON_COLS.name(), JobExportArgs.OutputMode.JSON_COLS.name());
    public static final AllowableValue JSON_ROWS_VALUE = new AllowableValue(JobExportArgs.OutputMode.JSON_ROWS.name(), JobExportArgs.OutputMode.JSON_ROWS.name());
    public static final AllowableValue RAW_VALUE = new AllowableValue(JobExportArgs.OutputMode.RAW.name(), JobExportArgs.OutputMode.RAW.name());
    public static final AllowableValue XML_VALUE = new AllowableValue(JobExportArgs.OutputMode.XML.name(), JobExportArgs.OutputMode.XML.name());
    public static final PropertyDescriptor OUTPUT_MODE = new PropertyDescriptor.Builder().name("Output Mode").description("The output mode for the results.").allowableValues(new DescribedValue[]{ATOM_VALUE, CSV_VALUE, JSON_VALUE, JSON_COLS_VALUE, JSON_ROWS_VALUE, RAW_VALUE, XML_VALUE}).defaultValue(JSON_VALUE.getValue()).required(true).build();
    public static final AllowableValue TLS_1_2_VALUE = new AllowableValue(SSLSecurityProtocol.TLSv1_2.name(), SSLSecurityProtocol.TLSv1_2.name());
    public static final AllowableValue TLS_1_1_VALUE = new AllowableValue(SSLSecurityProtocol.TLSv1_1.name(), SSLSecurityProtocol.TLSv1_1.name());
    public static final AllowableValue TLS_1_VALUE = new AllowableValue(SSLSecurityProtocol.TLSv1.name(), SSLSecurityProtocol.TLSv1.name());
    public static final AllowableValue SSL_3_VALUE = new AllowableValue(SSLSecurityProtocol.SSLv3.name(), SSLSecurityProtocol.SSLv3.name());
    public static final PropertyDescriptor SECURITY_PROTOCOL = new PropertyDescriptor.Builder().name("Security Protocol").description("The security protocol to use for communicating with Splunk.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(new DescribedValue[]{TLS_1_2_VALUE, TLS_1_1_VALUE, TLS_1_VALUE, SSL_3_VALUE}).defaultValue(TLS_1_2_VALUE.getValue()).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Results retrieved from Splunk are sent out this relationship.").build();
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String EARLIEST_TIME_KEY = "earliestTime";
    public static final String LATEST_TIME_KEY = "latestTime";
    public static final String QUERY_ATTR = "splunk.query";
    public static final String EARLIEST_TIME_ATTR = "splunk.earliest.time";
    public static final String LATEST_TIME_ATTR = "splunk.latest.time";
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SCHEME, HOSTNAME, PORT, CONNECT_TIMEOUT, READ_TIMEOUT, QUERY, TIME_FIELD_STRATEGY, TIME_RANGE_STRATEGY, EARLIEST_TIME, LATEST_TIME, TIME_ZONE, APP, OWNER, TOKEN, USERNAME, PASSWORD, SECURITY_PROTOCOL, OUTPUT_MODE, SSL_CONTEXT_SERVICE);
    private volatile String transitUri;
    private volatile boolean resetState = false;
    private volatile Service splunkService;
    protected final AtomicBoolean isInitialized = new AtomicBoolean(false);

    public final Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String scheme = validationContext.getProperty(SCHEME).getValue();
        String secProtocol = validationContext.getProperty(SECURITY_PROTOCOL).getValue();
        if (HTTPS_SCHEME.equals(scheme) && StringUtils.isBlank((CharSequence)secProtocol)) {
            results.add(new ValidationResult.Builder().explanation("Security Protocol must be specified when using HTTPS").valid(false).subject("Security Protocol").build());
        }
        String username = validationContext.getProperty(USERNAME).getValue();
        String password = validationContext.getProperty(PASSWORD).getValue();
        if (!StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
            results.add(new ValidationResult.Builder().explanation("Password must be specified when providing a Username").valid(false).subject("Password").build());
        }
        return results;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (oldValue != null && !oldValue.equals(newValue) && (descriptor.equals((Object)QUERY) || descriptor.equals((Object)TIME_FIELD_STRATEGY) || descriptor.equals((Object)TIME_RANGE_STRATEGY) || descriptor.equals((Object)EARLIEST_TIME) || descriptor.equals((Object)LATEST_TIME) || descriptor.equals((Object)HOSTNAME))) {
            this.getLogger().debug("A property that require resetting state was modified - {} oldValue {} newValue {}", new Object[]{descriptor.getDisplayName(), oldValue, newValue});
            this.resetState = true;
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        String scheme = context.getProperty(SCHEME).getValue();
        String host = context.getProperty(HOSTNAME).getValue();
        int port = context.getProperty(PORT).asInteger();
        this.transitUri = scheme + "://" + host + ":" + port;
        if (this.resetState) {
            try {
                this.getLogger().debug("Clearing state based on property modifications");
                context.getStateManager().clear(Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().warn("Failed to clear state", (Throwable)ioe);
            }
            this.resetState = false;
        }
    }

    @OnStopped
    public void onStopped() {
        if (this.splunkService != null) {
            this.isInitialized.set(false);
            this.splunkService.logout();
            this.splunkService = null;
        }
    }

    @OnRemoved
    public void onRemoved(ProcessContext context) {
        try {
            context.getStateManager().clear(Scope.CLUSTER);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to clear processor state due to {}", new Object[]{e.getMessage(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        InputStream export;
        String latestTime;
        String earliestTime;
        JobExportArgs exportArgs;
        String timeFieldStrategy;
        String timeRangeStrategy;
        String query;
        block26: {
            OffsetDateTime currentTime = OffsetDateTime.now();
            AtomicBoolean atomicBoolean = this.isInitialized;
            synchronized (atomicBoolean) {
                if (!this.isInitialized.get()) {
                    this.splunkService = this.createSplunkService(context);
                    this.isInitialized.set(true);
                }
            }
            query = context.getProperty(QUERY).getValue();
            String outputMode = context.getProperty(OUTPUT_MODE).getValue();
            timeRangeStrategy = context.getProperty(TIME_RANGE_STRATEGY).getValue();
            String timeZone = context.getProperty(TIME_ZONE).getValue();
            timeFieldStrategy = context.getProperty(TIME_FIELD_STRATEGY).getValue();
            exportArgs = new JobExportArgs();
            exportArgs.setSearchMode(JobExportArgs.SearchMode.NORMAL);
            exportArgs.setOutputMode(JobExportArgs.OutputMode.valueOf((String)outputMode));
            earliestTime = null;
            if (PROVIDED_VALUE.getValue().equals(timeRangeStrategy)) {
                earliestTime = context.getProperty(EARLIEST_TIME).getValue();
                latestTime = context.getProperty(LATEST_TIME).getValue();
            } else {
                try {
                    TimeRange previousRange = this.loadState(session);
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT).withZone(TimeZone.getTimeZone(timeZone).toZoneId());
                    if (previousRange == null) {
                        if (MANAGED_CURRENT_VALUE.getValue().equals(timeRangeStrategy)) {
                            earliestTime = dateTimeFormatter.format(currentTime);
                        }
                        if ((latestTime = dateTimeFormatter.format(currentTime)).equals(earliestTime)) {
                            this.saveState(session, new TimeRange(earliestTime, latestTime));
                            return;
                        }
                        break block26;
                    }
                    try {
                        String previousLastTime = previousRange.getLatestTime();
                        OffsetDateTime previousLastDate = OffsetDateTime.parse(previousLastTime, dateTimeFormatter);
                        earliestTime = dateTimeFormatter.format(previousLastDate.plusSeconds(1L));
                        latestTime = dateTimeFormatter.format(currentTime);
                    }
                    catch (DateTimeParseException e) {
                        throw new ProcessException((Throwable)e);
                    }
                }
                catch (IOException e) {
                    this.getLogger().error("Unable to load data from State Manager due to {}", new Object[]{e.getMessage(), e});
                    context.yield();
                    return;
                }
            }
        }
        if (!StringUtils.isBlank((CharSequence)earliestTime)) {
            if (EVENT_TIME_VALUE.getValue().equalsIgnoreCase(timeFieldStrategy)) {
                exportArgs.setEarliestTime(earliestTime);
            } else {
                exportArgs.setIndexEarliest(earliestTime);
            }
        }
        if (!StringUtils.isBlank((CharSequence)latestTime)) {
            if (EVENT_TIME_VALUE.getValue().equalsIgnoreCase(timeFieldStrategy)) {
                exportArgs.setLatestTime(latestTime);
            } else {
                exportArgs.setIndexLatest(latestTime);
            }
        }
        if (EVENT_TIME_VALUE.getValue().equalsIgnoreCase(timeFieldStrategy)) {
            this.getLogger().debug("Using earliest_time of {} and latest_time of {}", new Object[]{earliestTime, latestTime});
        } else {
            this.getLogger().debug("Using index_earliest of {} and index_latest of {}", new Object[]{earliestTime, latestTime});
        }
        try {
            export = this.splunkService.export(query, exportArgs);
        }
        catch (HttpException e) {
            this.getLogger().error("Splunk request status code:{} Retrying the request.", new Object[]{e.getStatus()});
            this.splunkService.logout();
            this.splunkService = this.createSplunkService(context);
            export = this.splunkService.export(query, exportArgs);
        }
        InputStream exportSearch = export;
        FlowFile flowFile = session.create();
        flowFile = session.write(flowFile, rawOut -> {
            try (BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                IOUtils.copyLarge((InputStream)exportSearch, (OutputStream)out);
            }
        });
        HashMap<String, String> attributes = new HashMap<String, String>(3);
        attributes.put(EARLIEST_TIME_ATTR, earliestTime);
        attributes.put(LATEST_TIME_ATTR, latestTime);
        attributes.put(QUERY_ATTR, query);
        flowFile = session.putAllAttributes(flowFile, attributes);
        session.getProvenanceReporter().receive(flowFile, this.transitUri);
        session.transfer(flowFile, REL_SUCCESS);
        this.getLogger().debug("Received {} from Splunk", new Object[]{flowFile});
        if (!PROVIDED_VALUE.getValue().equals(timeRangeStrategy)) {
            try {
                this.saveState(session, new TimeRange(earliestTime, latestTime));
            }
            catch (IOException e) {
                this.getLogger().error("Unable to load data from State Manager due to {}", new Object[]{e.getMessage(), e});
                session.rollback();
                context.yield();
            }
        }
    }

    protected Service createSplunkService(ProcessContext context) {
        SSLContextProvider sslContextProvider;
        String secProtocol;
        String password;
        String username;
        String token;
        String owner;
        ServiceArgs serviceArgs = new ServiceArgs();
        String scheme = context.getProperty(SCHEME).getValue();
        serviceArgs.setScheme(scheme);
        String host = context.getProperty(HOSTNAME).getValue();
        serviceArgs.setHost(host);
        int port = context.getProperty(PORT).asInteger();
        serviceArgs.setPort(port);
        int connect_timeout = context.getProperty(CONNECT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        serviceArgs.add("connectTimeout", (Object)connect_timeout);
        int read_timeout = context.getProperty(READ_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        serviceArgs.add("readTimeout", (Object)read_timeout);
        String app = context.getProperty(APP).getValue();
        if (!StringUtils.isBlank((CharSequence)app)) {
            serviceArgs.setApp(app);
        }
        if (!StringUtils.isBlank((CharSequence)(owner = context.getProperty(OWNER).getValue()))) {
            serviceArgs.setOwner(owner);
        }
        if (!StringUtils.isBlank((CharSequence)(token = context.getProperty(TOKEN).getValue()))) {
            serviceArgs.setToken(token);
        }
        if (!StringUtils.isBlank((CharSequence)(username = context.getProperty(USERNAME).getValue()))) {
            serviceArgs.setUsername(username);
        }
        if (!StringUtils.isBlank((CharSequence)(password = context.getProperty(PASSWORD).getValue()))) {
            serviceArgs.setPassword(password);
        }
        if (!StringUtils.isBlank((CharSequence)(secProtocol = context.getProperty(SECURITY_PROTOCOL).getValue())) && HTTPS_SCHEME.equals(scheme)) {
            serviceArgs.setSSLSecurityProtocol(SSLSecurityProtocol.valueOf((String)secProtocol));
        }
        if ((sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class)) != null) {
            Service.setSSLSocketFactory((SSLSocketFactory)sslContextProvider.createContext().getSocketFactory());
        }
        return Service.connect((Map)serviceArgs);
    }

    private void saveState(ProcessSession session, TimeRange timeRange) throws IOException {
        String earliest = StringUtils.isBlank((CharSequence)timeRange.getEarliestTime()) ? "" : timeRange.getEarliestTime();
        String latest = StringUtils.isBlank((CharSequence)timeRange.getLatestTime()) ? "" : timeRange.getLatestTime();
        HashMap<String, String> state = new HashMap<String, String>(2);
        state.put(EARLIEST_TIME_KEY, earliest);
        state.put(LATEST_TIME_KEY, latest);
        this.getLogger().debug("Saving state with earliestTime of {} and latestTime of {}", new Object[]{earliest, latest});
        session.setState(state, Scope.CLUSTER);
    }

    private TimeRange loadState(ProcessSession session) throws IOException {
        StateMap stateMap = session.getState(Scope.CLUSTER);
        if (stateMap.getStateVersion().isEmpty()) {
            this.getLogger().debug("No previous state found");
            return null;
        }
        String earliest = stateMap.get(EARLIEST_TIME_KEY);
        String latest = stateMap.get(LATEST_TIME_KEY);
        this.getLogger().debug("Loaded state with earliestTime of {} and latestTime of {}", new Object[]{earliest, latest});
        if (StringUtils.isBlank((CharSequence)earliest) && StringUtils.isBlank((CharSequence)latest)) {
            return null;
        }
        return new TimeRange(earliest, latest);
    }

    public String getClassloaderIsolationKey(PropertyContext context) {
        SSLContextProvider sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        if (sslContextProvider != null) {
            return sslContextProvider.getIdentifier();
        }
        return ((Object)((Object)this)).getClass().getName();
    }

    static class TimeRange {
        final String earliestTime;
        final String latestTime;

        public TimeRange(String earliestTime, String latestTime) {
            this.earliestTime = earliestTime;
            this.latestTime = latestTime;
        }

        public String getEarliestTime() {
            return this.earliestTime;
        }

        public String getLatestTime() {
            return this.latestTime;
        }
    }
}

