/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.splunk;

import com.splunk.RequestMessage;
import com.splunk.ResponseMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.dto.splunk.SendRawDataResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.splunk.QuerySplunkIndexingStatus;
import org.apache.nifi.processors.splunk.SplunkAPICall;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"splunk", "logs", "http"})
@CapabilityDescription(value="Sends flow file content to the specified Splunk server over HTTP or HTTPS. Supports HEC Index Acknowledgement.")
@ReadsAttribute(attribute="mime.type", description="Uses as value for HTTP Content-Type header if set.")
@WritesAttributes(value={@WritesAttribute(attribute="splunk.acknowledgement.id", description="The indexing acknowledgement id provided by Splunk."), @WritesAttribute(attribute="splunk.responded.at", description="The time of the response of put request for Splunk.")})
@SystemResourceConsideration(resource=SystemResource.MEMORY)
@SeeAlso(value={QuerySplunkIndexingStatus.class})
public class PutSplunkHTTP
extends SplunkAPICall {
    private static final String ENDPOINT = "/services/collector/raw";
    static final PropertyDescriptor SOURCE = new PropertyDescriptor.Builder().name("source").displayName("Source").description("User-defined event source. Sets a default for all events when unspecified.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor SOURCE_TYPE = new PropertyDescriptor.Builder().name("source-type").displayName("Source Type").description("User-defined event sourcetype. Sets a default for all events when unspecified.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor HOST = new PropertyDescriptor.Builder().name("host").displayName("Host").description("Specify with the host query string parameter. Sets a default for all events when unspecified.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("index").displayName("Index").description("Index name. Specify with the index query string parameter. Sets a default for all events when unspecified.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("character-set").displayName("Character Set").description("The name of the character set.").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue(Charset.defaultCharset().name()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("content-type").displayName("Content Type").description("The media type of the event sent to Splunk. If not set, \"mime.type\" flow file attribute will be used. In case of neither of them is specified, this information will not be sent to the server.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final Relationship RELATIONSHIP_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are sent successfully to the destination are sent to this relationship.").build();
    static final Relationship RELATIONSHIP_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to send to the destination are sent to this relationship.").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(PutSplunkHTTP.getCommonPropertyDescriptors().stream(), Stream.of(SOURCE, SOURCE_TYPE, HOST, INDEX, CONTENT_TYPE, CHARSET)).toList();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(RELATIONSHIP_SUCCESS, RELATIONSHIP_FAILURE);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ResponseMessage responseMessage = null;
        FlowFile flowFile = session.get();
        boolean success = false;
        if (flowFile == null) {
            return;
        }
        try {
            String endpoint = this.getEndpoint(context, flowFile);
            RequestMessage requestMessage = this.createRequestMessage(session, flowFile, context);
            responseMessage = this.call(endpoint, requestMessage);
            flowFile = session.putAttribute(flowFile, "splunk.status.code", String.valueOf(responseMessage.getStatus()));
            switch (responseMessage.getStatus()) {
                case 200: {
                    SendRawDataResponse successResponse = this.unmarshallResult(responseMessage.getContent(), SendRawDataResponse.class);
                    if (successResponse.getCode() == 0) {
                        flowFile = this.enrichFlowFile(session, flowFile, successResponse.getAckId());
                        success = true;
                        break;
                    }
                    flowFile = session.putAttribute(flowFile, "splunk.response.code", String.valueOf(successResponse.getCode()));
                    this.getLogger().error("Putting data into Splunk was not successful: ({}) {}", new Object[]{successResponse.getCode(), successResponse.getText()});
                    break;
                }
                case 503: {
                    context.yield();
                }
                default: {
                    this.getLogger().error("Putting data into Splunk was not successful. Response with header {} was: {}", new Object[]{responseMessage.getStatus(), IOUtils.toString((InputStream)responseMessage.getContent(), (Charset)StandardCharsets.UTF_8)});
                }
            }
            session.transfer(flowFile, success ? RELATIONSHIP_SUCCESS : RELATIONSHIP_FAILURE);
        }
        catch (Exception e) {
            try {
                this.getLogger().error("Error during communication with Splunk: {}", new Object[]{e.getMessage(), e});
                if (responseMessage != null) {
                    try {
                        this.getLogger().error("The response content is: {}", new Object[]{IOUtils.toString((InputStream)responseMessage.getContent(), (Charset)StandardCharsets.UTF_8)});
                    }
                    catch (IOException ioException) {
                        this.getLogger().error("An error occurred during reading response content!");
                    }
                }
                session.transfer(flowFile, success ? RELATIONSHIP_SUCCESS : RELATIONSHIP_FAILURE);
            }
            catch (Throwable throwable) {
                session.transfer(flowFile, success ? RELATIONSHIP_SUCCESS : RELATIONSHIP_FAILURE);
                throw throwable;
            }
        }
    }

    protected RequestMessage createRequestMessage(ProcessSession session, FlowFile flowFile, ProcessContext context) {
        String contentType;
        RequestMessage requestMessage = new RequestMessage("POST");
        String string = contentType = context.getProperty(CONTENT_TYPE).isSet() ? context.getProperty(CONTENT_TYPE).evaluateAttributeExpressions(flowFile).getValue() : flowFile.getAttribute("mime.type");
        if (contentType != null) {
            requestMessage.getHeader().put("Content-Type", contentType);
        }
        String charset = context.getProperty(CHARSET).evaluateAttributeExpressions(flowFile).getValue();
        requestMessage.setContent(this.extractTextMessageBody(flowFile, session, charset));
        return requestMessage;
    }

    private String extractTextMessageBody(FlowFile flowFile, ProcessSession session, String charset) {
        StringWriter writer = new StringWriter();
        session.read(flowFile, in -> IOUtils.copy((InputStream)in, (Writer)writer, (Charset)Charset.forName(charset)));
        return writer.toString();
    }

    private FlowFile enrichFlowFile(ProcessSession session, FlowFile flowFile, long ackId) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("splunk.acknowledgement.id", String.valueOf(ackId));
        attributes.put("splunk.responded.at", String.valueOf(System.currentTimeMillis()));
        return session.putAllAttributes(flowFile, attributes);
    }

    public String getEndpoint(ProcessContext context, FlowFile flowFile) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (context.getProperty(SOURCE_TYPE).isSet()) {
            queryParameters.put("sourcetype", context.getProperty(SOURCE_TYPE).evaluateAttributeExpressions(flowFile).getValue());
        }
        if (context.getProperty(SOURCE).isSet()) {
            queryParameters.put("source", context.getProperty(SOURCE).evaluateAttributeExpressions(flowFile).getValue());
        }
        if (context.getProperty(HOST).isSet()) {
            queryParameters.put("host", context.getProperty(HOST).evaluateAttributeExpressions(flowFile).getValue());
        }
        if (context.getProperty(INDEX).isSet()) {
            queryParameters.put("index", context.getProperty(INDEX).evaluateAttributeExpressions(flowFile).getValue());
        }
        StringBuilder result = new StringBuilder(ENDPOINT);
        if (!queryParameters.isEmpty()) {
            LinkedList<CallSite> parameters = new LinkedList<CallSite>();
            for (Map.Entry parameter : queryParameters.entrySet()) {
                parameters.add((CallSite)((Object)(URLEncoder.encode((String)parameter.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)parameter.getValue(), StandardCharsets.UTF_8))));
            }
            result.append('?');
            result.append(String.join((CharSequence)"&", parameters));
        }
        return result.toString();
    }
}

