/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Scanner;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.snmp.utils.UsmJsonParser;
import org.apache.nifi.snmp.utils.UsmReader;
import org.snmp4j.security.UsmUser;

public class JsonFileUsmReader
implements UsmReader {
    private final String usmUsersFilePath;

    public JsonFileUsmReader(String usmUsersFilePath) {
        this.usmUsersFilePath = usmUsersFilePath;
    }

    @Override
    public List<UsmUser> readUsm() {
        List<UsmUser> userDetails;
        try (Scanner scanner = new Scanner(new File(this.usmUsersFilePath));){
            String content = scanner.useDelimiter("\\Z").next();
            userDetails = UsmJsonParser.parse(content);
        }
        catch (FileNotFoundException e) {
            throw new ProcessException("USM user file not found, please check the file path and file permissions.", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new ProcessException("Could not parse USM user file, please check the processor details for examples.", (Throwable)e);
        }
        return userDetails;
    }
}

