/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.snmp.configuration.V1TrapConfiguration;
import org.apache.nifi.snmp.configuration.V2TrapConfiguration;
import org.apache.nifi.snmp.factory.trap.V1TrapPDUFactory;
import org.apache.nifi.snmp.factory.trap.V2TrapPDUFactory;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;

public class SendTrapSNMPHandler {
    private final ComponentLog logger;
    private final Snmp snmpManager;
    private final Instant startTime;

    public SendTrapSNMPHandler(Snmp snmpManager, Instant startTime, ComponentLog logger) {
        this.snmpManager = snmpManager;
        this.logger = logger;
        this.startTime = startTime;
    }

    public void sendTrap(Map<String, String> flowFileAttributes, V1TrapConfiguration trapConfiguration, Target target) throws IOException {
        PDU pdu = this.createV1TrapPduFactory(target, this.startTime).get(trapConfiguration);
        this.sendTrap(flowFileAttributes, pdu, target);
    }

    public void sendTrap(Map<String, String> flowFileAttributes, V2TrapConfiguration trapConfiguration, Target target) throws IOException {
        PDU pdu = this.createV2TrapPduFactory(target, this.startTime).get(trapConfiguration);
        this.sendTrap(flowFileAttributes, pdu, target);
    }

    private void sendTrap(Map<String, String> flowFileAttributes, PDU pdu, Target target) throws IOException {
        boolean isAnyVariableAdded = SNMPUtils.addVariables(pdu, flowFileAttributes);
        if (!isAnyVariableAdded) {
            this.logger.debug("No optional SNMP specific variables found in flowfile.");
        }
        this.snmpManager.send(pdu, target);
    }

    V1TrapPDUFactory createV1TrapPduFactory(Target target, Instant startTime) {
        return new V1TrapPDUFactory(target, startTime);
    }

    V2TrapPDUFactory createV2TrapPduFactory(Target target, Instant startTime) {
        return new V2TrapPDUFactory(target, startTime);
    }
}

