/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.factory.core;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMPManagerFactory {
    private static final String ALL_ADDRESSES = "0.0.0.0";

    public Snmp createSnmpManagerInstance(SNMPConfiguration configuration) {
        Snmp snmpManager;
        int port = configuration.getManagerPort();
        try {
            InetAddress listenAddress = InetAddress.getByName(ALL_ADDRESSES);
            UdpAddress udpAddress = new UdpAddress(listenAddress, port);
            DefaultUdpTransportMapping transportMapping = new DefaultUdpTransportMapping(udpAddress);
            snmpManager = new Snmp((TransportMapping)transportMapping);
            snmpManager.listen();
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        return snmpManager;
    }
}

