/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.factory.core.SNMPManagerFactory;
import org.apache.nifi.snmp.operations.SNMPTrapReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;

public class SNMPTrapReceiverHandler {
    private static final Logger logger = LoggerFactory.getLogger(SNMPTrapReceiverHandler.class);
    private final SNMPConfiguration configuration;
    private final List<UsmUser> usmUsers;
    private Snmp snmpManager;
    private boolean isStarted;

    public SNMPTrapReceiverHandler(SNMPConfiguration configuration, List<UsmUser> usmUsers) {
        this.configuration = configuration;
        this.usmUsers = usmUsers;
        this.snmpManager = new SNMPManagerFactory().createSnmpManagerInstance(configuration);
    }

    public int getListeningPort() {
        Collection transportMappings = this.snmpManager.getMessageDispatcher().getTransportMappings();
        if (transportMappings == null || transportMappings.isEmpty()) {
            return 0;
        }
        Address address = ((TransportMapping)transportMappings.iterator().next()).getListenAddress();
        if (address instanceof TransportIpAddress) {
            return ((TransportIpAddress)address).getPort();
        }
        return 0;
    }

    public void createTrapReceiver(ProcessSessionFactory processSessionFactory, ComponentLog logger) {
        int version = this.configuration.getVersion();
        if (version == 3) {
            this.addUsmUsers();
        }
        SNMPTrapReceiver trapReceiver = new SNMPTrapReceiver(processSessionFactory, this.configuration, logger);
        this.snmpManager.addCommandResponder((CommandResponder)trapReceiver);
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void close() {
        try {
            if (this.snmpManager.getUSM() != null) {
                this.snmpManager.getUSM().removeAllUsers();
                SecurityModels.getInstance().removeSecurityModel(new Integer32(this.snmpManager.getUSM().getID()));
            }
            this.snmpManager.close();
            this.isStarted = false;
        }
        catch (IOException e) {
            String errorMessage = "Could not close SNMP manager.";
            logger.error("Could not close SNMP manager.", (Throwable)e);
            throw new ProcessException("Could not close SNMP manager.");
        }
    }

    private void addUsmUsers() {
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        this.usmUsers.forEach(user -> this.snmpManager.getUSM().addUser(user));
    }

    void setSnmpManager(Snmp snmpManager) {
        this.snmpManager = snmpManager;
    }
}

