/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.factory.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.snmp.exception.InvalidSnmpVersionException;
import org.apache.nifi.snmp.factory.core.SNMPContext;
import org.apache.nifi.snmp.factory.core.SNMPManagerFactory;
import org.apache.nifi.snmp.factory.core.V1V2cSNMPFactory;
import org.apache.nifi.snmp.factory.core.V3SNMPFactory;

public class SNMPFactoryProvider {
    private static final String INVALID_SNMP_VERSION = "SNMP version is not supported: %s";
    private static final Map<Integer, SNMPContext> FACTORIES;

    private SNMPFactoryProvider() {
    }

    public static SNMPContext getFactory(int version) {
        return Optional.ofNullable(FACTORIES.get(version)).orElseThrow(() -> new InvalidSnmpVersionException(String.format(INVALID_SNMP_VERSION, version)));
    }

    static {
        HashMap<Integer, SNMPManagerFactory> factories = new HashMap<Integer, SNMPManagerFactory>();
        factories.put(0, new V1V2cSNMPFactory());
        factories.put(1, new V1V2cSNMPFactory());
        factories.put(3, new V3SNMPFactory());
        FACTORIES = Collections.unmodifiableMap(factories);
    }
}

