/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.processors.ListenTrapSNMP;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;

public class SNMPTrapReceiver
implements CommandResponder {
    private final ProcessSessionFactory processSessionFactory;
    private final ComponentLog logger;
    private final SNMPConfiguration configuration;

    public SNMPTrapReceiver(ProcessSessionFactory processSessionFactory, SNMPConfiguration configuration, ComponentLog logger) {
        this.processSessionFactory = processSessionFactory;
        this.logger = logger;
        this.configuration = configuration;
    }

    public void processPdu(CommandResponderEvent event) {
        int expectedSecurityLevel;
        int receivedVersion;
        PDU pdu = event.getPDU();
        int expectedVersion = this.configuration.getVersion();
        if (expectedVersion != (receivedVersion = event.getMessageProcessingModel())) {
            this.logger.debug("Ignoring trap: Expected version {} but received {}", new Object[]{expectedVersion, receivedVersion});
            return;
        }
        int receivedSecurityLevel = event.getSecurityLevel();
        if (expectedVersion == 3 && (expectedSecurityLevel = SecurityLevel.valueOf((String)this.configuration.getSecurityLevel()).getSnmpValue()) != receivedSecurityLevel) {
            this.logger.debug("Ignoring SNMPv3 trap: Expected security level {} but received {}", new Object[]{expectedSecurityLevel, receivedSecurityLevel});
            return;
        }
        if (this.isValidTrapPdu(pdu)) {
            ProcessSession processSession = this.processSessionFactory.createSession();
            FlowFile flowFile = this.createFlowFile(processSession, event);
            processSession.getProvenanceReporter().create(flowFile, String.valueOf(event.getPeerAddress()) + "/" + String.valueOf(pdu.getRequestID()));
            if (pdu.getErrorStatus() == 0) {
                processSession.transfer(flowFile, ListenTrapSNMP.REL_SUCCESS);
            } else {
                processSession.transfer(flowFile, ListenTrapSNMP.REL_FAILURE);
            }
            processSession.commitAsync();
        } else {
            this.logger.error("Request timed out or parameters are incorrect.");
        }
    }

    private FlowFile createFlowFile(ProcessSession processSession, CommandResponderEvent event) {
        FlowFile flowFile = processSession.create();
        PDU pdu = event.getPDU();
        Address peerAddress = event.getPeerAddress();
        Map<String, String> attributes = pdu instanceof PDUv1 ? SNMPUtils.getV1TrapPduAttributeMap((PDUv1)pdu) : SNMPUtils.getPduAttributeMap(pdu);
        if (peerAddress.isValid()) {
            processSession.putAttribute(flowFile, "snmp$peerAddress", peerAddress.toString());
        }
        flowFile = processSession.putAllAttributes(flowFile, attributes);
        return flowFile;
    }

    private boolean isValidTrapPdu(PDU pdu) {
        return pdu != null && (pdu.getType() == -92 || pdu.getType() == -89);
    }
}

