/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.configuration;

public class SNMPConfiguration {
    private final int managerPort;
    private final String targetHost;
    private final String targetPort;
    private final int retries;
    private final long timeoutInMs;
    private final int version;
    private final String authProtocol;
    private final String authPassphrase;
    private final String privacyProtocol;
    private final String privacyPassphrase;
    private final String securityName;
    private final String securityLevel;
    private final String communityString;

    SNMPConfiguration(int managerPort, String targetHost, String targetPort, int retries, long timeoutInMs, int version, String authProtocol, String authPassphrase, String privacyProtocol, String privacyPassphrase, String securityName, String securityLevel, String communityString) {
        this.managerPort = managerPort;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.retries = retries;
        this.timeoutInMs = timeoutInMs;
        this.version = version;
        this.authProtocol = authProtocol;
        this.authPassphrase = authPassphrase;
        this.privacyProtocol = privacyProtocol;
        this.privacyPassphrase = privacyPassphrase;
        this.securityName = securityName;
        this.securityLevel = securityLevel;
        this.communityString = communityString;
    }

    public int getManagerPort() {
        return this.managerPort;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public String getTargetPort() {
        return this.targetPort;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public int getVersion() {
        return this.version;
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public String getAuthPassphrase() {
        return this.authPassphrase;
    }

    public String getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public String getPrivacyPassphrase() {
        return this.privacyPassphrase;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public String getCommunityString() {
        return this.communityString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int managerPort;
        private String targetHost;
        private String targetPort;
        private int retries;
        private long timeoutInMs = 500L;
        private int version;
        private String authProtocol;
        private String authPassphrase;
        private String privacyProtocol;
        private String privacyPassphrase;
        private String securityName;
        private String securityLevel;
        private String communityString;

        public Builder setManagerPort(int managerPort) {
            this.managerPort = managerPort;
            return this;
        }

        public Builder setTargetHost(String targetHost) {
            this.targetHost = targetHost;
            return this;
        }

        public Builder setTargetPort(String targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        public Builder setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder setTimeoutInMs(long timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setAuthProtocol(String authProtocol) {
            this.authProtocol = authProtocol;
            return this;
        }

        public Builder setAuthPassphrase(String authPassphrase) {
            this.authPassphrase = authPassphrase;
            return this;
        }

        public Builder setPrivacyProtocol(String privacyProtocol) {
            this.privacyProtocol = privacyProtocol;
            return this;
        }

        public Builder setPrivacyPassphrase(String privacyPassphrase) {
            this.privacyPassphrase = privacyPassphrase;
            return this;
        }

        public Builder setSecurityName(String securityName) {
            this.securityName = securityName;
            return this;
        }

        public Builder setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        public Builder setCommunityString(String communityString) {
            this.communityString = communityString;
            return this;
        }

        public SNMPConfiguration build() {
            return new SNMPConfiguration(this.managerPort, this.targetHost, this.targetPort, this.retries, this.timeoutInMs, this.version, this.authProtocol, this.authPassphrase, this.privacyProtocol, this.privacyPassphrase, this.securityName, this.securityLevel, this.communityString);
        }
    }
}

