/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.factory.core;

import java.util.Optional;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.factory.core.SNMPContext;
import org.apache.nifi.snmp.factory.core.SNMPManagerFactory;
import org.apache.nifi.snmp.processors.properties.AuthenticationProtocol;
import org.apache.nifi.snmp.processors.properties.PrivacyProtocol;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class V3SNMPFactory
extends SNMPManagerFactory
implements SNMPContext {
    @Override
    public Snmp createSnmpManagerInstance(SNMPConfiguration configuration) {
        Snmp snmpManager = super.createSnmpManagerInstance(configuration);
        this.initializeUsm();
        this.addUsmUserIfSecure(snmpManager, configuration);
        return snmpManager;
    }

    public Target<?> createTargetInstance(SNMPConfiguration configuration) {
        UserTarget userTarget = new UserTarget();
        this.setupTargetBasicProperties((Target)userTarget, configuration);
        int securityLevel = SecurityLevel.valueOf((String)configuration.getSecurityLevel()).getSnmpValue();
        userTarget.setSecurityLevel(securityLevel);
        String securityName = configuration.getSecurityName();
        Optional.ofNullable(securityName).map(OctetString::new).ifPresent(arg_0 -> ((UserTarget)userTarget).setSecurityName(arg_0));
        return userTarget;
    }

    private void initializeUsm() {
        OctetString localEngineId = new OctetString(MPv3.createLocalEngineID());
        USM usm = new USM(SecurityProtocols.getInstance(), localEngineId, 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
    }

    private void addUsmUserIfSecure(Snmp snmpManager, SNMPConfiguration configuration) {
        Optional.ofNullable(configuration.getSecurityName()).map(OctetString::new).ifPresent(securityName -> this.addUserToUsm(snmpManager, configuration, (OctetString)securityName));
    }

    private void addUserToUsm(Snmp snmpManager, SNMPConfiguration configuration, OctetString securityName) {
        OID authProtocol = this.getAuthProtocol(configuration);
        OctetString authPassphrase = this.getOctetString(configuration.getAuthPassphrase());
        OID privacyProtocol = this.getPrivacyProtocol(configuration);
        OctetString privacyPassphrase = this.getOctetString(configuration.getPrivacyPassphrase());
        UsmUser user = new UsmUser(securityName, authProtocol, authPassphrase, privacyProtocol, privacyPassphrase);
        snmpManager.getUSM().addUser(user);
    }

    private OID getAuthProtocol(SNMPConfiguration configuration) {
        return Optional.ofNullable(configuration.getAuthProtocol()).map(AuthenticationProtocol::valueOf).map(AuthenticationProtocol::getOid).orElse(null);
    }

    private OID getPrivacyProtocol(SNMPConfiguration configuration) {
        return Optional.ofNullable(configuration.getPrivacyProtocol()).map(PrivacyProtocol::valueOf).map(PrivacyProtocol::getOid).orElse(null);
    }

    private OctetString getOctetString(String value) {
        return Optional.ofNullable(value).map(OctetString::new).orElse(null);
    }
}

