/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.smb.util;

import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.smb.PutSmbFile;

public class HostnameAndShareFlowFileFilter
implements FlowFileFilter {
    private final ProcessContext context;
    private final int batchSize;
    private HostSharePair selectedHostSharePair;
    private int count = 0;

    public HostnameAndShareFlowFileFilter(ProcessContext context, int batchSize) {
        this.context = context;
        this.batchSize = batchSize;
    }

    public FlowFileFilter.FlowFileFilterResult filter(FlowFile flowFile) {
        HostSharePair hostSharePair = this.getFlowFileHostSharePair(flowFile);
        if (this.selectedHostSharePair == null) {
            this.selectedHostSharePair = hostSharePair;
        }
        if (this.count >= this.batchSize) {
            return FlowFileFilter.FlowFileFilterResult.REJECT_AND_TERMINATE;
        }
        if (this.selectedHostSharePair.hostName().equals(hostSharePair.hostName()) && this.selectedHostSharePair.share().equals(hostSharePair.share())) {
            ++this.count;
            return FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE;
        }
        return FlowFileFilter.FlowFileFilterResult.REJECT_AND_CONTINUE;
    }

    private HostSharePair getFlowFileHostSharePair(FlowFile flowFile) {
        String hostName = this.context.getProperty(PutSmbFile.HOSTNAME).evaluateAttributeExpressions(flowFile).getValue();
        String share = this.context.getProperty(PutSmbFile.SHARE).evaluateAttributeExpressions(flowFile).getValue();
        return new HostSharePair(hostName, share);
    }

    public String getHostName() {
        return this.selectedHostSharePair.hostName();
    }

    public String getShare() {
        return this.selectedHostSharePair.share();
    }

    record HostSharePair(String hostName, String share) {
    }
}

