/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.smb;

import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.smb.FetchSmb;
import org.apache.nifi.processors.smb.GetSmbFile;
import org.apache.nifi.processors.smb.PutSmbFile;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.services.smb.SmbClientProviderService;
import org.apache.nifi.services.smb.SmbClientService;
import org.apache.nifi.services.smb.SmbListableEntity;

@PrimaryNodeOnly
@TriggerSerially
@Tags(value={"samba, smb, cifs, files", "list"})
@SeeAlso(value={PutSmbFile.class, GetSmbFile.class, FetchSmb.class})
@CapabilityDescription(value="Lists concrete files shared via SMB protocol. Each listed file may result in one flowfile, the metadata being written as flowfile attributes. Or - in case the 'Record Writer' property is set - the entire result is written as records to a single flowfile. This Processor is designed to run on Primary Node only in a cluster. If the primary node changes, the new Primary Node will pick up where the previous node left off without duplicating all of the data.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="The name of the file that was read from filesystem."), @WritesAttribute(attribute="shortName", description="The short name of the file that was read from filesystem."), @WritesAttribute(attribute="path", description="The path is set to the relative path of the file's directory on the remote filesystem compared to the Share root directory. For example, for a given remote locationsmb://HOSTNAME:PORT/SHARE/DIRECTORY, and a file is being listed from smb://HOSTNAME:PORT/SHARE/DIRECTORY/sub/folder/file then the path attribute will be set to \"DIRECTORY/sub/folder\"."), @WritesAttribute(attribute="serviceLocation", description="The SMB URL of the share."), @WritesAttribute(attribute="lastModifiedTime", description="The timestamp of when the file's content changed in the filesystem as 'yyyy-MM-dd'T'HH:mm:ss'."), @WritesAttribute(attribute="creationTime", description="The timestamp of when the file was created in the filesystem as 'yyyy-MM-dd'T'HH:mm:ss'."), @WritesAttribute(attribute="lastAccessTime", description="The timestamp of when the file was accessed in the filesystem as 'yyyy-MM-dd'T'HH:mm:ss'."), @WritesAttribute(attribute="changeTime", description="The timestamp of when the file's attributes was changed in the filesystem as 'yyyy-MM-dd'T'HH:mm:ss'."), @WritesAttribute(attribute="size", description="The size of the file in bytes."), @WritesAttribute(attribute="allocationSize", description="The number of bytes allocated for the file on the server.")})
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of files, the state of the previous listing can be stored in order to list files continuously without duplication.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListSmb
extends AbstractListProcessor<SmbListableEntity> {
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().displayName("Input Directory").name("directory").description("The network folder from which to list files. This is the remaining relative path after the share: smb://HOSTNAME:PORT/SHARE/[DIRECTORY]/sub/directories. It is also possible to add subdirectories. The given path on the remote file share must exist. This can be checked using verification. You may mix Windows and Linux-style directory separators.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor MINIMUM_AGE = new PropertyDescriptor.Builder().displayName("Minimum File Age").name("min-file-age").description("The minimum age that a file must be in order to be listed; any file younger than this amount of time will be ignored.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("5 secs").build();
    public static final PropertyDescriptor MAXIMUM_AGE = new PropertyDescriptor.Builder().displayName("Maximum File Age").name("max-file-age").description("Any file older than the given value will be omitted.").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor MINIMUM_SIZE = new PropertyDescriptor.Builder().displayName("Minimum File Size").name("min-file-size").description("Any file smaller than the given value will be omitted.").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor MAXIMUM_SIZE = new PropertyDescriptor.Builder().displayName("Maximum File Size").name("max-file-size").description("Any file larger than the given value will be omitted.").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor SMB_LISTING_STRATEGY = new PropertyDescriptor.Builder().fromPropertyDescriptor(LISTING_STRATEGY).allowableValues(new DescribedValue[]{BY_ENTITIES, NO_TRACKING, BY_TIMESTAMPS}).build();
    public static final PropertyDescriptor SMB_CLIENT_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("smb-client-provider-service").displayName("SMB Client Provider Service").description("Specifies the SMB client provider to use for creating SMB connections.").required(true).identifiesControllerService(SmbClientProviderService.class).build();
    public static final PropertyDescriptor FILE_NAME_SUFFIX_FILTER = new PropertyDescriptor.Builder().name("file-name-suffix-filter").displayName("File Name Suffix Filter").description("Files ending with the given suffix will be omitted. Can be used to make sure that files that are still uploading are not listed multiple times, by having those files have a suffix and remove the suffix once the upload finishes. This is highly recommended when using 'Tracking Entities' or 'Tracking Timestamps' listing strategies.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator((Validator)new MustNotContainDirectorySeparatorsValidator()).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SMB_CLIENT_PROVIDER_SERVICE, SMB_LISTING_STRATEGY, DIRECTORY, FILE_NAME_SUFFIX_FILTER, AbstractListProcessor.RECORD_WRITER, MINIMUM_AGE, MAXIMUM_AGE, MINIMUM_SIZE, MAXIMUM_SIZE, AbstractListProcessor.TARGET_SYSTEM_TIMESTAMP_PRECISION, ListedEntityTracker.TRACKING_STATE_CACHE, ListedEntityTracker.TRACKING_TIME_WINDOW, ListedEntityTracker.INITIAL_LISTING_TARGET);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Map<String, String> createAttributes(SmbListableEntity entity, ProcessContext context) {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        SmbClientProviderService clientProviderService = (SmbClientProviderService)context.getProperty(SMB_CLIENT_PROVIDER_SERVICE).asControllerService(SmbClientProviderService.class);
        attributes.put("filename", entity.getName());
        attributes.put("shortName", entity.getShortName());
        attributes.put("path", entity.getPath());
        attributes.put("serviceLocation", clientProviderService.getServiceLocation().toString());
        attributes.put("lastModifiedTime", this.formatTimeStamp(entity.getLastModifiedTime()));
        attributes.put("creationTime", this.formatTimeStamp(entity.getCreationTime()));
        attributes.put("lastAccessTime", this.formatTimeStamp(entity.getLastAccessTime()));
        attributes.put("changeTime", this.formatTimeStamp(entity.getChangeTime()));
        attributes.put("size", String.valueOf(entity.getSize()));
        attributes.put("allocationSize", String.valueOf(entity.getAllocationSize()));
        return Collections.unmodifiableMap(attributes);
    }

    protected String getPath(ProcessContext context) {
        SmbClientProviderService clientProviderService = (SmbClientProviderService)context.getProperty(SMB_CLIENT_PROVIDER_SERVICE).asControllerService(SmbClientProviderService.class);
        URI serviceLocation = clientProviderService.getServiceLocation();
        String directory = this.getDirectory(context);
        return String.format("%s/%s", serviceLocation.toString(), directory.isEmpty() ? "" : directory + "/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<SmbListableEntity> performListing(ProcessContext context, Long minimumTimestampOrNull, AbstractListProcessor.ListingMode listingMode) throws IOException {
        Predicate<SmbListableEntity> fileFilter = this.createFileFilter(context, minimumTimestampOrNull);
        try (Stream<SmbListableEntity> listing = this.performListing(context);){
            List<Object> list;
            Iterator iterator = listing.iterator();
            LinkedList<SmbListableEntity> result = new LinkedList<SmbListableEntity>();
            while (iterator.hasNext()) {
                if (this.isExecutionStopped(listingMode)) {
                    list = Collections.emptyList();
                    return list;
                }
                SmbListableEntity entity = (SmbListableEntity)iterator.next();
                if (!fileFilter.test(entity)) continue;
                result.add(entity);
            }
            list = result;
            return list;
        }
        catch (Exception e) {
            throw new IOException("Could not perform listing", e);
        }
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return Arrays.asList(SMB_CLIENT_PROVIDER_SERVICE, DIRECTORY, FILE_NAME_SUFFIX_FILTER).contains(property);
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected RecordSchema getRecordSchema() {
        return SmbListableEntity.getRecordSchema();
    }

    protected Integer countUnfilteredListing(ProcessContext context) throws IOException {
        Integer n;
        block8: {
            Stream<SmbListableEntity> listing = this.performListing(context);
            try {
                n = Long.valueOf(listing.count()).intValue();
                if (listing == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (listing != null) {
                        try {
                            listing.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Could not count files", e);
                }
            }
            listing.close();
        }
        return n;
    }

    protected String getListingContainerName(ProcessContext context) {
        return String.format("Remote Directory [%s]", this.getPath(context));
    }

    private String formatTimeStamp(long timestamp) {
        return DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(timestamp), 0, ZoneOffset.UTC));
    }

    private boolean isExecutionStopped(AbstractListProcessor.ListingMode listingMode) {
        return AbstractListProcessor.ListingMode.EXECUTION.equals((Object)listingMode) && !this.isScheduled();
    }

    private Predicate<SmbListableEntity> createFileFilter(ProcessContext context, Long minTimestampOrNull) {
        Long minimumAge = context.getProperty(MINIMUM_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        Long maximumAgeOrNull = context.getProperty(MAXIMUM_AGE).isSet() ? context.getProperty(MAXIMUM_AGE).asTimePeriod(TimeUnit.MILLISECONDS) : null;
        Double minimumSizeOrNull = context.getProperty(MINIMUM_SIZE).isSet() ? context.getProperty(MINIMUM_SIZE).asDataSize(DataUnit.B) : null;
        Double maximumSizeOrNull = context.getProperty(MAXIMUM_SIZE).isSet() ? context.getProperty(MAXIMUM_SIZE).asDataSize(DataUnit.B) : null;
        String suffixOrNull = context.getProperty(FILE_NAME_SUFFIX_FILTER).getValue();
        long now = this.getCurrentTime();
        Predicate<SmbListableEntity> filter = entity -> now - entity.getLastModifiedTime() >= minimumAge;
        if (maximumAgeOrNull != null) {
            filter = filter.and(entity -> now - entity.getLastModifiedTime() <= maximumAgeOrNull);
        }
        if (minTimestampOrNull != null) {
            filter = filter.and(entity -> entity.getLastModifiedTime() >= minTimestampOrNull);
        }
        if (minimumSizeOrNull != null) {
            filter = filter.and(entity -> (double)entity.getSize() >= minimumSizeOrNull);
        }
        if (maximumSizeOrNull != null) {
            filter = filter.and(entity -> (double)entity.getSize() <= maximumSizeOrNull);
        }
        if (suffixOrNull != null) {
            filter = filter.and(entity -> !entity.getName().endsWith(suffixOrNull));
        }
        return filter;
    }

    private Stream<SmbListableEntity> performListing(ProcessContext context) throws IOException {
        SmbClientProviderService clientProviderService = (SmbClientProviderService)context.getProperty(SMB_CLIENT_PROVIDER_SERVICE).asControllerService(SmbClientProviderService.class);
        String directory = this.getDirectory(context);
        SmbClientService clientService = clientProviderService.getClient();
        return (Stream)clientService.listFiles(directory).onClose(() -> {
            try {
                clientService.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not close SMB client", e);
            }
        });
    }

    private String getDirectory(ProcessContext context) {
        PropertyValue property = context.getProperty(DIRECTORY);
        String directory = property.isSet() ? property.getValue().replace('\\', '/') : "";
        return "/".equals(directory) ? "" : directory;
    }

    private static class MustNotContainDirectorySeparatorsValidator
    implements Validator {
        private MustNotContainDirectorySeparatorsValidator() {
        }

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            return new ValidationResult.Builder().subject(subject).input(value).valid(!value.contains("/") && !value.contains("\\")).explanation(subject + " must not contain any folder separator character.").build();
        }
    }
}

