/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.slack;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.OptionalLong;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.services.slack.PostMessageResponse;
import org.apache.nifi.services.slack.SlackRestServiceException;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

public class SlackRestService {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String POST_MESSAGE_PATH = "chat.postMessage";
    private final WebClientServiceProvider webClientServiceProvider;
    private final String accessToken;
    private final String apiUrl;
    private final ComponentLog logger;
    private final String charset;

    public SlackRestService(WebClientServiceProvider webClientServiceProvider, String accessToken, String apiUrl, String charset, ComponentLog logger) {
        this.webClientServiceProvider = webClientServiceProvider;
        this.accessToken = accessToken;
        this.apiUrl = apiUrl;
        this.charset = charset;
        this.logger = logger;
    }

    public void sendMessageToChannel(String message, String channel) throws SlackRestServiceException {
        ByteArrayInputStream requestBodyInputStream;
        URI apiUri = URI.create(this.apiUrl);
        HttpUriBuilder uriBuilder = this.webClientServiceProvider.getHttpUriBuilder().scheme(apiUri.getScheme()).host(apiUri.getHost()).encodedPath(apiUri.getPath()).addPathSegment(POST_MESSAGE_PATH);
        if (apiUri.getPort() != -1) {
            uriBuilder.port(apiUri.getPort());
        }
        URI uri = uriBuilder.build();
        ObjectNode requestBodyJson = this.createRequestBody(channel, message);
        try {
            requestBodyInputStream = new ByteArrayInputStream(objectMapper.writeValueAsBytes((Object)requestBodyJson));
        }
        catch (JsonProcessingException e) {
            throw new SlackRestServiceException("JSON message serialization failed", e);
        }
        try (HttpResponseEntity response = this.webClientServiceProvider.getWebClientService().post().uri(uri).header("Authorization", String.format("Bearer %s", this.accessToken)).header("Content-Type", String.format("application/json; charset=\"%s\"", this.charset)).body((InputStream)requestBodyInputStream, OptionalLong.of(((InputStream)requestBodyInputStream).available())).retrieve();){
            int statusCode = response.statusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new SlackRestServiceException("HTTP error code: " + statusCode);
            }
            try {
                PostMessageResponse slackResponse = (PostMessageResponse)objectMapper.readValue(response.body(), PostMessageResponse.class);
                this.checkResponse(slackResponse, channel);
            }
            catch (IOException e) {
                throw new SlackRestServiceException("JSON response parsing failed", e);
            }
        }
        catch (IOException e) {
            throw new ProcessException("Slack HTTP request failed", (Throwable)e);
        }
    }

    private ObjectNode createRequestBody(String channel, String message) {
        ObjectNode requestBodyJson = objectMapper.createObjectNode();
        requestBodyJson.put("channel", channel);
        requestBodyJson.put("text", message);
        return requestBodyJson;
    }

    private void checkResponse(PostMessageResponse response, String channel) throws SlackRestServiceException {
        if (!response.isOk()) {
            throw new SlackRestServiceException("Slack error response: " + response.getError());
        }
        if (response.getWarning() != null) {
            this.logger.warn("Post message to channel [{}] warning: {}", new Object[]{channel, response.getWarning()});
        }
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

